/*
 * Decompiled with CFR 0.152.
 */
package com.anaplan.connector.utils;

import com.anaplan.client.AnaplanAPIException;
import com.anaplan.client.Export;
import com.anaplan.client.ExportMetadata;
import com.anaplan.client.Model;
import com.anaplan.client.ServerFile;
import com.anaplan.client.Task;
import com.anaplan.client.TaskStatus;
import com.anaplan.connector.MulesoftAnaplanResponse;
import com.anaplan.connector.connection.AnaplanConnection;
import com.anaplan.connector.exceptions.AnaplanOperationException;
import com.anaplan.connector.utils.AnaplanUtil;
import com.anaplan.connector.utils.BaseAnaplanOperation;
import com.anaplan.connector.utils.UserMessages;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AnaplanExportOperation
extends BaseAnaplanOperation {
    private static Logger logger = LogManager.getLogger((String)AnaplanExportOperation.class.getName());

    public AnaplanExportOperation(AnaplanConnection apiConn) {
        super(apiConn);
    }

    private static MulesoftAnaplanResponse doExport(Model model, String exportId) throws AnaplanOperationException {
        ExportMetadata exportMetadata;
        TaskStatus status;
        Export exp;
        try {
            exp = model.getExport(exportId);
        }
        catch (AnaplanAPIException e) {
            throw new AnaplanOperationException("Error fetching Export action:", e);
        }
        if (exp == null) {
            throw new AnaplanOperationException(UserMessages.getMessage("invalidExport", exportId));
        }
        try {
            Task task = exp.createTask();
            status = AnaplanUtil.runServerTask(task);
        }
        catch (AnaplanAPIException e) {
            throw new AnaplanOperationException("Error running Export action:", e);
        }
        try {
            exportMetadata = exp.getExportMetadata();
        }
        catch (AnaplanAPIException e) {
            throw new AnaplanOperationException("Error fetching Export-metadata!");
        }
        if (status.getTaskState() == TaskStatus.State.COMPLETE && status.getResult().isSuccessful()) {
            ServerFile serverFile;
            logger.info("Export completed successfully!");
            try {
                serverFile = model.getServerFile(exp.getName());
                if (serverFile == null) {
                    throw new AnaplanOperationException(UserMessages.getMessage("exportRetrieveError", exp.getName()));
                }
            }
            catch (AnaplanAPIException e) {
                throw new AnaplanOperationException("Error fetching export Server-File:", e);
            }
            AnaplanExportOperation.setRunStatusDetails(AnaplanExportOperation.collectTaskLogs(status));
            logger.info(AnaplanExportOperation.getRunStatusDetails());
            return MulesoftAnaplanResponse.exportSuccess(status.getTaskState().name(), serverFile, exportMetadata);
        }
        logger.error("Export failed !!!");
        return MulesoftAnaplanResponse.exportFailure(status.getTaskState().name(), exportMetadata, null);
    }

    public String runExport(String workspaceId, String modelId, String exportId) throws AnaplanOperationException {
        String exportData;
        String response;
        logger.info("<< Starting export >>");
        logger.info("Workspace-ID: {}", new Object[]{workspaceId});
        logger.info("Model-ID: {}", new Object[]{modelId});
        logger.info("Export-ID: {}", new Object[]{exportId});
        this.validateInput(workspaceId, modelId);
        MulesoftAnaplanResponse anaplanResponse = null;
        try {
            anaplanResponse = AnaplanExportOperation.doExport(this.model, exportId);
            response = this.createResponse(anaplanResponse);
            exportData = anaplanResponse.writeExportData(this.apiConn);
            logger.info("Query complete: Status: {}, Response message: {}", new Object[]{anaplanResponse.getStatus(), anaplanResponse.getResponseMessage()});
        }
        catch (AnaplanAPIException | IOException e) {
            throw new AnaplanOperationException(e.getMessage(), e);
        }
        finally {
            this.apiConn.closeConnection();
        }
        logger.info("{}", new Object[]{response});
        return exportData;
    }
}

