/*
 * Decompiled with CFR 0.152.
 */
package com.anaplan.connector.utils;

import com.anaplan.client.Action;
import com.anaplan.client.AnaplanAPIException;
import com.anaplan.client.Model;
import com.anaplan.client.Task;
import com.anaplan.client.TaskStatus;
import com.anaplan.connector.MulesoftAnaplanResponse;
import com.anaplan.connector.connection.AnaplanConnection;
import com.anaplan.connector.exceptions.AnaplanOperationException;
import com.anaplan.connector.utils.AnaplanUtil;
import com.anaplan.connector.utils.BaseAnaplanOperation;
import com.anaplan.connector.utils.UserMessages;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AnaplanDeleteOperation
extends BaseAnaplanOperation {
    private static Logger logger = LogManager.getLogger((String)AnaplanDeleteOperation.class.getName());

    public AnaplanDeleteOperation(AnaplanConnection apiConn) {
        super(apiConn);
    }

    private static MulesoftAnaplanResponse runDeleteAction(Model model, String actionId) throws AnaplanAPIException {
        Action action = model.getAction(actionId);
        if (action == null) {
            String msg = UserMessages.getMessage("invalidAction", actionId);
            return MulesoftAnaplanResponse.executeActionFailure(msg, null);
        }
        Task task = action.createTask();
        TaskStatus status = AnaplanUtil.runServerTask(task);
        if (status.getTaskState() == TaskStatus.State.COMPLETE && status.getResult().isSuccessful()) {
            logger.info("Action executed successfully.");
            AnaplanDeleteOperation.setRunStatusDetails(AnaplanDeleteOperation.collectTaskLogs(status));
            return MulesoftAnaplanResponse.executeActionSuccess(status.getTaskState().name());
        }
        return MulesoftAnaplanResponse.executeActionFailure("Execute Action Failed", null);
    }

    public String runDeleteAction(String workspaceId, String modelId, String deleteActionId) throws AnaplanOperationException {
        logger.info("<< Starting Delete-Action >>");
        logger.info("Workspace-ID: {}", new Object[]{workspaceId});
        logger.info("Model-ID: {}", new Object[]{modelId});
        logger.info("Delete Action ID: {}", new Object[]{deleteActionId});
        this.validateInput(workspaceId, modelId);
        try {
            MulesoftAnaplanResponse anaplanResponse = AnaplanDeleteOperation.runDeleteAction(this.model, deleteActionId);
            logger.info("Action complete: Status: {}, Response message: {}", new Object[]{anaplanResponse.getStatus(), anaplanResponse.getResponseMessage()});
        }
        catch (AnaplanAPIException e) {
            throw new AnaplanOperationException(e.getMessage(), e);
        }
        finally {
            this.apiConn.closeConnection();
        }
        String statusMsg = "[" + deleteActionId + "] completed successfully!";
        logger.info(statusMsg);
        return statusMsg + "\n\n" + AnaplanDeleteOperation.getRunStatusDetails();
    }
}

