/*
 * Decompiled with CFR 0.152.
 */
package com.anaplan.connector.utils;

import com.anaplan.client.AnaplanAPIException;
import com.anaplan.client.Model;
import com.anaplan.client.Service;
import com.anaplan.client.TaskResult;
import com.anaplan.client.TaskResultDetail;
import com.anaplan.client.TaskStatus;
import com.anaplan.client.Workspace;
import com.anaplan.connector.connection.AnaplanConnection;
import com.anaplan.connector.exceptions.AnaplanOperationException;
import com.anaplan.connector.utils.LogUtil;

public class BaseAnaplanOperation {
    protected AnaplanConnection apiConn;
    protected Service service;
    protected Workspace workspace = null;
    protected Model model = null;
    private static String runStatusDetails = null;

    public BaseAnaplanOperation(AnaplanConnection apiConn) {
        this.setApiConn(apiConn);
    }

    public static String getRunStatusDetails() {
        return runStatusDetails;
    }

    public static void setRunStatusDetails(String statusMsgs) {
        runStatusDetails = statusMsgs;
    }

    private void setApiConn(AnaplanConnection apiConn) {
        this.apiConn = apiConn;
        this.service = apiConn.getConnection();
    }

    public Workspace getWorkspace(String workspaceId) throws AnaplanOperationException {
        try {
            this.workspace = this.service.getWorkspace(workspaceId);
            if (this.workspace == null) {
                throw new AnaplanOperationException("Could not fetch workspace with provided Workspace ID: " + workspaceId);
            }
        }
        catch (AnaplanAPIException e) {
            throw new AnaplanOperationException("Error when fetching workspace for Workspace ID: " + workspaceId);
        }
        return this.workspace;
    }

    public Model getModel(String workspaceId, String modelId) throws AnaplanOperationException {
        this.getWorkspace(workspaceId);
        try {
            this.model = this.workspace.getModel(modelId);
            if (this.model == null) {
                throw new AnaplanOperationException("Could not fetch model with provided model ID: " + modelId);
            }
        }
        catch (AnaplanAPIException e) {
            throw new AnaplanOperationException("Error when fetching model for Workspace ID: " + workspaceId + ", Model ID" + modelId);
        }
        return this.model;
    }

    public void validateInput(String workspaceId, String modelId) throws AnaplanOperationException {
        this.getModel(workspaceId, modelId);
        LogUtil.status(this.apiConn.getLogContext(), "Workspace ID is valid: " + workspaceId);
        LogUtil.status(this.apiConn.getLogContext(), "Model ID is valid: " + modelId);
    }

    public static String collectTaskLogs(TaskStatus status) {
        TaskResult taskResult = status.getResult();
        StringBuilder taskDetails = new StringBuilder();
        if (taskResult.getDetails() != null) {
            for (TaskResultDetail detail : taskResult.getDetails()) {
                taskDetails.append("\n" + detail.getLocalizedMessageText());
            }
            return taskDetails.toString();
        }
        return null;
    }
}

