/*
 * Decompiled with CFR 0.152.
 */
package com.anaplan.connector.utils;

import com.anaplan.client.AnaplanAPIException;
import com.anaplan.client.Export;
import com.anaplan.client.Model;
import com.anaplan.client.ServerFile;
import com.anaplan.client.Task;
import com.anaplan.client.TaskStatus;
import com.anaplan.connector.MulesoftAnaplanResponse;
import com.anaplan.connector.connection.AnaplanConnection;
import com.anaplan.connector.exceptions.AnaplanOperationException;
import com.anaplan.connector.utils.AnaplanUtil;
import com.anaplan.connector.utils.BaseAnaplanOperation;
import com.anaplan.connector.utils.LogUtil;
import com.anaplan.connector.utils.UserMessages;
import java.io.IOException;

public class AnaplanExportOperation
extends BaseAnaplanOperation {
    public AnaplanExportOperation(AnaplanConnection apiConn) {
        super(apiConn);
    }

    private static MulesoftAnaplanResponse doExport(Model model, String exportId, String logContext) throws AnaplanAPIException {
        Export exp = model.getExport(exportId);
        if (exp == null) {
            String msg = UserMessages.getMessage("invalidExport", exportId);
            return MulesoftAnaplanResponse.exportFailure(msg, null, null, logContext);
        }
        Task task = exp.createTask();
        TaskStatus status = AnaplanUtil.runServerTask(task, logContext);
        if (status.getTaskState() == TaskStatus.State.COMPLETE && status.getResult().isSuccessful()) {
            LogUtil.status(logContext, "Export completed successfully!");
            ServerFile serverFile = model.getServerFile(exp.getName());
            if (serverFile == null) {
                return MulesoftAnaplanResponse.exportFailure(UserMessages.getMessage("exportRetrieveError", exp.getName()), exp.getExportMetadata(), null, logContext);
            }
            AnaplanExportOperation.setRunStatusDetails(AnaplanExportOperation.collectTaskLogs(status));
            LogUtil.status(logContext, AnaplanExportOperation.getRunStatusDetails());
            return MulesoftAnaplanResponse.exportSuccess(status.getTaskState().name(), serverFile, exp.getExportMetadata(), logContext);
        }
        LogUtil.error(logContext, "Export failed !!!");
        return MulesoftAnaplanResponse.exportFailure(status.getTaskState().name(), exp.getExportMetadata(), null, logContext);
    }

    public String runExport(String workspaceId, String modelId, String exportId) throws AnaplanOperationException {
        String logContext = this.apiConn.getLogContext();
        String exportLogContext = logContext + " [" + exportId + "]";
        String response = null;
        LogUtil.status(logContext, "<< Starting export >>");
        LogUtil.status(logContext, "Workspace-ID: " + workspaceId);
        LogUtil.status(logContext, "Model-ID: " + modelId);
        LogUtil.status(logContext, "Export-ID: " + exportId);
        this.validateInput(workspaceId, modelId);
        try {
            MulesoftAnaplanResponse anaplanResponse = AnaplanExportOperation.doExport(this.model, exportId, exportLogContext);
            response = anaplanResponse.writeExportData(this.apiConn);
            LogUtil.status(logContext, "Query complete: Status: " + (Object)((Object)anaplanResponse.getStatus()) + ", Response message: " + anaplanResponse.getResponseMessage());
        }
        catch (IOException e) {
            throw new AnaplanOperationException(e.getMessage(), e);
        }
        catch (AnaplanAPIException e) {
            throw new AnaplanOperationException(e.getMessage(), e);
        }
        finally {
            this.apiConn.closeConnection();
        }
        LogUtil.status(exportLogContext, "[" + exportId + "] ran successfully!");
        return response;
    }
}

