/*
 * Decompiled with CFR 0.152.
 */
package com.anaplan.client.transport;

import com.anaplan.client.transport.AnaplanAPITransportException;
import com.anaplan.client.transport.TransportProvider;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

public class TransportProviderFactory {
    private static TransportProviderFactory instance;
    private static final Logger logger;
    private Map<String, Class<? extends TransportProvider>> providers;
    private Class<? extends TransportProvider> defaultProvider;
    private int debugLevel;

    public static synchronized TransportProviderFactory getInstance() throws AnaplanAPITransportException {
        if (instance == null) {
            instance = new TransportProviderFactory();
        }
        return instance;
    }

    private TransportProviderFactory() throws AnaplanAPITransportException {
        block3: {
            this.providers = new HashMap<String, Class<? extends TransportProvider>>();
            try {
                Class<TransportProvider> clazz = Class.forName("com.anaplan.client.transport.ApacheHttpProvider").asSubclass(TransportProvider.class);
                this.providers.put("ApacheHTTP", clazz);
                this.defaultProvider = clazz;
            }
            catch (Throwable throwable) {
                if (this.debugLevel <= 0) break block3;
                logger.warning(throwable.toString());
            }
        }
        if (this.providers.isEmpty()) {
            throw new AnaplanAPITransportException("No transport providers available; check the classpath contains the necessary libraries");
        }
    }

    public TransportProvider createProvider(String string) throws AnaplanAPITransportException {
        try {
            Class<? extends TransportProvider> clazz = this.providers.get(string);
            if (clazz == null) {
                return null;
            }
            TransportProvider transportProvider = clazz.newInstance();
            if (this.debugLevel > 0) {
                transportProvider.setDebugLevel(this.debugLevel);
            }
            return transportProvider;
        }
        catch (Exception exception) {
            throw new AnaplanAPITransportException("Failed to create transport provider(" + string + ")", exception);
        }
    }

    public TransportProvider createDefaultProvider() throws AnaplanAPITransportException {
        try {
            TransportProvider transportProvider = this.defaultProvider.newInstance();
            if (this.debugLevel > 0) {
                transportProvider.setDebugLevel(this.debugLevel);
            }
            return transportProvider;
        }
        catch (Exception exception) {
            throw new AnaplanAPITransportException("Failed to create default transport provider", exception);
        }
    }

    static {
        logger = Logger.getLogger("anaplan-connect.transport");
    }
}

