/*
 * Decompiled with CFR 0.152.
 */
package com.anaplan.client.transport;

import com.anaplan.client.Credentials;
import com.anaplan.client.transport.AnaplanAPITransportException;
import com.anaplan.client.transport.TransportProvider;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public abstract class TransportProviderBase
implements TransportProvider {
    private static final Logger logger = Logger.getLogger("anaplan-connect.transport");
    private static ProxySelector defaultProxySelector;
    private URI serviceLocation;
    private Credentials serviceCredentials;
    private URI proxyLocation;
    private Credentials proxyCredentials;
    private ProxySelector proxySelector = defaultProxySelector;
    private String userAgent;
    private int debugLevel;

    public String toString() {
        String string = this.getClass().getName();
        return string.substring(string.lastIndexOf(46) + 1);
    }

    @Override
    public void setServiceLocation(URI uRI) throws AnaplanAPITransportException {
        this.serviceLocation = uRI;
    }

    protected URI getServiceLocation() {
        return this.serviceLocation;
    }

    @Override
    public void setServiceCredentials(Credentials credentials) throws AnaplanAPITransportException {
        this.serviceCredentials = credentials;
    }

    protected Credentials getServiceCredentials() {
        return this.serviceCredentials;
    }

    @Override
    public void setProxyLocation(URI uRI) throws AnaplanAPITransportException {
        Proxy proxy;
        this.proxyLocation = uRI;
        Proxy.Type type = Proxy.Type.DIRECT;
        InetSocketAddress inetSocketAddress = null;
        if (uRI != null) {
            if ("http".equalsIgnoreCase(uRI.getScheme())) {
                type = Proxy.Type.HTTP;
            } else if ("socks".equalsIgnoreCase(uRI.getScheme())) {
                type = Proxy.Type.SOCKS;
            } else {
                throw new IllegalArgumentException("Unsupported scheme for proxy location URI (must start with http: or socks:): " + uRI.getScheme());
            }
            inetSocketAddress = new InetSocketAddress(uRI.getHost(), uRI.getPort());
            proxy = new Proxy(type, inetSocketAddress);
        } else {
            proxy = Proxy.NO_PROXY;
        }
        this.proxySelector = new ProxySelector(){

            @Override
            public List<Proxy> select(URI uRI) {
                return Collections.singletonList(proxy);
            }

            @Override
            public void connectFailed(URI uRI, SocketAddress socketAddress, IOException iOException) {
            }
        };
    }

    protected URI getProxyLocation() {
        return this.proxyLocation;
    }

    @Override
    public void setProxyCredentials(Credentials credentials) throws AnaplanAPITransportException {
        if (null == credentials.getUserName() || credentials.getUserName().isEmpty()) {
            throw new AnaplanAPITransportException("User name not specified");
        }
        if (null == credentials.getPassphrase() || credentials.getPassphrase().isEmpty()) {
            throw new AnaplanAPITransportException("Passphrase not specified");
        }
        this.proxyCredentials = credentials;
    }

    protected Credentials getProxyCredentials() {
        return this.proxyCredentials;
    }

    protected ProxySelector getProxySelector() {
        return this.proxySelector;
    }

    @Override
    public void setUserAgent(String string) {
        this.userAgent = string;
    }

    protected String getUserAgent() {
        return this.userAgent;
    }

    @Override
    public void setDebugLevel(int n) {
        this.debugLevel = n;
    }

    protected int getDebugLevel() {
        return this.debugLevel;
    }

    @Override
    public abstract byte[] get(String var1, String var2) throws AnaplanAPITransportException;

    @Override
    public abstract boolean head(String var1) throws AnaplanAPITransportException;

    @Override
    public abstract byte[] post(String var1, byte[] var2, String var3, String var4) throws AnaplanAPITransportException;

    @Override
    public abstract byte[] put(String var1, byte[] var2, String var3) throws AnaplanAPITransportException;

    @Override
    public abstract byte[] delete(String var1, String var2) throws AnaplanAPITransportException;

    @Override
    public abstract void close();

    protected String getRequestPath(String string) {
        StringBuilder stringBuilder = new StringBuilder(this.serviceLocation.getPath());
        while (stringBuilder.length() > 0 && stringBuilder.charAt(stringBuilder.length() - 1) == '/') {
            stringBuilder.setLength(stringBuilder.length() - 1);
        }
        String string2 = string;
        try {
            string2 = new URI(null, null, string, null).getRawPath();
        }
        catch (URISyntaxException uRISyntaxException) {
            logger.warning("Warning: failed to encode URI path \"" + string + "\": " + uRISyntaxException);
        }
        if (!string2.isEmpty() && string2.charAt(0) != '/') {
            stringBuilder.append('/');
        }
        return stringBuilder.append(string2).toString();
    }

    protected byte[] readResponseBody(InputStream inputStream) throws AnaplanAPITransportException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray = new byte[32768];
            int n = 0;
            while (n >= 0) {
                n = inputStream.read(byArray);
                if (n <= 0) continue;
                byteArrayOutputStream.write(byArray, 0, n);
            }
            inputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new AnaplanAPITransportException("Failed to read response body from server", iOException);
        }
    }

    protected byte[] compress(byte[] byArray, int n, int n2) throws AnaplanAPITransportException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
            gZIPOutputStream.write(byArray, n, n2);
            gZIPOutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new AnaplanAPITransportException("Failed to compress data for upload", iOException);
        }
    }

    protected byte[] decompress(byte[] byArray, int n, int n2) throws AnaplanAPITransportException {
        try {
            GZIPInputStream gZIPInputStream = new GZIPInputStream(new ByteArrayInputStream(byArray, n, n2));
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray2 = new byte[65536];
            int n3 = 0;
            while (n3 >= 0) {
                n3 = gZIPInputStream.read(byArray2);
                if (n3 <= 0) continue;
                byteArrayOutputStream.write(byArray2, 0, n3);
            }
            gZIPInputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new AnaplanAPITransportException("Failed to decompress downloaded data", iOException);
        }
    }

    static {
        try {
            Class<?> clazz = Class.forName("com.btr.proxy.search.ProxySearch");
            Method method = clazz.getMethod("getDefaultProxySearch", new Class[0]);
            Object object = method.invoke(null, new Object[0]);
            Method method2 = clazz.getMethod("getProxySelector", new Class[0]);
            defaultProxySelector = (ProxySelector)method2.invoke(object, new Object[0]);
        }
        catch (Throwable throwable) {
            defaultProxySelector = ProxySelector.getDefault();
        }
    }
}

