/*
 * Decompiled with CFR 0.152.
 */
package com.anaplan.client.serialization;

import com.anaplan.client.serialization.AnaplanAPISerializationException;
import com.anaplan.client.serialization.SerializationHandler;
import java.util.HashMap;
import java.util.Map;

public class SerializationHandlerFactory {
    private static SerializationHandlerFactory instance;
    private Map<String, SerializationHandler> handlers = new HashMap<String, SerializationHandler>();
    private SerializationHandler defaultHandler;

    public static synchronized SerializationHandlerFactory getInstance() throws AnaplanAPISerializationException {
        if (instance == null) {
            instance = new SerializationHandlerFactory();
        }
        return instance;
    }

    private SerializationHandlerFactory() throws AnaplanAPISerializationException {
        try {
            Class.forName("com.google.gson.Gson");
            SerializationHandler serializationHandler = (SerializationHandler)Class.forName("com.anaplan.client.serialization.GsonHandler").newInstance();
            this.handlers.put("GSON", serializationHandler);
            this.defaultHandler = serializationHandler;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (this.handlers.isEmpty()) {
            throw new AnaplanAPISerializationException("No serialization handlers available: try adding gson-1.7.1.jar to the classpath");
        }
    }

    public SerializationHandler getHandler(String string) {
        return this.handlers.get(string);
    }

    public SerializationHandler getDefaultHandler() {
        return this.defaultHandler;
    }
}

