/*
 * Decompiled with CFR 0.152.
 */
package com.anaplan.client;

import com.anaplan.client.AnaplanAPIException;
import com.anaplan.client.AnaplanApiClientObject;
import com.anaplan.client.Model;
import com.anaplan.client.Service;
import com.anaplan.client.serialization.TypeWrapper;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;

public class Workspace
extends AnaplanApiClientObject {
    static final TypeWrapper<List<Data>> DATA_LIST_TYPE = new TypeWrapper<List<Data>>(){};
    private Service service;
    private Data data;
    private Map<Model.Data, Reference<Model>> modelCache = new WeakHashMap<Model.Data, Reference<Model>>();

    Workspace(Service service, Data data) {
        super(service);
        this.service = service;
        this.data = data;
    }

    Service getService() {
        return this.service;
    }

    @Override
    String getPath() {
        return this.getService().getPath() + "/workspaces/" + this.getId();
    }

    public String getId() {
        return this.data.guid;
    }

    public String getName() {
        return this.data.name;
    }

    public List<Model> getModels() throws AnaplanAPIException {
        List<Model.Data> list = this.getSerializationHandler().deserialize(this.getTransportProvider().get(this.getPath() + "/models", this.getSerializationHandler().getContentType()), Model.DATA_LIST_TYPE);
        ArrayList<Model> arrayList = new ArrayList<Model>(list.size());
        for (Model.Data data : list) {
            Model model;
            Reference<Model> reference = this.modelCache.get(data);
            Model model2 = model = reference == null ? null : reference.get();
            if (model == null) {
                model = new Model(this, data);
                this.modelCache.put(data, new WeakReference<Model>(model));
            }
            arrayList.add(model);
        }
        return arrayList;
    }

    public Model getModel(String string) throws AnaplanAPIException {
        List<Model> list = this.getModels();
        for (Model model : list) {
            if (!string.equals(model.getId())) continue;
            return model;
        }
        for (Model model : list) {
            if (!string.equalsIgnoreCase(model.getName())) continue;
            return model;
        }
        return null;
    }

    static final class Data {
        String guid;
        String name;

        Data() {
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof Data)) {
                return false;
            }
            Data data = (Data)object;
            return this.guid.equals(data.guid) && this.name.equals(data.name);
        }

        public int hashCode() {
            return this.guid.hashCode() * 31 + this.name.hashCode();
        }
    }
}

