/*
 * Decompiled with CFR 0.152.
 */
package com.anaplan.client;

import com.anaplan.client.AnaplanAPIException;
import com.anaplan.client.Model;
import com.anaplan.client.ServerFile;
import com.anaplan.client.TaskResultDetail;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class TaskResult {
    private Model model;
    private String dumpFileId;
    private String dumpFilePath;
    private Data data;
    private List<TaskResultDetail> details;
    private List<TaskResult> nestedResults;

    TaskResult(Model model, String string, String string2, Data data) {
        this.model = model;
        this.dumpFileId = string;
        this.dumpFilePath = string2;
        this.data = data;
        ArrayList<TaskResultDetail> arrayList = new ArrayList<TaskResultDetail>();
        if (null != data.details) {
            for (TaskResultDetail.Data object : data.details) {
                arrayList.add(new TaskResultDetail(object));
            }
        }
        this.details = Collections.unmodifiableList(arrayList);
        ArrayList arrayList2 = new ArrayList();
        if (null != data.nestedResults) {
            for (Data data2 : data.nestedResults) {
                arrayList2.add(new TaskResult(model, string + "~" + data2.objectId, string2 + "s/" + data2.objectId, data2));
            }
        }
        this.nestedResults = Collections.unmodifiableList(arrayList2);
    }

    public String getObjectId() {
        return this.data.objectId;
    }

    public String getObjectName() {
        return this.data.objectName;
    }

    public boolean isSuccessful() {
        return this.data.successful;
    }

    public List<TaskResultDetail> getDetails() {
        return this.details;
    }

    public boolean isFailureDumpAvailable() {
        return this.data.failureDumpAvailable;
    }

    public ServerFile getFailureDump() {
        if (!this.isFailureDumpAvailable()) {
            return null;
        }
        ServerFile.Data data = new ServerFile.Data();
        data.id = this.dumpFileId;
        return new ServerFile(this.model, data){

            @Override
            String getPath() {
                return TaskResult.this.dumpFilePath;
            }

            @Override
            public void upLoad(File file, boolean bl) throws AnaplanAPIException {
                throw new AnaplanAPIException("Cannot upload to failure dump");
            }
        };
    }

    public List<TaskResult> getNestedResults() {
        return this.nestedResults;
    }

    public Appendable appendTo(Appendable appendable) throws IOException {
        for (TaskResultDetail object : this.details) {
            object.appendTo(appendable);
            appendable.append('\n');
        }
        for (TaskResult taskResult : this.nestedResults) {
            taskResult.appendTo(appendable);
            appendable.append('\n');
        }
        return appendable;
    }

    public String toString() {
        try {
            return this.appendTo(new StringBuilder()).toString();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    static class Data {
        String objectId;
        String objectName;
        boolean successful;
        List<TaskResultDetail.Data> details;
        boolean failureDumpAvailable;
        List<Data> nestedResults;

        Data() {
        }
    }
}

