/*
 * Decompiled with CFR 0.152.
 */
package com.anaplan.client;

import com.anaplan.client.AnaplanAPIException;
import com.anaplan.client.AnaplanApiClientObject;
import com.anaplan.client.Credentials;
import com.anaplan.client.Workspace;
import com.anaplan.client.serialization.SerializationHandler;
import com.anaplan.client.serialization.SerializationHandlerFactory;
import com.anaplan.client.transport.TransportProvider;
import com.anaplan.client.transport.TransportProviderFactory;
import java.io.Closeable;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Logger;

public class Service
extends AnaplanApiClientObject
implements Closeable {
    private static final Logger logger = Logger.getLogger("anaplan-connect.service");
    public static final int MAJOR_VERSION = 1;
    public static final int MINOR_VERSION = 3;
    public static final int REVISION_VERSION = 4;
    public static final String RELEASE_VERSION = "prod";
    private static final String PATH = "/1/3";
    public static final URI PRODUCTION_API_ROOT;
    public static final URI UAT_API_ROOT;
    private URI serviceLocation;
    private Credentials serviceCredentials;
    private URI proxyLocation;
    private boolean proxyLocationProvided;
    private Credentials proxyCredentials;
    private SerializationHandler serializationHandler;
    private TransportProvider transportProvider;
    private boolean transportProviderInitialized;
    private Map<Workspace.Data, Reference<Workspace>> workspaceCache = new WeakHashMap<Workspace.Data, Reference<Workspace>>();
    private int debugLevel = 0;

    @Override
    String getPath() {
        return PATH;
    }

    public Service(URI uRI) {
        super(null);
        if (uRI == null) {
            throw new IllegalArgumentException("Service location must be specified");
        }
        this.serviceLocation = uRI;
    }

    public Service() {
        this(PRODUCTION_API_ROOT);
    }

    public void setProxyLocation(URI uRI) throws AnaplanAPIException {
        this.proxyLocation = uRI;
        this.proxyLocationProvided = true;
        if (this.transportProvider != null) {
            this.transportProvider.setProxyLocation(uRI);
        }
    }

    public void setServiceCredentials(Credentials credentials) throws AnaplanAPIException {
        this.serviceCredentials = credentials;
        if (this.transportProvider != null) {
            this.transportProvider.setServiceCredentials(credentials);
        }
    }

    public void setProxyCredentials(Credentials credentials) throws AnaplanAPIException {
        this.proxyCredentials = credentials;
        if (this.transportProvider != null) {
            this.transportProvider.setProxyCredentials(credentials);
        }
    }

    public void setSerializationHandler(SerializationHandler serializationHandler) {
        this.serializationHandler = serializationHandler;
    }

    @Override
    SerializationHandler getSerializationHandler() throws AnaplanAPIException {
        if (this.serializationHandler == null) {
            SerializationHandlerFactory serializationHandlerFactory = SerializationHandlerFactory.getInstance();
            this.serializationHandler = serializationHandlerFactory.getDefaultHandler();
        }
        return this.serializationHandler;
    }

    public void setTransportProvider(TransportProvider transportProvider) {
        this.transportProvider = transportProvider;
        this.transportProviderInitialized = false;
    }

    public void setDebugLevel(int n) {
        this.debugLevel = n;
    }

    @Override
    synchronized TransportProvider getTransportProvider() throws AnaplanAPIException {
        Object object;
        if (this.transportProvider == null) {
            object = TransportProviderFactory.getInstance();
            this.transportProvider = ((TransportProviderFactory)object).createDefaultProvider();
        }
        if (!this.transportProviderInitialized) {
            this.transportProvider.setDebugLevel(this.debugLevel);
            this.transportProvider.setServiceLocation(this.serviceLocation);
            this.transportProvider.setServiceCredentials(this.serviceCredentials);
            if (this.proxyLocationProvided) {
                this.transportProvider.setProxyLocation(this.proxyLocation);
            }
            if (this.proxyCredentials != null) {
                this.transportProvider.setProxyCredentials(this.proxyCredentials);
            }
            this.transportProviderInitialized = true;
            object = this.buildUserAgentIdentifier();
            if (this.debugLevel > 0) {
                logger.info("UA: " + (String)object);
            }
            this.transportProvider.setUserAgent((String)object);
        }
        return this.transportProvider;
    }

    protected String buildUserAgentIdentifier() throws AnaplanAPIException {
        StringBuilder stringBuilder = new StringBuilder(this.getClass().getName());
        stringBuilder.append("/").append(1).append(".").append(3);
        stringBuilder.append(".").append(4).append(RELEASE_VERSION);
        stringBuilder.append(" (").append(this.getTransportProvider().toString());
        stringBuilder.append("; ").append(this.getSerializationHandler().toString());
        String string = System.getProperty("java.vm.name") + " (" + System.getProperty("java.vendor") + ")/" + System.getProperty("java.vm.version") + " (" + System.getProperty("java.version") + ")";
        stringBuilder.append("; ").append(string);
        String string2 = System.getProperty("os.name") + " (" + System.getProperty("os.arch") + ")/" + System.getProperty("os.version");
        stringBuilder.append("; ").append(string2).append(')');
        return stringBuilder.toString();
    }

    protected void checkInitialized() {
        if (this.serviceLocation == null) {
            throw new IllegalStateException("The Service instance is in a closed state. No further access is permitted.");
        }
        if (this.serviceCredentials == null) {
            throw new IllegalStateException("No credentials were provided");
        }
    }

    public List<Workspace> getWorkspaces() throws AnaplanAPIException {
        this.checkInitialized();
        List<Workspace.Data> list = this.getSerializationHandler().deserialize(this.getTransportProvider().get(this.getPath() + "/workspaces/", this.getSerializationHandler().getContentType()), Workspace.DATA_LIST_TYPE);
        ArrayList<Workspace> arrayList = new ArrayList<Workspace>(list.size());
        for (Workspace.Data data : list) {
            Workspace workspace;
            Reference<Workspace> reference = this.workspaceCache.get(data);
            Workspace workspace2 = workspace = reference == null ? null : reference.get();
            if (workspace == null) {
                workspace = new Workspace(this, data);
                this.workspaceCache.put(data, new WeakReference<Workspace>(workspace));
            }
            arrayList.add(workspace);
        }
        return arrayList;
    }

    public Workspace getWorkspace(String string) throws AnaplanAPIException {
        this.checkInitialized();
        List<Workspace> list = this.getWorkspaces();
        for (Workspace workspace : list) {
            if (!string.equals(workspace.getId())) continue;
            return workspace;
        }
        for (Workspace workspace : list) {
            if (!string.equalsIgnoreCase(workspace.getName())) continue;
            return workspace;
        }
        return null;
    }

    @Override
    public void close() {
        this.serviceLocation = null;
        if (this.transportProvider != null) {
            this.transportProvider.close();
            this.transportProvider = null;
        }
    }

    static {
        try {
            PRODUCTION_API_ROOT = new URI("https://api.anaplan.com/");
            UAT_API_ROOT = new URI("https://api.uat.anaplan.com/");
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new ExceptionInInitializerError(uRISyntaxException);
        }
    }
}

