/*
 * Decompiled with CFR 0.152.
 */
package com.anaplan.client;

import com.anaplan.client.AnaplanAPIException;
import com.anaplan.client.CellReader;
import com.anaplan.client.CellWriter;
import com.anaplan.client.Model;
import com.anaplan.client.NamedObject;
import com.anaplan.client.serialization.TypeWrapper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.SequenceInputStream;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;

public class ServerFile
extends NamedObject {
    private static final Logger logger = Logger.getLogger("anaplan-connect.file");
    static final TypeWrapper<Data> DATA_TYPE = new TypeWrapper<Data>(){};
    static final TypeWrapper<List<Data>> DATA_LIST_TYPE = new TypeWrapper<List<Data>>(){};
    static final TypeWrapper<List<Chunk>> CHUNK_LIST_TYPE = new TypeWrapper<List<Chunk>>(){};
    private Data data;

    ServerFile(Model model, Data data) {
        super(model, data);
        this.data = data;
    }

    @Override
    String getPath() {
        return this.getModel().getPath() + "/files/" + this.getId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downLoad(File file, boolean bl) throws AnaplanAPIException, IOException {
        if (file.exists()) {
            if (!file.isFile()) {
                throw new FileNotFoundException("Path \"" + file + "\" exists but is not a file");
            }
            if (!bl) {
                throw new IllegalStateException("File \"" + file + "\" already exists");
            }
            if (!file.canWrite()) {
                throw new FileNotFoundException("File \"" + file + "\" cannot be written to - check ownership and/or permissions");
            }
            file.delete();
        }
        File file2 = new File(file.getParentFile(), ".partial." + file.getName());
        RandomAccessFile randomAccessFile = new RandomAccessFile(file2, "rw");
        try {
            randomAccessFile.setLength(0L);
            byte[] byArray = this.getTransportProvider().get(this.getPath() + "/chunks", this.getSerializationHandler().getContentType());
            List<Chunk> list = this.getSerializationHandler().deserialize(byArray, CHUNK_LIST_TYPE);
            for (Chunk chunk : list) {
                byte[] byArray2 = this.getTransportProvider().get(this.getPath() + "/chunks/" + chunk.id, null);
                randomAccessFile.write(byArray2);
            }
            randomAccessFile.close();
            randomAccessFile = null;
            file2.renameTo(file);
        }
        finally {
            if (randomAccessFile != null) {
                try {
                    randomAccessFile.close();
                }
                catch (IOException iOException) {
                    logger.warning("Warning: failed to close file " + file2 + ": " + iOException.getMessage());
                }
            }
        }
    }

    public InputStream getDownloadStream() throws AnaplanAPIException, IOException {
        byte[] byArray = this.getTransportProvider().get(this.getPath() + "/chunks", this.getSerializationHandler().getContentType());
        final List<Chunk> list = this.getSerializationHandler().deserialize(byArray, CHUNK_LIST_TYPE);
        return new SequenceInputStream((Enumeration<? extends InputStream>)new Enumeration<InputStream>(){
            int index = 0;

            @Override
            public boolean hasMoreElements() {
                return this.index < list.size();
            }

            @Override
            public InputStream nextElement() {
                try {
                    byte[] byArray = ServerFile.this.getTransportProvider().get(ServerFile.this.getPath() + "/chunks/" + ((Chunk)list.get((int)this.index++)).id, null);
                    return new ByteArrayInputStream(byArray);
                }
                catch (Exception exception) {
                    throw new RuntimeException("Failed to read chunk from server", exception);
                }
            }
        });
    }

    public CellReader getDownloadCellReader() throws AnaplanAPIException, IOException {
        final LineNumberReader lineNumberReader = new LineNumberReader(new InputStreamReader(this.getDownloadStream(), "UTF-8"));
        final String string = lineNumberReader.readLine();
        final String[] stringArray = string == null ? new String[]{} : string.split("\\t");
        return new CellReader(){

            @Override
            public String[] getHeaderRow() throws AnaplanAPIException, IOException {
                return stringArray;
            }

            @Override
            public String getWholeHeaderRow() throws AnaplanAPIException, IOException {
                System.out.println(string);
                return string;
            }

            @Override
            public String[] readDataRow() throws AnaplanAPIException, IOException {
                String string2 = lineNumberReader.readLine();
                return string2 == null ? null : string2.split("\\t");
            }

            @Override
            public String readWholeDataRow() throws AnaplanAPIException, IOException {
                return lineNumberReader.readLine();
            }

            @Override
            public void close() {
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void upLoad(File file, boolean bl) throws AnaplanAPIException, IOException {
        if (!file.exists()) {
            throw new FileNotFoundException("Path \"" + file + "\" does not exist");
        }
        if (!file.isFile()) {
            throw new FileNotFoundException("Path \"" + file + "\" does not refer to a file");
        }
        if (!file.canRead()) {
            throw new FileNotFoundException("File \"" + file + "\" cannot be read - check ownership and/or permissions");
        }
        RandomAccessFile randomAccessFile = null;
        try {
            long l = file.length();
            this.data.chunkCount = (int)((l - 1L) / 0x100000L) + 1;
            byte[] byArray = this.getSerializationHandler().serialize(this.data, DATA_TYPE);
            String string = this.getSerializationHandler().getContentType();
            byArray = this.getTransportProvider().post(this.getPath(), byArray, string, string);
            if (byArray != null) {
                this.data = this.getSerializationHandler().deserialize(byArray, DATA_TYPE);
            }
            byArray = this.getTransportProvider().get(this.getPath() + "/chunks", string);
            List<Chunk> list = this.getSerializationHandler().deserialize(byArray, CHUNK_LIST_TYPE);
            Iterator<Chunk> iterator = list.iterator();
            byte[] byArray2 = new byte[0x100000];
            randomAccessFile = new RandomAccessFile(file, "r");
            long l2 = 0L;
            while (iterator.hasNext()) {
                Chunk chunk = iterator.next();
                int n = 0x100000;
                if (!iterator.hasNext()) {
                    n = (int)(l - l2);
                }
                if (n != byArray2.length) {
                    byArray2 = new byte[n];
                }
                randomAccessFile.readFully(byArray2, 0, n);
                l2 += (long)n;
                this.getTransportProvider().put(this.getPath() + "/chunks/" + chunk.id, byArray2, null);
            }
        }
        finally {
            if (randomAccessFile != null) {
                try {
                    randomAccessFile.close();
                }
                catch (IOException iOException) {
                    logger.warning("Warning: failed to close file " + file + ": " + iOException.getMessage());
                }
            }
        }
    }

    public OutputStream getUploadStream() throws AnaplanAPIException, IOException {
        this.data.chunkCount = -1;
        byte[] byArray = this.getSerializationHandler().serialize(this.data, DATA_TYPE);
        String string = this.getSerializationHandler().getContentType();
        byArray = this.getTransportProvider().post(this.getPath(), byArray, string, string);
        if (byArray != null) {
            this.data = this.getSerializationHandler().deserialize(byArray, DATA_TYPE);
        }
        return new FilterOutputStream(new ByteArrayOutputStream(0x200000)){
            int chunkIndex;
            {
                this.chunkIndex = 0;
            }

            private ByteArrayOutputStream getBuffer() {
                return (ByteArrayOutputStream)this.out;
            }

            @Override
            public void write(int n) throws IOException {
                super.write(n);
                if (this.getBuffer().size() >= 0x100000) {
                    this.flush();
                }
            }

            @Override
            public void write(byte[] byArray, int n, int n2) throws IOException {
                super.write(byArray, n, n2);
                if (this.getBuffer().size() >= 0x100000) {
                    this.flush();
                }
            }

            @Override
            public void flush() throws IOException {
                super.flush();
                try {
                    ServerFile.this.getTransportProvider().put(ServerFile.this.getPath() + "/chunks/" + this.chunkIndex++, this.getBuffer().toByteArray(), null);
                }
                catch (AnaplanAPIException anaplanAPIException) {
                    throw new IOException(anaplanAPIException);
                }
                this.getBuffer().reset();
            }

            @Override
            public void close() throws IOException {
                this.flush();
                try {
                    byte[] byArray = ServerFile.this.getSerializationHandler().serialize(ServerFile.this.data, DATA_TYPE);
                    String string = ServerFile.this.getSerializationHandler().getContentType();
                    byArray = ServerFile.this.getTransportProvider().post(ServerFile.this.getPath() + "/complete", byArray, string, string);
                    if (byArray != null) {
                        ServerFile.this.data = ServerFile.this.getSerializationHandler().deserialize(byArray, DATA_TYPE);
                    }
                }
                catch (AnaplanAPIException anaplanAPIException) {
                    throw new IOException(anaplanAPIException);
                }
            }
        };
    }

    public CellWriter getUploadCellWriter() throws AnaplanAPIException {
        this.data.format = "txt";
        this.data.encoding = "UTF-8";
        this.data.separator = "\t";
        this.data.delimiter = "";
        this.data.headerRow = 1;
        this.data.firstDataRow = 2;
        return new CellWriter(){
            OutputStream output;

            @Override
            public void writeHeaderRow(Object[] objectArray) throws AnaplanAPIException, IOException {
                this.output = ServerFile.this.getUploadStream();
                this.writeDataRow(objectArray);
            }

            @Override
            public void writeDataRow(Object[] objectArray) throws AnaplanAPIException, IOException {
                if (this.output == null) {
                    throw new AnaplanAPIException("Cell writer is no longer open");
                }
                StringBuilder stringBuilder = new StringBuilder();
                for (Object object : objectArray) {
                    String string;
                    if (stringBuilder.length() != 0) {
                        stringBuilder.append("\t");
                    }
                    if ((string = object.toString()).indexOf(9) != -1) {
                        throw new AnaplanAPIException("Cell text cannot contain tab character");
                    }
                    stringBuilder.append(string);
                }
                this.output.write(stringBuilder.append('\n').toString().getBytes("UTF-8"));
            }

            @Override
            public void close() throws IOException {
                if (this.output != null) {
                    this.output.close();
                    this.output = null;
                }
            }

            @Override
            public void abort() {
                this.output = null;
            }
        };
    }

    public void setFormat(Format format) {
        this.data.format = format == null ? null : String.valueOf((Object)format);
    }

    public Format getFormat() {
        return this.data.format == null ? null : Format.valueOf(this.data.format);
    }

    public void setLanguage(String string) {
        this.data.language = string;
    }

    public void setCountry(String string) {
        this.data.country = string;
    }

    public void setEncoding(String string) {
        this.data.encoding = string;
    }

    public void setSeparator(String string) {
        this.data.separator = string;
    }

    public void setDelimiter(String string) {
        this.data.delimiter = string;
    }

    public void setHeaderRow(Integer n) {
        this.data.headerRow = n;
    }

    public void setFirstDataRow(Integer n) {
        this.data.firstDataRow = n;
    }

    public String getLanguage() {
        return this.data.language;
    }

    public String getCountry() {
        return this.data.country;
    }

    public String getEncoding() {
        return this.data.encoding;
    }

    public String getSeparator() {
        return this.data.separator;
    }

    public String getDelimiter() {
        return this.data.delimiter;
    }

    public Integer getHeaderRow() {
        return this.data.headerRow;
    }

    public Integer getFirstDataRow() {
        return this.data.firstDataRow;
    }

    static class Chunk
    extends NamedObject.Data {
        Chunk() {
        }
    }

    static class Data
    extends NamedObject.Data {
        int chunkCount;
        String origin;
        String format;
        String language;
        String country;
        String encoding;
        String separator;
        String delimiter;
        Integer headerRow;
        Integer firstDataRow;

        Data() {
        }
    }

    public static enum Format {
        TXT;

    }
}

