/*
 * Decompiled with CFR 0.152.
 */
package com.anaplan.client;

import com.anaplan.client.Action;
import com.anaplan.client.AnaplanAPIException;
import com.anaplan.client.CellReader;
import com.anaplan.client.CellWriter;
import com.anaplan.client.Credentials;
import com.anaplan.client.EncodingUtils;
import com.anaplan.client.Export;
import com.anaplan.client.ExportMetadata;
import com.anaplan.client.Import;
import com.anaplan.client.JDBCCellReader;
import com.anaplan.client.Model;
import com.anaplan.client.Module;
import com.anaplan.client.NamedObject;
import com.anaplan.client.Process;
import com.anaplan.client.ServerFile;
import com.anaplan.client.Service;
import com.anaplan.client.Task;
import com.anaplan.client.TaskFactory;
import com.anaplan.client.TaskParameters;
import com.anaplan.client.TaskResult;
import com.anaplan.client.TaskStatus;
import com.anaplan.client.View;
import com.anaplan.client.Workspace;
import java.io.Console;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Properties;
import java.util.Scanner;

public abstract class Program {
    private static int debugLevel = 0;
    private static boolean quiet = false;
    private static Service service = null;
    private static URI serviceLocation = null;
    private static URI proxyLocation = null;
    private static boolean proxyLocationSet = false;
    private static String username = null;
    private static String passphrase = null;
    private static String proxyUsername = null;
    private static boolean proxyUsernameSet = false;
    private static String proxyPassphrase = null;
    private static String keyStorePath = null;
    private static String keyStoreAlias = null;
    private static String keyStorePassword = null;
    private static String certificatePath = null;
    private static boolean userCertificateAuthentication = false;
    private static String workspaceId = null;
    private static String modelId = null;
    private static String moduleId = null;
    private static String viewId = null;
    private static String fileId = null;
    private static String importId = null;
    private static String exportId = null;
    private static String actionId = null;
    private static String processId = null;
    private static TaskResult lastResult = null;
    private static boolean somethingDone = false;
    private static String jdbcUrl = null;
    private static Properties jdbcProps = null;
    private static Integer jdbcFetchSize = null;
    private static TaskParameters taskParameters = new TaskParameters();
    private static Task runningTask = null;
    private static Thread runningThread = null;
    private static boolean closingDown = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String ... stringArray) {
        try {
            if (stringArray.length == 0) {
                Program.displayHelp();
                return;
            }
            int n = 0;
            while (n < stringArray.length) {
                Object[] objectArray;
                Object object;
                String string;
                if ((string = stringArray[n++].intern()) == "-h" || string == "-help") {
                    Program.displayHelp();
                    somethingDone = true;
                    continue;
                }
                if (string == "-version") {
                    Program.displayVersion();
                    somethingDone = true;
                    continue;
                }
                if (string == "-d" || string == "-debug") {
                    if (debugLevel++ != 0) continue;
                    Program.displayVersion();
                    continue;
                }
                if (string == "-q" || string == "-quiet") {
                    quiet = true;
                    continue;
                }
                if (string == "-W" || string == "-workspaces") {
                    somethingDone = true;
                    object = Program.getService().getWorkspaces().iterator();
                    while (object.hasNext()) {
                        Workspace workspace = object.next();
                        System.out.println(Program.formatTSV(workspace.getId(), workspace.getName()));
                    }
                    continue;
                }
                if (string == "-M" || string == "-models") {
                    somethingDone = true;
                    object = Program.getWorkspace(workspaceId);
                    if (object == null) continue;
                    for (Model model : ((Workspace)object).getModels()) {
                        System.out.println(Program.formatTSV(model.getId(), model.getName()));
                    }
                    continue;
                }
                if (string == "-MO" || string == "-modules") {
                    somethingDone = true;
                    object = Program.getModel(workspaceId, modelId);
                    if (object == null) continue;
                    for (Module module : ((Model)object).getModules()) {
                        System.out.println(Program.formatTSV(module.getId(), module.getCode(), module.getName()));
                    }
                    continue;
                }
                if (string == "-VI" || string == "-views") {
                    somethingDone = true;
                    object = Program.getModule(workspaceId, modelId, moduleId);
                    if (object == null) continue;
                    for (View view : ((Module)object).getViews()) {
                        System.out.println(Program.formatTSV(view.getId(), view.getCode(), view.getName()));
                    }
                    continue;
                }
                if (string == "-F" || string == "-files") {
                    somethingDone = true;
                    object = Program.getModel(workspaceId, modelId);
                    if (object == null) continue;
                    for (ServerFile serverFile : ((Model)object).getServerFiles()) {
                        System.out.println(Program.formatTSV(serverFile.getId(), serverFile.getCode(), serverFile.getName()));
                    }
                    continue;
                }
                if (string == "-I" || string == "-imports") {
                    somethingDone = true;
                    object = Program.getModel(workspaceId, modelId);
                    if (object == null) continue;
                    for (Import import_ : ((Model)object).getImports()) {
                        System.out.println(Program.formatTSV(new Object[]{import_.getId(), import_.getCode(), import_.getName(), import_.getImportType(), import_.getSourceFileId()}));
                    }
                    continue;
                }
                if (string == "-A" || string == "-actions") {
                    somethingDone = true;
                    object = Program.getModel(workspaceId, modelId);
                    if (object == null) continue;
                    for (Action action : ((Model)object).getActions()) {
                        System.out.println(Program.formatTSV(action.getId(), action.getCode(), action.getName()));
                    }
                    continue;
                }
                if (string == "-E" || string == "-exports") {
                    somethingDone = true;
                    object = Program.getModel(workspaceId, modelId);
                    if (object == null) continue;
                    for (Export export : ((Model)object).getExports()) {
                        System.out.println(Program.formatTSV(export.getId(), export.getCode(), export.getName()));
                    }
                    continue;
                }
                if (string == "-P" || string == "-processes") {
                    somethingDone = true;
                    object = Program.getModel(workspaceId, modelId);
                    if (object == null) continue;
                    for (Process process : ((Model)object).getProcesses()) {
                        System.out.println(Program.formatTSV(process.getId(), process.getCode(), process.getName()));
                    }
                    continue;
                }
                if (string == "-emd") {
                    somethingDone = true;
                    object = Program.getExport(workspaceId, modelId, exportId);
                    ExportMetadata exportMetadata = ((Export)object).getExportMetadata();
                    String string2 = exportMetadata.getDelimiter();
                    if ("\t".equals(string2)) {
                        string2 = "\\t";
                    }
                    System.out.println("Export: " + ((NamedObject)object).getName() + "\ncolumns: " + String.valueOf(exportMetadata.getColumnCount()) + "\nrows: " + String.valueOf(exportMetadata.getRowCount()) + "\nformat: " + exportMetadata.getExportFormat() + "\ndelimiter: " + string2 + "\nencoding: " + exportMetadata.getEncoding() + "\nseparator: " + exportMetadata.getSeparator());
                    String[] stringArray2 = exportMetadata.getHeaderNames();
                    objectArray = exportMetadata.getDataTypes();
                    String[] stringArray3 = exportMetadata.getListNames();
                    for (int i = 0; i < stringArray2.length; ++i) {
                        System.out.println(" col " + String.valueOf(i) + ":\n  name: " + stringArray2[i] + "\n  type: " + ((Enum)objectArray[i]).toString() + "\n  list: " + stringArray3[i]);
                    }
                    continue;
                }
                if (string == "-x" || string == "-execute") {
                    object = null;
                    if (importId != null) {
                        somethingDone = true;
                        object = Program.getImport(workspaceId, modelId, importId);
                    } else if (exportId != null) {
                        somethingDone = true;
                        object = Program.getExport(workspaceId, modelId, exportId);
                    } else if (actionId != null) {
                        somethingDone = true;
                        object = Program.getAction(workspaceId, modelId, actionId);
                    } else if (processId != null) {
                        object = Program.getProcess(workspaceId, modelId, processId);
                    }
                    if (object != null) {
                        somethingDone = true;
                        lastResult = Program.runTask(((TaskFactory)object).createTask(taskParameters));
                        continue;
                    }
                    System.err.println("An import, export, action or process must be specified before " + string);
                    continue;
                }
                if (string == "-gets" || string == "-getc") {
                    ServerFile serverFile;
                    somethingDone = true;
                    object = null;
                    if (fileId != null) {
                        object = fileId;
                    } else if (exportId != null) {
                        object = exportId;
                    }
                    if (null == object || (serverFile = Program.getServerFile(workspaceId, modelId, (String)object, false)) == null) continue;
                    if (string == "-gets") {
                        int n2;
                        InputStream inputStream = serverFile.getDownloadStream();
                        byte[] byArray = new byte[4096];
                        do {
                            if (0 >= (n2 = inputStream.read(byArray))) continue;
                            System.out.write(byArray, 0, n2);
                        } while (-1 != n2);
                        System.out.flush();
                        inputStream.close();
                        continue;
                    }
                    CellReader cellReader = serverFile.getDownloadCellReader();
                    String[] stringArray4 = cellReader.getHeaderRow();
                    do {
                        objectArray = new StringBuilder();
                        for (int i = 0; i < stringArray4.length; ++i) {
                            if (objectArray.length() > 0) {
                                objectArray.append('\t');
                            }
                            objectArray.append(stringArray4[i]);
                        }
                        System.out.println(objectArray);
                    } while (null != (stringArray4 = cellReader.readDataRow()));
                    continue;
                }
                if (string == "-puts" || string == "-putc") {
                    Object object2;
                    Object object3;
                    somethingDone = true;
                    object = Program.getServerFile(workspaceId, modelId, fileId, true);
                    if (object == null) continue;
                    if (string == "-puts") {
                        int n3;
                        object3 = ((ServerFile)object).getUploadStream();
                        object2 = new byte[4096];
                        do {
                            if (0 >= (n3 = System.in.read((byte[])object2))) continue;
                            ((OutputStream)object3).write((byte[])object2, 0, n3);
                        } while (-1 != n3);
                        ((OutputStream)object3).close();
                    } else {
                        String string3;
                        object3 = ((ServerFile)object).getUploadCellWriter();
                        object2 = new LineNumberReader(new InputStreamReader(System.in));
                        while (null != (string3 = ((LineNumberReader)object2).readLine())) {
                            objectArray = string3.split("\\t");
                            if (1 == ((LineNumberReader)object2).getLineNumber()) {
                                object3.writeHeaderRow(objectArray);
                                continue;
                            }
                            object3.writeDataRow(objectArray);
                        }
                        object3.close();
                    }
                    System.out.println("Upload to " + fileId + " completed.");
                    continue;
                }
                if (n >= stringArray.length) {
                    Program.displayHelp();
                    return;
                }
                if (string == "-s" || string == "-service") {
                    serviceLocation = new URI(stringArray[n++]);
                    continue;
                }
                if (string == "-u" || string == "-user") {
                    int n4;
                    if ((n4 = ((String)(object = stringArray[n++])).indexOf(58)) != -1) {
                        Program.setUsername(((String)object).substring(0, n4));
                        Program.setPassphrase(((String)object).substring(n4 + 1));
                        continue;
                    }
                    Program.setUsername((String)object);
                    Program.setPassphrase("?");
                    continue;
                }
                if (string == "-v" || string == "-via") {
                    object = new URI(stringArray[n++]);
                    Program.setProxyLocation(new URI(((URI)object).getScheme(), null, ((URI)object).getHost(), ((URI)object).getPort(), null, null, null));
                    continue;
                }
                if (string == "-vu" || string == "-viauser") {
                    int n5;
                    if ((n5 = ((String)(object = stringArray[n++])).indexOf(58)) != -1) {
                        Program.setProxyUsername(((String)object).substring(0, n5));
                        Program.setProxyPassphrase(((String)object).substring(n5 + 1));
                        continue;
                    }
                    Program.setProxyUsername((String)object);
                    Program.setProxyPassphrase("?");
                    continue;
                }
                if (string == "-c" || string == "-certificate") {
                    object = stringArray[n++];
                    Program.setCertificatePath((String)object);
                    continue;
                }
                if (string == "-k" || string == "-keystore") {
                    object = stringArray[n++];
                    Program.setKeyStorePath((String)object);
                    continue;
                }
                if (string == "-ka" || string == "-keystorealias") {
                    object = stringArray[n++];
                    Program.setKeyStoreAlias((String)object);
                    continue;
                }
                if (string == "-kp" || string == "-keystorepass") {
                    object = stringArray[n++];
                    Program.setKeyStorePassword((String)object);
                    continue;
                }
                if (string == "-w" || string == "-workspace") {
                    workspaceId = stringArray[n++];
                    continue;
                }
                if (string == "-m" || string == "-model") {
                    modelId = stringArray[n++];
                    continue;
                }
                if (string == "-mo" || string == "-module") {
                    moduleId = stringArray[n++];
                    continue;
                }
                if (string == "-vi" || string == "-view") {
                    viewId = stringArray[n++];
                    continue;
                }
                if (string == "-f" || string == "-file") {
                    fileId = stringArray[n++];
                    continue;
                }
                if (string == "-g" || string == "-get") {
                    somethingDone = true;
                    object = new File(stringArray[n++]);
                    String string4 = fileId != null ? fileId : (exportId != null ? exportId : ((File)object).getName());
                    ServerFile serverFile = Program.getServerFile(workspaceId, modelId, string4, false);
                    if (serverFile == null) continue;
                    serverFile.downLoad((File)object, true);
                    System.out.println("The server file " + string4 + " has been downloaded to " + object);
                    continue;
                }
                if (string == "-p" || string == "-put") {
                    somethingDone = true;
                    object = new File(stringArray[n++]);
                    String string5 = fileId == null ? ((File)object).getName() : fileId;
                    ServerFile serverFile = Program.getServerFile(workspaceId, modelId, string5, true);
                    if (serverFile == null) continue;
                    serverFile.upLoad((File)object, true);
                    System.out.println("The file \"" + object + "\" has been uploaded as " + string5 + ".");
                    continue;
                }
                if (string == "-i" || string == "-import") {
                    importId = stringArray[n++];
                    exportId = null;
                    actionId = null;
                    processId = null;
                    continue;
                }
                if (string == "-e" || string == "-export") {
                    importId = null;
                    exportId = stringArray[n++];
                    actionId = null;
                    processId = null;
                    continue;
                }
                if (string == "-a" || string == "-action") {
                    importId = null;
                    exportId = null;
                    actionId = stringArray[n++];
                    processId = null;
                    continue;
                }
                if (string == "-pr" || string == "-process") {
                    importId = null;
                    exportId = null;
                    actionId = null;
                    processId = stringArray[n++];
                    continue;
                }
                if (string == "-xl" || string == "-locale") {
                    object = stringArray[n++].split("_");
                    taskParameters.setLocale(object[0], ((String[])object).length > 0 ? object[1] : null);
                    continue;
                }
                if (string == "-xc" || string == "-connectorproperty") {
                    if (((String[])(object = stringArray[n++].split(":", 2))).length != 2) {
                        throw new IllegalArgumentException("expected " + string + " [(<source>|<type>)/]property:(value|?)");
                    }
                    String[] stringArray5 = object[0].split("/", 2);
                    String string6 = object[0];
                    if (stringArray5.length < 2) {
                        string6 = "Import source/" + string6;
                    }
                    String string7 = stringArray5[stringArray5.length - 1];
                    objectArray = Program.promptForValue(string6, (String)object[1], string7.toLowerCase().endsWith("password"));
                    if (stringArray5.length == 2) {
                        taskParameters.addConnectorParameter(stringArray5[0], stringArray5[1], (String)objectArray);
                        continue;
                    }
                    taskParameters.addConnectorParameter(stringArray5[0], (String)objectArray);
                    continue;
                }
                if (string == "-xm" || string == "-mappingproperty") {
                    if (((String[])(object = stringArray[n++].split(":", 2))).length != 2) {
                        throw new IllegalArgumentException("expected " + string + " [(<import id>|<import name>)/]dimension" + ":(value|?)");
                    }
                    String[] stringArray6 = object[0].split("/", 2);
                    String string8 = Program.promptForValue(object[0], object[1], false);
                    if (stringArray6.length == 2) {
                        taskParameters.addMappingParameter(stringArray6[0], stringArray6[1], string8);
                        continue;
                    }
                    taskParameters.addMappingParameter(stringArray6[0], string8);
                    continue;
                }
                if (string == "-o" || string == "-output") {
                    object = new File(stringArray[n++]);
                    Program.retrieveOutput(lastResult, (File)object);
                    continue;
                }
                if (string == "-loadclass") {
                    object = stringArray[n++];
                    try {
                        Class.forName((String)object);
                    }
                    catch (Throwable throwable) {
                        if (debugLevel > 0) {
                            throwable.printStackTrace();
                            continue;
                        }
                        System.err.println("Warning: -loadclass failed (" + Program.formatThrowable(throwable) + ")");
                    }
                    continue;
                }
                if (string == "-jdbcurl") {
                    jdbcUrl = stringArray[n++];
                    jdbcProps = new Properties();
                    continue;
                }
                if (string.startsWith("-jdbcuser")) {
                    int n6;
                    if (-1 == (n6 = ((String)(object = stringArray[n++])).indexOf(":"))) {
                        object = Program.promptForValue("JDBC user", (String)object, false);
                        jdbcProps.put("user", object);
                        continue;
                    }
                    String string9 = ((String)object).substring(1 + n6);
                    object = ((String)object).substring(0, n6);
                    object = Program.promptForValue("JDBC User", (String)object, false);
                    string9 = Program.promptForValue("JDBC Password", string9, true);
                    jdbcProps.put("user", object);
                    jdbcProps.put("password", string9);
                    continue;
                }
                if (string.startsWith("-jdbcfetchsize")) {
                    try {
                        jdbcFetchSize = new Integer(stringArray[n++]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.err.println("Warning: failed to parse jdbcfetchsize parameter");
                    }
                    continue;
                }
                if (string.startsWith("-jdbcproperty")) {
                    object = stringArray[n++];
                    String string10 = null;
                    int n7 = ((String)object).indexOf(":");
                    if (-1 != n7) {
                        string10 = ((String)object).substring(1 + n7);
                        object = ((String)object).substring(0, n7);
                    }
                    string10 = Program.promptForValue("JDBC " + (String)object, string10, ((String)object).equals("password"));
                    jdbcProps.put(object, string10);
                    continue;
                }
                if (string == "-jdbcquery") {
                    ServerFile serverFile;
                    somethingDone = true;
                    if (((String)(object = stringArray[n++])).startsWith("@")) {
                        String string11;
                        LineNumberReader lineNumberReader = new LineNumberReader(new FileReader(((String)object).substring(1)));
                        StringBuilder stringBuilder = new StringBuilder();
                        while (null != (string11 = lineNumberReader.readLine())) {
                            stringBuilder.append(string11).append('\n');
                        }
                        lineNumberReader.close();
                        object = stringBuilder.toString();
                        if (debugLevel > 0) {
                            System.err.println("JDBC query:");
                            System.err.println((String)object);
                        }
                    }
                    if ((serverFile = Program.getServerFile(workspaceId, modelId, fileId, true)) == null) continue;
                    CellWriter cellWriter = null;
                    CellReader cellReader = null;
                    try {
                        cellWriter = serverFile.getUploadCellWriter();
                        cellReader = new JDBCCellReader(jdbcUrl, jdbcProps, (String)object, jdbcFetchSize, debugLevel > 0);
                        objectArray = cellReader.getHeaderRow();
                        cellWriter.writeHeaderRow(objectArray);
                        int n8 = 0;
                        do {
                            if (null == (objectArray = cellReader.readDataRow())) continue;
                            cellWriter.writeDataRow(objectArray);
                            ++n8;
                        } while (null != objectArray);
                        cellWriter.close();
                        cellWriter = null;
                        System.out.println("Transferred " + n8 + " records");
                        continue;
                    }
                    finally {
                        if (cellReader != null) {
                            cellReader.close();
                        }
                        if (cellWriter != null) {
                            cellWriter.abort();
                        }
                        continue;
                    }
                }
                Program.displayHelp();
                return;
            }
            if (!somethingDone) {
                Program.displayHelp();
            }
            Program.closeDown();
        }
        catch (Throwable throwable) {
            if (debugLevel > 0) {
                Throwable throwable2 = throwable;
                while (null != throwable2.getCause()) {
                    System.err.println(throwable2);
                    throwable2 = throwable2.getCause();
                }
                throwable2.printStackTrace();
            } else if (!(throwable instanceof InterruptedException)) {
                System.err.println(Program.formatThrowable(throwable));
            }
            Program.closeDown();
            System.exit(1);
        }
    }

    protected static synchronized void closeDown() {
        if (service != null && runningTask == null) {
            service.close();
            service = null;
        }
    }

    protected static synchronized TaskResult runTask(Task task) throws AnaplanAPIException, InterruptedException {
        runningTask = task;
        runningThread = Thread.currentThread();
        TaskResult taskResult = Program.trackRunningTask(false);
        runningThread = null;
        runningTask = null;
        return taskResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void cancelRunningTask() {
        if (runningTask != null) {
            try {
                if (System.console() != null) {
                    System.console().printf("\rClient terminated, cancelling...", new Object[0]);
                }
                runningTask.cancel();
                Program.trackRunningTask(true);
            }
            catch (Throwable throwable) {
                if (debugLevel > 0) {
                    Throwable throwable2 = throwable;
                    while (null != throwable2.getCause()) {
                        System.err.println(throwable2);
                        throwable2 = throwable2.getCause();
                    }
                    throwable2.printStackTrace();
                } else {
                    System.err.println(Program.formatThrowable(throwable));
                }
            }
            finally {
                runningTask = null;
                Program.closeDown();
            }
        }
    }

    private static synchronized TaskResult trackRunningTask(boolean bl) throws AnaplanAPIException, InterruptedException {
        String string;
        TaskStatus taskStatus = null;
        int n = 4;
        int n2 = 1000;
        int n3 = 0;
        int n4 = 0;
        if (System.console() != null) {
            System.console().printf("\n", new Object[0]);
        }
        do {
            String string2;
            block23: {
                if (!bl && closingDown) {
                    throw new InterruptedException();
                }
                if (n2 > 0) {
                    Thread.sleep(n2);
                    n3 += n2;
                }
                n2 = n3 > 60000 ? 60000 : (n3 > 10000 ? 10000 : 1000);
                try {
                    taskStatus = runningTask.getStatus();
                    n4 = 0;
                }
                catch (AnaplanAPIException anaplanAPIException) {
                    taskStatus = null;
                    if (++n4 > 30) {
                        System.err.println();
                        throw new AnaplanAPIException("Task was started, but server cannot now be reached - giving up after 30 attempts", anaplanAPIException);
                    }
                    if (quiet || System.console() == null) break block23;
                    string2 = "";
                    string2 = debugLevel > 0 ? "Failed to get status (" + Program.formatThrowable(anaplanAPIException) + "); retrying in " + n2 / 1000 + "s\n" : "Checking in " + n2 / 1000 + "s";
                    String string3 = "\r%-" + n + "s";
                    System.console().printf(string3, string2);
                    n = string2.length();
                }
            }
            if (taskStatus == null || quiet || System.console() == null) continue;
            if (taskStatus.getCurrentStep() != null) {
                string = taskStatus.getCurrentStep();
            } else {
                switch (taskStatus.getTaskState()) {
                    case NOT_STARTED: {
                        string = "Waiting to start";
                        break;
                    }
                    case IN_PROGRESS: {
                        string = "In progress";
                        break;
                    }
                    case COMPLETE: {
                        string = "Complete";
                        break;
                    }
                    case CANCELLING: {
                        string = "Cancelling";
                        break;
                    }
                    case CANCELLED: {
                        string = "Cancelled";
                        break;
                    }
                    default: {
                        string = taskStatus.getTaskState().toString();
                        string = string.replace('_', ' ');
                        string = string.charAt(0) + string.substring(1).toLowerCase();
                    }
                }
            }
            if (taskStatus.getProgress() > 0.0) {
                string = string + " (" + Math.floor(taskStatus.getProgress() * 1000.0) / 10.0 + "%)";
            }
            string2 = "\r%-" + n + "s";
            System.console().printf(string2, string);
            n = string.length();
        } while (taskStatus == null || taskStatus.getTaskState() != TaskStatus.State.COMPLETE && taskStatus.getTaskState() != TaskStatus.State.CANCELLED);
        if (taskStatus.getTaskState() == TaskStatus.State.CANCELLED) {
            string = "The operation was cancelled";
            if (taskStatus.getCancelledBy() != null) {
                string = string + " by " + taskStatus.getCancelledBy();
            }
            string = taskStatus.getResult() != null ? string + "; some actions may have completed." : string + ".";
        } else {
            string = taskStatus.getResult() != null ? (taskStatus.getResult().isSuccessful() ? "The operation was successful." : "The operation failed.") : "No result was provided.";
        }
        if (System.console() != null) {
            System.console().printf("\r%-" + n + "s\n", string);
        } else {
            System.out.println(string);
        }
        if (taskStatus.getResult() != null) {
            System.out.println(taskStatus.getResult().toString());
        }
        return taskStatus.getResult();
    }

    protected static void retrieveOutput(TaskResult taskResult, File file) throws AnaplanAPIException, IOException {
        if (taskResult != null) {
            if (!taskResult.getNestedResults().isEmpty()) {
                if (file.exists() && !file.isDirectory()) {
                    throw new IllegalArgumentException("Process dumps require a directory, but path \"" + file.getPath() + " is not a directory");
                }
                if (!file.exists() && !file.mkdirs()) {
                    throw new AnaplanAPIException("Failed to create directory " + file.getPath());
                }
                int n = 0;
                for (TaskResult taskResult2 : taskResult.getNestedResults()) {
                    ServerFile serverFile = taskResult2.getFailureDump();
                    if (serverFile != null) {
                        String string = "" + n;
                        if (taskResult2.getObjectId() != null) {
                            string = string + "-" + taskResult2.getObjectId();
                        }
                        if (taskResult2.getObjectName() != null) {
                            string = string + "-" + taskResult2.getObjectName();
                        }
                        File file2 = new File(file, string);
                        serverFile.downLoad(file2, true);
                        System.out.println("Dump file written to \"" + file2 + "\"");
                    }
                    ++n;
                }
            } else if (taskResult.isFailureDumpAvailable()) {
                ServerFile serverFile = taskResult.getFailureDump();
                serverFile.downLoad(file, true);
                System.out.println("Dump file written to \"" + file + "\"");
            }
        } else {
            System.out.println("No dump file is available.");
            if (file.exists() && !file.isDirectory()) {
                file.delete();
            }
        }
    }

    protected static String formatThrowable(Throwable throwable) {
        StringBuilder stringBuilder = new StringBuilder(throwable instanceof AnaplanAPIException ? "AnaplanAPI" : throwable.getClass().getSimpleName());
        if (stringBuilder.length() > 9 && stringBuilder.toString().endsWith("Exception")) {
            stringBuilder.delete(stringBuilder.length() - 9, stringBuilder.length());
        }
        for (int i = 1; i < stringBuilder.length() - 1; ++i) {
            char c = stringBuilder.charAt(i - 1);
            char c2 = stringBuilder.charAt(i);
            char c3 = stringBuilder.charAt(i + 1);
            if (!Character.isUpperCase(c2)) continue;
            if (!Character.isUpperCase(c3)) {
                stringBuilder.setCharAt(i, Character.toLowerCase(c2));
            }
            if (Character.isUpperCase(c) && Character.isUpperCase(c3)) continue;
            stringBuilder.insert(i++, ' ');
        }
        if (null != throwable.getMessage()) {
            stringBuilder.append(": ").append(throwable.getMessage());
        }
        if (null != throwable.getCause()) {
            stringBuilder.append(" (").append(Program.formatThrowable(throwable.getCause())).append(')');
        }
        return stringBuilder.toString();
    }

    protected static String formatTSV(Object ... objectArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Object object : objectArray) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append('\t');
            }
            if (object == null) continue;
            stringBuilder.append(object.toString());
        }
        return stringBuilder.toString();
    }

    protected static ServerFile getServerFile(String string, String string2, String string3, boolean bl) throws AnaplanAPIException {
        Model model = Program.getModel(string, string2);
        if (model == null) {
            return null;
        }
        if (string3 == null || string3.isEmpty()) {
            System.err.println("A file ID must be provided");
            return null;
        }
        ServerFile serverFile = model.getServerFile(string3);
        if (serverFile == null) {
            if (bl) {
                serverFile = model.createServerFileImportDataSource(string3, "Anaplan Connect");
            } else {
                System.err.println("File \"" + string3 + "\" not found in workspace " + string + ", model " + string2);
            }
        }
        return serverFile;
    }

    protected static Import getImport(String string, String string2, String string3) throws AnaplanAPIException {
        Import import_;
        Model model = Program.getModel(string, string2);
        if (model == null) {
            return null;
        }
        if (string3 == null || string3.isEmpty()) {
            System.err.println("An import ID, code or name must be provided");
        }
        if ((import_ = model.getImport(string3)) == null) {
            System.err.println("Import \"" + string3 + "\" not found in workspace " + string + ", model " + string2);
        }
        return import_;
    }

    protected static Export getExport(String string, String string2, String string3) throws AnaplanAPIException {
        Export export;
        Model model = Program.getModel(string, string2);
        if (model == null) {
            return null;
        }
        if (string3 == null || string3.isEmpty()) {
            System.err.println("An export ID, code or name must be provided");
        }
        if ((export = model.getExport(string3)) == null) {
            System.err.println("Export \"" + string3 + "\" not found in workspace " + string + ", model " + string2);
        }
        return export;
    }

    protected static Action getAction(String string, String string2, String string3) throws AnaplanAPIException {
        Action action;
        Model model = Program.getModel(string, string2);
        if (model == null) {
            return null;
        }
        if (string3 == null || string3.isEmpty()) {
            System.err.println("An action ID, code or name must be provided");
        }
        if ((action = model.getAction(string3)) == null) {
            System.err.println("Action \"" + string3 + "\" not found in workspace " + string + ", model " + string2);
        }
        return action;
    }

    protected static Process getProcess(String string, String string2, String string3) throws AnaplanAPIException {
        Process process;
        Model model = Program.getModel(string, string2);
        if (model == null) {
            return null;
        }
        if (string3 == null || string3.isEmpty()) {
            System.err.println("A process ID, code or name must be provided");
        }
        if ((process = model.getProcess(string3)) == null) {
            System.err.println("Process \"" + string3 + "\" not found in workspace " + string + ", model " + string2);
        }
        return process;
    }

    protected static View getView(String string, String string2, String string3, String string4) throws AnaplanAPIException {
        Module module = Program.getModule(string, string2, string3);
        if (module == null) {
            return null;
        }
        if (string4 == null || string4.isEmpty()) {
            System.err.println("A view ID must be provided");
            return null;
        }
        View view = module.getView(string4);
        if (view == null) {
            System.err.println("View \"" + string4 + "\" not found in workspace \"" + string + "\", model \"" + string2 + "\", module \"" + string3 + "\"");
        }
        return view;
    }

    protected static Module getModule(String string, String string2, String string3) throws AnaplanAPIException {
        Model model = Program.getModel(string, string2);
        if (model == null) {
            return null;
        }
        if (string3 == null || string3.isEmpty()) {
            System.err.println("A module ID must be provided");
            return null;
        }
        Module module = model.getModule(string3);
        if (module == null) {
            System.err.println("Module \"" + string3 + "\" not found in workspace \"" + string + "\", model \"" + string2 + "\"");
        }
        return module;
    }

    protected static Model getModel(String string, String string2) throws AnaplanAPIException {
        Workspace workspace = Program.getWorkspace(string);
        if (workspace == null) {
            return null;
        }
        if (string2 == null || string2.isEmpty()) {
            System.err.println("A model ID must be provided");
            return null;
        }
        Model model = workspace.getModel(string2);
        if (model == null) {
            System.err.println("Model \"" + string2 + "\" not found in workspace \"" + string + "\"");
        }
        return model;
    }

    protected static Workspace getWorkspace(String string) throws AnaplanAPIException {
        if (string == null || string.isEmpty()) {
            System.err.println("A workspace ID must be provided");
            return null;
        }
        Workspace workspace = Program.getService().getWorkspace(string);
        if (workspace == null) {
            System.err.println("Workspace \"" + string + "\" does not exist or is not available to this user");
        }
        return workspace;
    }

    protected static Service getService() throws AnaplanAPIException {
        if (service == null) {
            service = serviceLocation != null ? new Service(serviceLocation) : new Service();
            service.setDebugLevel(debugLevel);
            service.setServiceCredentials(Program.getServiceCredentials());
            if (proxyLocationSet) {
                service.setProxyLocation(proxyLocation);
                Credentials credentials = Program.getProxyCredentials();
                if (credentials != null) {
                    service.setProxyCredentials(credentials);
                }
            }
        }
        return service;
    }

    protected static Credentials getServiceCredentials() throws AnaplanAPIException {
        if (userCertificateAuthentication) {
            try {
                return new Credentials(Program.getCertificate());
            }
            catch (Exception exception) {
                throw new AnaplanAPIException("Could not initialise service credentials", exception);
            }
        }
        return new Credentials(Program.getUsername(), Program.getPassphrase());
    }

    protected static Credentials getProxyCredentials() {
        if (!proxyUsernameSet) {
            return null;
        }
        String[] stringArray = Program.getProxyUsername().split("\\\\");
        if (stringArray.length > 1) {
            String string = stringArray[0];
            String string2 = null;
            String string3 = stringArray[1];
            if (stringArray.length > 2) {
                string2 = string3;
                string3 = stringArray[2];
            }
            return new Credentials(string3, Program.getProxyPassphrase(), string, string2);
        }
        return new Credentials(stringArray[0], Program.getProxyPassphrase());
    }

    protected static String getUsername() {
        if (username == null || username.isEmpty()) {
            Console console = System.console();
            if (console != null) {
                username = console.readLine("Username:", new Object[0]);
            } else {
                throw new UnsupportedOperationException("Username must be specified");
            }
        }
        return username;
    }

    protected static String getPassphrase() {
        if (passphrase == null || passphrase.isEmpty() || passphrase.equals("?")) {
            Console console = System.console();
            if (console != null) {
                passphrase = new String(console.readPassword("Password:", new Object[0]));
            } else {
                throw new UnsupportedOperationException("Password must be specified");
            }
        }
        return passphrase;
    }

    protected static void setServiceLocation(URI uRI) {
        serviceLocation = uRI;
    }

    protected static void setProxyLocation(URI uRI) {
        proxyLocation = uRI;
        proxyLocationSet = true;
    }

    protected static String getProxyUsername() {
        if ("?".equals(proxyUsername)) {
            Console console = System.console();
            if (console != null) {
                proxyUsername = console.readLine("Proxy username:", new Object[0]);
            } else {
                throw new UnsupportedOperationException("Proxy username must be specified");
            }
        }
        return proxyUsername;
    }

    protected static String getProxyPassphrase() {
        if ("?".equals(proxyPassphrase)) {
            Console console = System.console();
            if (console != null) {
                proxyPassphrase = new String(console.readPassword("Proxy password:", new Object[0]));
            } else {
                throw new UnsupportedOperationException("Proxy password must be specified");
            }
        }
        return proxyPassphrase;
    }

    protected static void setDebugLevel(int n) {
        debugLevel = n;
    }

    protected static void setUsername(String string) {
        username = string;
    }

    protected static void setPassphrase(String string) {
        passphrase = string;
    }

    protected static void setProxyUsername(String string) {
        proxyUsername = string;
        proxyUsernameSet = true;
    }

    protected static void setProxyPassphrase(String string) {
        proxyPassphrase = string;
    }

    protected static X509Certificate getCertificate() throws CertificateException, KeyStoreException, NoSuchAlgorithmException, IOException {
        String string = Program.getCertificatePath();
        String string2 = Program.getKeyStorePath();
        if (string != null) {
            File file = new File(string);
            if (file.isFile()) {
                return Program.loadCertificateFromFile(file);
            }
            throw new RuntimeException("The specified certificate path '" + string + "' is invalid");
        }
        if (string2 != null) {
            KeyStore keyStore = KeyStore.getInstance("JKS");
            File file = new File(string2);
            if (file.isFile()) {
                FileInputStream fileInputStream = new FileInputStream(file);
                String string3 = Program.getKeyStorePassword();
                keyStore.load(fileInputStream, string3.toCharArray());
                String string4 = Program.getKeyStoreAlias();
                return (X509Certificate)keyStore.getCertificate(string4);
            }
            throw new IllegalArgumentException("The specified key store path '" + string2 + "' is invalid");
        }
        throw new RuntimeException("Could not load a certificate for authentication");
    }

    protected static String getCertificatePath() {
        return certificatePath;
    }

    protected static void setCertificatePath(String string) {
        certificatePath = string;
        userCertificateAuthentication = true;
    }

    protected static String getKeyStorePath() {
        return keyStorePath;
    }

    protected static void setKeyStorePath(String string) {
        keyStorePath = string;
        userCertificateAuthentication = true;
    }

    protected static String getKeyStoreAlias() {
        return keyStoreAlias;
    }

    protected static void setKeyStoreAlias(String string) {
        keyStoreAlias = string;
    }

    protected static String getKeyStorePassword() {
        if ("?".equals(keyStorePassword)) {
            Program.promptForKeystorePassword();
        } else if (keyStorePassword == null || keyStorePassword.isEmpty()) {
            File file = new File(System.getProperty("user.home"));
            File file2 = new File(file, ".anaplan/api-client/keystore-access.txt");
            if (file2.isFile()) {
                try {
                    String string = Program.readFileContents(file2);
                    return EncodingUtils.decodeAndXor(string);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    throw new RuntimeException("Password file could not be read");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new RuntimeException("Password file could not be read");
                }
            }
            Program.promptForKeystorePassword();
        }
        return keyStorePassword;
    }

    protected static void setKeyStorePassword(String string) {
        keyStorePassword = string;
    }

    protected static String promptForValue(String string, String string2, boolean bl) {
        if (null == string2 || 0 == string2.length() || string2.equals("?")) {
            Console console = System.console();
            if (console != null) {
                string2 = bl ? new String(console.readPassword(string + ":", new Object[0])) : new String(console.readLine(string + ":", new Object[0]));
            } else {
                throw new UnsupportedOperationException("Value for " + string + " must be specified");
            }
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readFileContents(File file) throws FileNotFoundException {
        StringBuilder stringBuilder = new StringBuilder((int)file.length());
        Scanner scanner = new Scanner(file);
        try {
            while (scanner.hasNext()) {
                stringBuilder.append(scanner.next());
            }
            String string = stringBuilder.toString();
            return string;
        }
        finally {
            scanner.close();
        }
    }

    private static X509Certificate loadCertificateFromFile(File file) throws CertificateException, FileNotFoundException {
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        FileInputStream fileInputStream = new FileInputStream(file);
        Collection<? extends Certificate> collection = certificateFactory.generateCertificates(fileInputStream);
        Certificate[] certificateArray = new Certificate[collection.toArray().length];
        if (collection.size() == 1) {
            return (X509Certificate)collection.iterator().next();
        }
        throw new RuntimeException("Certificate file must contain only one certificate (chain length was " + certificateArray.length + ")");
    }

    private static void promptForKeystorePassword() {
        Console console = System.console();
        if (console == null) {
            throw new UnsupportedOperationException("Key store password must be specified");
        }
        keyStorePassword = new String(console.readPassword("Key store password:", new Object[0]));
    }

    private static void displayHelp() {
        File file = new File(System.getProperty("user.dir"), ".anaplan/api-client/keystore-access.txt");
        System.err.println("Options are:\n\nGeneral:\n--------\n(-h|-help): display this help\n(-version): display version information\n(-d|-debug): Show more detailed output\n(-q|-quiet): Show less detailed output\n\nConnection:\n-----------\n(-s|-service) <service URI>: API service endpoint (defaults to https://api.anaplan.com/)\n(-u|-user) <username>[:<password>]: Anaplan user name + (optional) password\n(-c|-certificate) <certificate path>: Path to user certificate used for authentication (an alternative to using a key store)\n(-k|-keystore) <keystore path>: Path to local key store containing user certificate(s) for authentication\n(-kp|-keystorepass) <keystore password>: Password for the key store (if not provided, password is read from obfuscated file '" + file.getAbsolutePath() + "', or prompted for)\n" + "(-ka|-keystorealias) <keystore alias>" + ": Alias of the public certificate in the specified key store\n" + "(-v|-via) <proxy URI>: use specified proxy\n" + "(-vu|-viauser) [<domain>[\\<workstation>]\\]<username>[:<password>]: use proxy credentials\n" + "\n" + "Workspace Contents:\n" + "-------------------\n" + "(-W|-workspaces): list available workspaces\n" + "(-w|-workspace) (<id>|<name>): select a workspace by id/name\n" + "(-M|-models): list available models in selected workspace\n" + "(-m|-model) (<id>|<name>): select a model by id/name\n" + "(-MO|-modules): list available modules in selected model\n" + "(-mo|-module): (<id>|<name>): select a module by id/name\n" + "(-VI|-views): list available views in selected module\n" + "(-vi|-view): (<id>|<name>): select a view by id/name\n" + "(-F|-files): list available server files in selected model\n" + "(-f|-file) (<id>|<name>): select a server file by id/name\n" + "\n" + "Data Transfer:\n" + "--------------\n" + "(-g|-get) <local path>: Download specified server file to local file\n" + "-gets Write specified server file to standard output\n" + "-getc Write tab-separated server file to standard output\n" + "(-p|-put) <local path>: Upload to specified server file from local file\n" + "-puts Upload to specified server file from standard input\n" + "-putc Upload to specified server file from tab-separated standard input\n" + "\n" + "Server Actions:\n" + "---------------\n" + "(-I|-imports): list available imports in selected model\n" + "(-i|-import) (<id>|<name>): select an import by id/name\n" + "(-E|-exports): list available exports in selected model\n" + "(-e|-export) (<id>|<name>): select an export by id/name\n" + "(-A|-actions): list available actions in selected model\n" + "(-a|-action) (<id>|<name>): select an action by id/name\n" + "(-P|-processes): list available processes in selected model\n" + "(-pr|-process) <id/name>: select a process by id/name\n" + "(-xl|-locale) <locale> Specify locale (eg en_US) to perform server opertion\n" + "(-xc|-connectorproperty) [(<source>|<type>)/]property:(value|?):\n" + "    specify import data source connection property\n" + "(-xm|-mappingproperty) [(<import id>|<import name>)/]dimension:(value|?):\n" + "    specify prompt-at-runtime import mapping value" + "(-x|-execute): Run the selected import/export/action/process\n" + "\n" + "Action Information:\n" + "-------------------\n" + "(-o|-output) <local path>: Retrieve dump file(s) for completed import/process\n" + "-emd <local path>: Get metadata for an export\n" + "\n" + "JDBC:\n" + "-----\n" + "-loadclass <class name>: Load a Java class\n" + "-jdbcurl: JDBC URL for -jdbcquery to connect to\n" + "-jdbcuser (<username>|?)[:(<password>|?)]: JDBC username and password\n" + "-jdbcproperty <propname>:(<propval>|?): set JDBC connection property\n" + "-jdbcquery (<query>|@<queryfile>): retrieve data from JDBC data source\n" + "-jdbcfetchsize <size>: hint to transfer <size> records at a time\n");
    }

    private static void displayVersion() {
        System.out.println("Anaplan Connect 1.3.4prod");
        System.out.println(System.getProperty("java.vm.name") + " (" + System.getProperty("java.vendor") + ")/" + System.getProperty("java.vm.version") + " (" + System.getProperty("java.version") + ")");
        System.out.println(System.getProperty("os.name") + " (" + System.getProperty("os.arch") + ")/" + System.getProperty("os.version"));
    }

    static {
        try {
            Thread thread = new Thread(){

                @Override
                public void run() {
                    block3: {
                        closingDown = true;
                        Thread thread = runningThread;
                        if (thread != null) {
                            try {
                                thread.interrupt();
                            }
                            catch (Throwable throwable) {
                                if (debugLevel <= 0) break block3;
                                throwable.printStackTrace();
                            }
                        }
                    }
                    Program.cancelRunningTask();
                }
            };
            thread.setDaemon(true);
            Runtime.getRuntime().addShutdownHook(thread);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }
}

