/*
 * Decompiled with CFR 0.152.
 */
package com.anaplan.client;

import com.anaplan.client.AnaplanAPIException;
import com.anaplan.client.CellReader;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import java.util.logging.Logger;

public class JDBCCellReader
implements CellReader {
    private static final Logger logger = Logger.getLogger("anaplan-connect.jdbc");
    private Connection connection;
    private boolean autoCommit;
    private Statement statement;
    private ResultSet resultSet;
    private int columnCount;
    private String[] headerRow;
    private int[] columnTypes;
    private boolean debug;

    public JDBCCellReader(String string, Properties properties, String string2) throws SQLException {
        this(string, properties, string2, null, false);
    }

    public JDBCCellReader(String string, Properties properties, String string2, Integer n, boolean bl) throws SQLException {
        block7: {
            block6: {
                this.connection = DriverManager.getConnection(string, properties);
                try {
                    this.connection.setAutoCommit(false);
                    this.autoCommit = false;
                }
                catch (SQLException sQLException) {
                    this.autoCommit = true;
                    if (!bl) break block6;
                    logger.warning("Warning: setAutoCommit failed(" + sQLException + ")");
                }
            }
            this.statement = this.connection.createStatement(1003, 1007);
            if (n != null) {
                try {
                    this.statement.setFetchSize(n);
                }
                catch (SQLException sQLException) {
                    if (!bl) break block7;
                    logger.warning("Warning: setFetchSize failed(" + sQLException + ")");
                }
            }
        }
        this.resultSet = this.statement.executeQuery(string2);
        ResultSetMetaData resultSetMetaData = this.resultSet.getMetaData();
        this.columnCount = resultSetMetaData.getColumnCount();
        this.headerRow = new String[this.columnCount];
        this.columnTypes = new int[this.columnCount];
        for (int i = 0; i < this.columnCount; ++i) {
            this.headerRow[i] = resultSetMetaData.getColumnLabel(i + 1);
            this.columnTypes[i] = resultSetMetaData.getColumnType(i + 1);
        }
    }

    @Override
    public String[] getHeaderRow() {
        return this.headerRow;
    }

    @Override
    public String[] readDataRow() throws AnaplanAPIException {
        try {
            if (this.resultSet == null || !this.resultSet.next()) {
                return null;
            }
            String[] stringArray = new String[this.columnCount];
            for (int i = 0; i < this.columnCount; ++i) {
                Object object = this.resultSet.getObject(i + 1);
                stringArray[i] = object == null ? "" : object.toString();
            }
            return stringArray;
        }
        catch (SQLException sQLException) {
            throw new AnaplanAPIException("Failed to retrieve result data", sQLException);
        }
    }

    @Override
    public void close() {
        block17: {
            if (this.resultSet != null) {
                block14: {
                    try {
                        this.resultSet.close();
                    }
                    catch (SQLException sQLException) {
                        if (!this.debug) break block14;
                        logger.warning("Warning: failed to close result set: " + sQLException);
                    }
                }
                this.resultSet = null;
            }
            if (this.statement != null) {
                block15: {
                    try {
                        this.statement.close();
                    }
                    catch (SQLException sQLException) {
                        if (!this.debug) break block15;
                        logger.warning("Warning: failed to close prepared statement: " + sQLException);
                    }
                }
                this.statement = null;
            }
            boolean bl = false;
            try {
                bl = this.connection.isClosed();
            }
            catch (SQLException sQLException) {
                logger.warning("Warning: failed to determine if JDBC connection closed: " + sQLException);
            }
            if (this.connection != null && !bl) {
                block16: {
                    if (!this.autoCommit) {
                        try {
                            this.connection.commit();
                        }
                        catch (SQLException sQLException) {
                            if (!this.debug) break block16;
                            logger.warning("Warning: failed to commit JDBC connection: " + sQLException);
                        }
                    }
                }
                try {
                    this.connection.close();
                }
                catch (SQLException sQLException) {
                    if (!this.debug) break block17;
                    logger.warning("Warning: failed to close JDBC connection: " + sQLException);
                }
            }
        }
        this.connection = null;
    }

    @Override
    public String readWholeDataRow() throws AnaplanAPIException, IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getWholeHeaderRow() throws AnaplanAPIException, IOException {
        throw new UnsupportedOperationException();
    }
}

