/*
 * Decompiled with CFR 0.152.
 */
package com.anaplan.connector.utils;

import com.anaplan.client.AnaplanAPIException;
import com.anaplan.client.CellWriter;
import com.anaplan.client.Import;
import com.anaplan.client.Model;
import com.anaplan.client.ServerFile;
import com.anaplan.client.Task;
import com.anaplan.client.TaskResult;
import com.anaplan.client.TaskStatus;
import com.anaplan.connector.MulesoftAnaplanResponse;
import com.anaplan.connector.connection.AnaplanConnection;
import com.anaplan.connector.exceptions.AnaplanOperationException;
import com.anaplan.connector.utils.AnaplanUtil;
import com.anaplan.connector.utils.BaseAnaplanOperation;
import com.anaplan.connector.utils.LogUtil;
import com.anaplan.connector.utils.UserMessages;
import com.google.gson.JsonSyntaxException;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;

public class AnaplanImportOperation
extends BaseAnaplanOperation {
    protected static String[] HEADER;

    public AnaplanImportOperation(AnaplanConnection apiConn) {
        super(apiConn);
    }

    private static String generateDelimiterRegex(String columnSeparator, String delimiter) {
        return columnSeparator.trim() + "(?=([^\\" + delimiter.trim() + "]*\\" + delimiter.trim() + "[^\\" + delimiter.trim() + "]*\\" + delimiter.trim() + ")*[^\\" + delimiter.trim() + "]*$)";
    }

    private static List<String[]> parseImportData(InputStream is, int rowCount, String columnSeparator, String delimiter) throws IOException {
        String line;
        ArrayList<String[]> rows = new ArrayList<String[]>();
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        String delimRegex = AnaplanImportOperation.generateDelimiterRegex(columnSeparator, delimiter);
        while ((line = reader.readLine()) != null) {
            String[] cellTokens = line.split(delimRegex);
            for (int i = 0; i < cellTokens.length; ++i) {
                cellTokens[i] = cellTokens[i].replaceAll("^\"|\"$", "");
            }
            if (rowCount == 0) {
                HEADER = cellTokens;
            } else {
                rows.add(cellTokens);
            }
            ++rowCount;
        }
        return rows;
    }

    private static MulesoftAnaplanResponse runImportCsv(String data, Model model, String importId, String columnSeparator, String delimiter, String logContext) throws AnaplanAPIException, IOException {
        int rowsProcessed = 0;
        Import imp = model.getImport(importId);
        if (imp == null) {
            String msg = "Invalid import!";
            return MulesoftAnaplanResponse.importFailure("Invalid import!", null, logContext);
        }
        ServerFile serverFile = model.getServerFile(imp.getSourceFileId());
        if (serverFile != null) {
            serverFile.setSeparator(columnSeparator);
            serverFile.setDelimiter(delimiter);
            int rowCount = 0;
            ByteArrayInputStream is = new ByteArrayInputStream(data.getBytes());
            List<String[]> rows = AnaplanImportOperation.parseImportData(is, rowCount, columnSeparator, delimiter);
            CellWriter dataWriter = serverFile.getUploadCellWriter();
            dataWriter.writeHeaderRow((Object[])HEADER);
            LogUtil.status(logContext, "import header is:\n" + AnaplanUtil.debug_output(HEADER));
            for (Object[] objectArray : rows) {
                dataWriter.writeDataRow(objectArray);
                LogUtil.trace(logContext, rowsProcessed + "-" + AnaplanUtil.debug_output((String[])objectArray));
                ++rowsProcessed;
            }
            dataWriter.close();
        }
        Task task = imp.createTask();
        TaskStatus status = AnaplanUtil.runServerTask(task, logContext);
        String taskDetailsMsg = AnaplanImportOperation.collectTaskLogs(status) + "Import completed successfully: (" + rowsProcessed + " records processed)";
        AnaplanImportOperation.setRunStatusDetails(taskDetailsMsg);
        LogUtil.status(logContext, AnaplanImportOperation.getRunStatusDetails());
        TaskResult taskResult = status.getResult();
        if (taskResult.isFailureDumpAvailable()) {
            LogUtil.status(logContext, UserMessages.getMessage("failureDump"));
            ServerFile failDump = taskResult.getFailureDump();
            return MulesoftAnaplanResponse.importWithFailureDump(UserMessages.getMessage("importBadData", importId), failDump, logContext);
        }
        LogUtil.status(logContext, UserMessages.getMessage("noFailureDump"));
        if (taskResult.isSuccessful()) {
            return MulesoftAnaplanResponse.importSuccess(AnaplanImportOperation.getRunStatusDetails(), logContext, serverFile);
        }
        return MulesoftAnaplanResponse.importFailure(AnaplanImportOperation.getRunStatusDetails(), null, logContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String runImport(String data, String workspaceId, String modelId, String importId, String columnSeparator, String delimiter) throws AnaplanOperationException {
        String importLogContext = this.apiConn.getLogContext() + " [" + importId + "]";
        LogUtil.status(this.apiConn.getLogContext(), "<< Starting import >>");
        LogUtil.status(this.apiConn.getLogContext(), "Workspace-ID: " + workspaceId);
        LogUtil.status(this.apiConn.getLogContext(), "Model-ID: " + modelId);
        LogUtil.status(this.apiConn.getLogContext(), "Import-ID: " + importId);
        this.validateInput(workspaceId, modelId);
        try {
            LogUtil.status(importLogContext, "Starting import: " + importId);
            MulesoftAnaplanResponse anaplanResponse = AnaplanImportOperation.runImportCsv(data, this.model, importId, columnSeparator, delimiter, importLogContext);
            anaplanResponse.writeImportData(this.apiConn, importId);
            LogUtil.status(importLogContext, "Import complete: Status: " + (Object)((Object)anaplanResponse.getStatus()) + ", Response message: " + anaplanResponse.getResponseMessage());
        }
        catch (IOException e) {
            MulesoftAnaplanResponse.responseEpicFail(this.apiConn, e, null);
        }
        catch (JsonSyntaxException e) {
            MulesoftAnaplanResponse.responseEpicFail(this.apiConn, e, null);
        }
        catch (AnaplanAPIException e) {
            MulesoftAnaplanResponse.responseEpicFail(this.apiConn, e, null);
        }
        finally {
            this.apiConn.closeConnection();
        }
        String statusMsg = "[" + importId + "] ran successfully!";
        LogUtil.status(importLogContext, statusMsg);
        return statusMsg + "\n\n" + AnaplanImportOperation.getRunStatusDetails();
    }
}

