/*
 * Decompiled with CFR 0.152.
 */
package com.anaplan.connector.connection;

import com.anaplan.client.Service;
import com.anaplan.connector.connection.AnaplanConnection;
import com.anaplan.connector.exceptions.AnaplanConnectionException;
import com.anaplan.connector.utils.LogUtil;
import org.mule.api.ConnectionException;
import org.mule.api.ConnectionExceptionCode;

public class BaseConnectionStrategy {
    protected AnaplanConnection apiConn;

    public AnaplanConnection getApiConnection() {
        return this.apiConn;
    }

    public void disconnect() {
        if (this.apiConn != null) {
            this.apiConn.closeConnection();
        } else {
            LogUtil.error(this.getClass().toString(), "No connStrategy to disconnect!");
        }
    }

    public boolean isConnected() {
        return this.apiConn != null;
    }

    public String connectionId() {
        if (this.apiConn != null) {
            return this.apiConn.getConnectionId();
        }
        return "Not connected!";
    }

    protected synchronized void connectToApi() throws ConnectionException {
        Service service;
        try {
            service = this.apiConn.openConnection();
        }
        catch (AnaplanConnectionException e) {
            throw new ConnectionException(ConnectionExceptionCode.INCORRECT_CREDENTIALS, null, e.getMessage(), (Throwable)e);
        }
        if (service == null) {
            throw new ConnectionException(ConnectionExceptionCode.UNKNOWN, null, "No service object acquired after opening connStrategy to Anaplan API!", null);
        }
        LogUtil.status(this.getClass().toString(), "Successfully connected to Anaplan API!");
    }

    public void validateConnection() throws AnaplanConnectionException {
        if (this.isConnected()) {
            if (this.apiConn.getConnection() == null) {
                this.apiConn.openConnection();
            } else {
                LogUtil.status(this.apiConn.getLogContext(), "Connection to API exists. Proceeding...");
            }
        } else {
            throw new AnaplanConnectionException("No connStrategy object: call connect()");
        }
    }
}

