/*
 * Decompiled with CFR 0.152.
 */
package com.anaplan.connector;

import com.anaplan.connector.connection.BaseConnectionStrategy;
import com.anaplan.connector.exceptions.AnaplanConnectionException;
import com.anaplan.connector.exceptions.AnaplanOperationException;
import com.anaplan.connector.utils.AnaplanDeleteOperation;
import com.anaplan.connector.utils.AnaplanExportOperation;
import com.anaplan.connector.utils.AnaplanImportOperation;
import com.anaplan.connector.utils.AnaplanProcessOperation;
import org.mule.api.annotations.param.Payload;

public class AnaplanConnector {
    private static AnaplanExportOperation exporter;
    private static AnaplanImportOperation importer;
    private static AnaplanDeleteOperation deleter;
    private static AnaplanProcessOperation processRunner;
    private BaseConnectionStrategy connectionStrategy;

    public BaseConnectionStrategy getConnectionStrategy() {
        return this.connectionStrategy;
    }

    public void setConnectionStrategy(BaseConnectionStrategy connStrategy) {
        this.connectionStrategy = connStrategy;
    }

    public String importToModel(@Payload String data, String workspaceId, String modelId, String importId, String columnSeparator, String delimiter) throws AnaplanConnectionException, AnaplanOperationException {
        this.connectionStrategy.validateConnection();
        importer = new AnaplanImportOperation(this.connectionStrategy.getApiConnection());
        return importer.runImport(data, workspaceId, modelId, importId, columnSeparator, delimiter);
    }

    public String exportFromModel(String workspaceId, String modelId, String exportId) throws AnaplanConnectionException, AnaplanOperationException {
        this.connectionStrategy.validateConnection();
        exporter = new AnaplanExportOperation(this.connectionStrategy.getApiConnection());
        return exporter.runExport(workspaceId, modelId, exportId);
    }

    public String deleteFromModel(String workspaceId, String modelId, String deleteActionId) throws AnaplanConnectionException, AnaplanOperationException {
        this.connectionStrategy.validateConnection();
        deleter = new AnaplanDeleteOperation(this.connectionStrategy.getApiConnection());
        return deleter.runDeleteAction(workspaceId, modelId, deleteActionId);
    }

    public String runProcess(String workspaceId, String modelId, String processId) throws AnaplanConnectionException, AnaplanOperationException {
        this.connectionStrategy.validateConnection();
        processRunner = new AnaplanProcessOperation(this.connectionStrategy.getApiConnection());
        return processRunner.runProcess(workspaceId, modelId, processId);
    }
}

