/*
 * Decompiled with CFR 0.152.
 */
package com.anaplan.connector.utils;

import com.anaplan.client.AnaplanAPIException;
import com.anaplan.client.Model;
import com.anaplan.client.Process;
import com.anaplan.client.Task;
import com.anaplan.client.TaskStatus;
import com.anaplan.connector.MulesoftAnaplanResponse;
import com.anaplan.connector.connection.AnaplanConnection;
import com.anaplan.connector.exceptions.AnaplanOperationException;
import com.anaplan.connector.utils.AnaplanUtil;
import com.anaplan.connector.utils.BaseAnaplanOperation;
import com.anaplan.connector.utils.LogUtil;
import com.anaplan.connector.utils.UserMessages;

public class AnaplanProcessOperation
extends BaseAnaplanOperation {
    public AnaplanProcessOperation(AnaplanConnection apiConn) {
        super(apiConn);
    }

    private MulesoftAnaplanResponse runProcessTask(Model model, String processId, String logContext) throws AnaplanAPIException {
        Process process = model.getProcess(processId);
        if (process == null) {
            String msg = UserMessages.getMessage("invalidProcess", processId);
            return MulesoftAnaplanResponse.runProcessFailure(msg, null, logContext);
        }
        Task task = process.createTask();
        TaskStatus status = AnaplanUtil.runServerTask(task, logContext);
        if (status.getTaskState() == TaskStatus.State.COMPLETE && status.getResult().isSuccessful()) {
            LogUtil.status(logContext, "Process ran successfully!");
            AnaplanProcessOperation.setRunStatusDetails(AnaplanProcessOperation.collectTaskLogs(status));
            return MulesoftAnaplanResponse.runProcessSuccess(status.getTaskState().name(), logContext);
        }
        return MulesoftAnaplanResponse.runProcessFailure("Run Process failed!", null, logContext);
    }

    public String runProcess(String workspaceId, String modelId, String processId) throws AnaplanOperationException {
        String processLogContext = this.apiConn.getLogContext() + "[" + processId + "]";
        LogUtil.status(this.apiConn.getLogContext(), "<< Starting Process >>");
        LogUtil.status(this.apiConn.getLogContext(), "Workspace-ID: " + workspaceId);
        LogUtil.status(this.apiConn.getLogContext(), "Model-ID: " + modelId);
        LogUtil.status(this.apiConn.getLogContext(), "Process-ID: " + processId);
        this.validateInput(workspaceId, modelId);
        try {
            LogUtil.status(processLogContext, "Starting process: " + processId);
            MulesoftAnaplanResponse anaplanResponse = this.runProcessTask(this.model, processId, processLogContext);
            LogUtil.status(processLogContext, "Process ran successfully:" + (Object)((Object)anaplanResponse.getStatus()) + ", Response message: " + anaplanResponse.getResponseMessage());
        }
        catch (AnaplanAPIException e) {
            throw new AnaplanOperationException(e.getMessage(), e);
        }
        finally {
            this.apiConn.closeConnection();
        }
        String statusMsg = "[" + processId + "] completed successfully!";
        LogUtil.status(processLogContext, statusMsg);
        return statusMsg + "\n\n" + AnaplanProcessOperation.getRunStatusDetails();
    }
}

