/*
 * Decompiled with CFR 0.152.
 */
package com.anaplan.connector;

import com.anaplan.client.AnaplanAPIException;
import com.anaplan.client.CellReader;
import com.anaplan.client.ExportMetadata;
import com.anaplan.client.ServerFile;
import com.anaplan.connector.connection.AnaplanConnection;
import com.anaplan.connector.exceptions.AnaplanOperationException;
import com.anaplan.connector.utils.LogUtil;
import com.anaplan.connector.utils.OperationStatus;
import com.anaplan.connector.utils.UserMessages;
import java.io.IOException;
import java.io.Serializable;

public class MulesoftAnaplanResponse
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String responseMessage;
    private final ServerFile serverFile;
    private final ExportMetadata exportMetadata;
    private final OperationStatus status;
    private final String logContext;
    private final Throwable exception;

    private MulesoftAnaplanResponse(String responseMessage, OperationStatus status, ServerFile serverFile, ExportMetadata exportMetaData, Throwable failureCause, String logContext) {
        this.responseMessage = responseMessage;
        this.status = status;
        this.serverFile = serverFile;
        this.exportMetadata = exportMetaData;
        this.exception = failureCause;
        this.logContext = logContext;
        LogUtil.status(logContext, "created " + this.toString());
    }

    public OperationStatus getStatus() {
        return this.status;
    }

    public String getResponseMessage() {
        return this.responseMessage;
    }

    public ServerFile getServerFile() {
        return this.serverFile;
    }

    public ExportMetadata getExportMetadata() {
        return this.exportMetadata;
    }

    public String getLogContext() {
        return this.logContext;
    }

    public Throwable getException() {
        return this.exception;
    }

    private String writeResponse(CellReader cellReader, String logContext) throws AnaplanAPIException, IOException {
        String stringBuffer = "";
        String header = cellReader.getWholeHeaderRow() + "\n";
        LogUtil.debug(logContext, header);
        stringBuffer = stringBuffer + header;
        String dataLine = cellReader.readWholeDataRow();
        while (dataLine != null) {
            dataLine = dataLine + "\n";
            LogUtil.trace(logContext, dataLine);
            stringBuffer = stringBuffer + dataLine;
            dataLine = cellReader.readWholeDataRow();
        }
        LogUtil.debug(logContext, "finished writing file");
        return stringBuffer;
    }

    private String responseServerFile(ServerFile serverFile, String logContext) throws IOException, AnaplanAPIException {
        if (serverFile == null) {
            throw new AnaplanAPIException("Response is empty: " + (Object)((Object)this.getStatus()));
        }
        CellReader cellReader = serverFile.getDownloadCellReader();
        if (this.getExportMetadata() != null) {
            LogUtil.debug(logContext, this.getExportMetadata().collectExportFileInfo());
        }
        return this.writeResponse(cellReader, logContext);
    }

    public void writeImportData(AnaplanConnection connection, String importId) throws AnaplanOperationException, IOException, AnaplanAPIException {
        if (this.getServerFile() != null) {
            this.responseServerFile(this.getServerFile(), this.getLogContext());
        } else if (this.getStatus() == OperationStatus.SUCCESS) {
            LogUtil.status(UserMessages.getMessage("importSuccess", importId), this.getResponseMessage());
        } else if (this.getException() == null) {
            MulesoftAnaplanResponse.responseFail(connection, this.getResponseMessage());
        } else {
            MulesoftAnaplanResponse.responseEpicFail(connection, this.getException(), this.getResponseMessage());
        }
    }

    public String writeExportData(AnaplanConnection connection) throws IOException, AnaplanAPIException, AnaplanOperationException {
        if (this.getStatus() != OperationStatus.SUCCESS) {
            if (this.getException() == null) {
                MulesoftAnaplanResponse.responseFail(connection, this.getResponseMessage());
            } else {
                MulesoftAnaplanResponse.responseEpicFail(connection, this.getException(), this.getResponseMessage());
            }
        }
        return this.responseServerFile(this.getServerFile(), this.getLogContext());
    }

    public String toString() {
        String strBuffer = "";
        strBuffer = strBuffer + "AnaplanResponse with status ";
        strBuffer = strBuffer + (this.status == null ? "null" : this.status.toString());
        strBuffer = strBuffer + "; message: ";
        strBuffer = strBuffer + (this.responseMessage == null ? "null" : this.responseMessage);
        strBuffer = strBuffer + "; serverfile ";
        strBuffer = strBuffer + (this.serverFile == null ? "null" : this.serverFile.getName());
        strBuffer = strBuffer + "; exportmetadata: ";
        strBuffer = strBuffer + (this.exportMetadata == null ? "null" : this.exportMetadata.collectExportFileInfo());
        return strBuffer;
    }

    public static void responseFail(AnaplanConnection connection, String reason) {
        LogUtil.error(connection.getLogContext(), "Aborting operation for all documents in request: " + reason);
    }

    public static void responseEpicFail(AnaplanConnection connection, Throwable e, String reason) throws AnaplanOperationException {
        String msg = reason == null ? "Unexpected operation error: Generating OperationResponse error for " + e.getMessage() : reason + ": " + e.getMessage();
        LogUtil.error(connection.getLogContext(), msg, e);
        throw new AnaplanOperationException(e.getMessage());
    }

    public static MulesoftAnaplanResponse exportSuccess(String responseMessage, ServerFile exportOutput, ExportMetadata exportMetadata, String logContext) throws IllegalArgumentException {
        if (exportOutput == null) {
            LogUtil.error(logContext, "discarding response for task" + responseMessage);
            throw new IllegalArgumentException("Output cannot be null for a successful export");
        }
        return new MulesoftAnaplanResponse(responseMessage, OperationStatus.SUCCESS, exportOutput, exportMetadata, null, logContext);
    }

    public static MulesoftAnaplanResponse exportFailure(String responseMessage, ExportMetadata exportMetadata, Throwable cause, String logContext) {
        return new MulesoftAnaplanResponse(responseMessage, OperationStatus.FAILURE, null, exportMetadata, cause, logContext);
    }

    public static MulesoftAnaplanResponse importSuccess(String responseMessage, String logContext, ServerFile serverFile) {
        return new MulesoftAnaplanResponse(responseMessage, OperationStatus.SUCCESS, serverFile, null, null, logContext);
    }

    public static MulesoftAnaplanResponse importFailure(String responseMessage, Throwable cause, String logContext) {
        return new MulesoftAnaplanResponse(responseMessage, OperationStatus.FAILURE, null, null, cause, logContext);
    }

    public static MulesoftAnaplanResponse importWithFailureDump(String responseMessage, ServerFile failDump, String logContext) {
        return new MulesoftAnaplanResponse(responseMessage, OperationStatus.APPLICATION_ERROR, failDump, null, null, logContext);
    }

    public static MulesoftAnaplanResponse executeActionSuccess(String responseMessage, String logContext) {
        return new MulesoftAnaplanResponse(responseMessage, OperationStatus.SUCCESS, null, null, null, logContext);
    }

    public static MulesoftAnaplanResponse executeActionFailure(String responseMessage, Throwable cause, String logContext) {
        return new MulesoftAnaplanResponse(responseMessage, OperationStatus.FAILURE, null, null, cause, logContext);
    }

    public static MulesoftAnaplanResponse runProcessSuccess(String responseMessage, String logContext) {
        return new MulesoftAnaplanResponse(responseMessage, OperationStatus.SUCCESS, null, null, null, logContext);
    }

    public static MulesoftAnaplanResponse runProcessFailure(String responseMessage, Throwable cause, String logContext) {
        return new MulesoftAnaplanResponse(responseMessage, OperationStatus.FAILURE, null, null, cause, logContext);
    }
}

