/*
 * Decompiled with CFR 0.152.
 */
package com.anaplan.connector.utils;

import com.anaplan.connector.connection.AnaplanConnection;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class LogUtil {
    public static final Level USER_STATUS = Level.INFO;
    public static final Level USER_WARNING = Level.WARN;
    public static final Level USER_ERROR = Level.FATAL;
    public static final Level INTERNAL_DEBUG = Level.DEBUG;
    private static Logger serverLog = LogManager.getLogger();
    public static final Level INTERNAL_TRACE = Level.TRACE;

    private LogUtil() {
    }

    public static void debug(String logContext, String msg) {
        serverLog.log(INTERNAL_DEBUG, logContext + " " + msg);
    }

    public static void trace(String logContext, String msg) {
        serverLog.log(INTERNAL_TRACE, logContext + " " + msg);
    }

    public static void status(String logContext, String msg) {
        serverLog.log(USER_STATUS, logContext + " " + msg);
    }

    public static void warning(String logContext, String msg) {
        serverLog.log(USER_WARNING, logContext + " " + msg);
    }

    public static void error(String logContext, String msg) {
        serverLog.log(USER_ERROR, logContext + " " + msg);
    }

    public static void error(String logContext, String msg, Throwable e) {
        serverLog.log(USER_ERROR, logContext + " " + msg, e);
    }

    public static class ProcessLog
    extends UserLog {
        public ProcessLog(AnaplanConnection connection) {
            super(serverLog, connection.getLogContext());
        }
    }

    public static abstract class UserLog {
        private final Logger logger;
        private final String logContext;

        public UserLog(Logger logger, String logContext) {
            this.logger = logger;
            this.logContext = logContext;
        }

        public void status(String msg) {
            this.logger.log(USER_STATUS, msg);
            LogUtil.status(this.mirrorPrefix() + this.logContext, msg);
        }

        public void warning(String msg) {
            this.logger.log(USER_WARNING, msg);
            LogUtil.warning(this.mirrorPrefix() + this.logContext, msg);
        }

        public void error(String msg) {
            this.logger.log(USER_ERROR, msg);
            LogUtil.error(this.mirrorPrefix() + this.logContext, msg);
        }

        private String mirrorPrefix() {
            return "[" + this.getClass().getSimpleName() + "] ";
        }
    }
}

