/*
 * Decompiled with CFR 0.152.
 */
package com.anaplan.connector.utils;

import com.anaplan.client.Action;
import com.anaplan.client.AnaplanAPIException;
import com.anaplan.client.Model;
import com.anaplan.client.Task;
import com.anaplan.client.TaskStatus;
import com.anaplan.connector.MulesoftAnaplanResponse;
import com.anaplan.connector.connection.AnaplanConnection;
import com.anaplan.connector.exceptions.AnaplanOperationException;
import com.anaplan.connector.utils.AnaplanUtil;
import com.anaplan.connector.utils.BaseAnaplanOperation;
import com.anaplan.connector.utils.LogUtil;
import com.anaplan.connector.utils.UserMessages;

public class AnaplanDeleteOperation
extends BaseAnaplanOperation {
    public AnaplanDeleteOperation(AnaplanConnection apiConn) {
        super(apiConn);
    }

    private static MulesoftAnaplanResponse runDeleteAction(Model model, String actionId, String logContext) throws AnaplanAPIException {
        Action action = model.getAction(actionId);
        if (action == null) {
            String msg = UserMessages.getMessage("invalidAction", actionId);
            return MulesoftAnaplanResponse.executeActionFailure(msg, null, logContext);
        }
        Task task = action.createTask();
        TaskStatus status = AnaplanUtil.runServerTask(task, logContext);
        if (status.getTaskState() == TaskStatus.State.COMPLETE && status.getResult().isSuccessful()) {
            LogUtil.status(logContext, "Action executed successfully.");
            AnaplanDeleteOperation.setRunStatusDetails(AnaplanDeleteOperation.collectTaskLogs(status));
            return MulesoftAnaplanResponse.executeActionSuccess(status.getTaskState().name(), logContext);
        }
        return MulesoftAnaplanResponse.executeActionFailure("Execute Action Failed", null, logContext);
    }

    public String runDeleteAction(String workspaceId, String modelId, String deleteActionId) throws AnaplanOperationException {
        String logContext = this.apiConn.getLogContext();
        String exportLogContext = logContext + " [" + deleteActionId + "]";
        LogUtil.status(logContext, "<< Starting Delete-Action >>");
        LogUtil.status(logContext, "Workspace-ID: " + workspaceId);
        LogUtil.status(logContext, "Model-ID: " + modelId);
        LogUtil.status(logContext, "Delete Action ID: " + deleteActionId);
        this.validateInput(workspaceId, modelId);
        try {
            MulesoftAnaplanResponse anaplanResponse = AnaplanDeleteOperation.runDeleteAction(this.model, deleteActionId, exportLogContext);
            LogUtil.status(logContext, "Action complete: Status: " + (Object)((Object)anaplanResponse.getStatus()) + ", Response message: " + anaplanResponse.getResponseMessage());
        }
        catch (AnaplanAPIException e) {
            throw new AnaplanOperationException(e.getMessage(), e);
        }
        finally {
            this.apiConn.closeConnection();
        }
        String statusMsg = "[" + deleteActionId + "] completed successfully!";
        LogUtil.status(exportLogContext, statusMsg);
        return statusMsg + "\n\n" + AnaplanDeleteOperation.getRunStatusDetails();
    }
}

