/*
 * Decompiled with CFR 0.152.
 */
package com.anaplan.connector.connection;

import com.anaplan.client.AnaplanAPIException;
import com.anaplan.client.Credentials;
import com.anaplan.client.Service;
import com.anaplan.connector.AnaplanConnectorProperties;
import com.anaplan.connector.exceptions.AnaplanConnectionException;
import com.anaplan.connector.exceptions.ConnectorPropertiesException;
import com.anaplan.connector.utils.LogUtil;
import com.anaplan.connector.utils.UserMessages;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.List;

public class AnaplanConnection {
    private static final String USERNAME_FIELD = "username";
    private static final String PASSWORD_FIELD = "password";
    private static final String URL_FIELD = "url";
    private static final String CERT_PATH = "certPath";
    private static final String URL_PROXY = "proxyHost";
    private static final String URL_PROXY_USER = "proxyUser";
    private static final String URL_PROXY_PASS = "proxyPass";
    private final AnaplanConnectorProperties connectionConfig;
    private final boolean isCertificate;
    private Service openConnection = null;

    public AnaplanConnection(boolean isCertificate, String ... credentials) {
        LogUtil.debug("NOTICE: ", credentials[0] + " @ " + credentials[2]);
        this.isCertificate = isCertificate;
        this.connectionConfig = new AnaplanConnectorProperties();
        try {
            if (isCertificate) {
                this.connectionConfig.setProperties(credentials, CERT_PATH, URL_FIELD, URL_PROXY, URL_PROXY_USER, URL_PROXY_PASS);
            } else {
                this.connectionConfig.setProperties(credentials, USERNAME_FIELD, PASSWORD_FIELD, URL_FIELD, URL_PROXY, URL_PROXY_USER, URL_PROXY_PASS);
            }
        }
        catch (ConnectorPropertiesException e) {
            LogUtil.error(this.getLogContext(), "Could not set connector properties!" + e.getStackTrace().toString());
        }
        LogUtil.status(this.getLogContext(), "Stored connection properties!");
    }

    public String getConnectionId() {
        return this.toString();
    }

    public X509Certificate readCertificate(String certificateLocation) throws AnaplanConnectionException {
        BufferedInputStream buffStream = null;
        X509Certificate x509 = null;
        try {
            buffStream = new BufferedInputStream(new FileInputStream(certificateLocation));
            Certificate cert = CertificateFactory.getInstance("X.509").generateCertificate(buffStream);
            if (cert instanceof X509Certificate) {
                x509 = (X509Certificate)cert;
                LogUtil.status(this.getLogContext(), "Certificate VALID!");
                LogUtil.debug(this.getLogContext(), x509.toString());
            }
        }
        catch (CertificateException e) {
            throw new AnaplanConnectionException("Bad certificate: " + e.getMessage());
        }
        catch (IOException e) {
            throw new AnaplanConnectionException("Could not open certificate: " + e.getMessage());
        }
        catch (Throwable e) {
            throw new AnaplanConnectionException("Unknown exception occured: " + e.getMessage());
        }
        finally {
            if (buffStream != null) {
                try {
                    buffStream.close();
                }
                catch (IOException e) {
                    throw new AnaplanConnectionException(e.getMessage());
                }
            }
        }
        return x509;
    }

    private Service cacheService() throws AnaplanConnectionException {
        List availableWorkspaces;
        Service service;
        block11: {
            LogUtil.debug(this.getLogContext(), "trying Anaplan service connection...");
            String apiUrl = this.connectionConfig.getStringProperty(URL_FIELD);
            service = null;
            LogUtil.warning(this.getLogContext(), "API Url: " + apiUrl);
            try {
                service = new Service(new URI(apiUrl));
            }
            catch (URISyntaxException e) {
                this.closeConnection();
                String msg = UserMessages.getMessage("invalidApiUri", apiUrl);
                LogUtil.error(this.getLogContext(), msg, e);
                throw new AnaplanConnectionException(msg, e);
            }
            String username = this.connectionConfig.getStringProperty(USERNAME_FIELD);
            String password = this.connectionConfig.getStringProperty(PASSWORD_FIELD);
            String certLocation = this.connectionConfig.getStringProperty(CERT_PATH);
            String proxyHost = this.connectionConfig.getStringProperty(URL_PROXY);
            String proxyUser = this.connectionConfig.getStringProperty(URL_PROXY_USER);
            String proxyPass = this.connectionConfig.getStringProperty(URL_PROXY_PASS);
            Credentials creds = null;
            try {
                creds = this.isCertificate ? new Credentials(this.readCertificate(certLocation)) : new Credentials(username, password, null, null);
                service.setServiceCredentials(creds);
                if (proxyHost != null && !proxyHost.isEmpty()) {
                    service.setProxyLocation(new URI(proxyHost));
                    if (proxyUser != null && !proxyUser.isEmpty()) {
                        service.setProxyCredentials(new Credentials(proxyUser, proxyPass, null, null));
                        LogUtil.debug(this.getLogContext(), "Proxy server configured");
                    }
                }
            }
            catch (AnaplanAPIException e) {
                this.closeConnection();
                String msg = UserMessages.getMessage("apiConnectFail", e.getMessage());
                LogUtil.error(this.getLogContext(), msg, e);
                throw new AnaplanConnectionException(msg, e);
            }
            catch (URISyntaxException e) {
                this.closeConnection();
                String msg = UserMessages.getMessage("apiConnectFail", e.getMessage());
                LogUtil.error(this.getLogContext(), msg, e);
                throw new AnaplanConnectionException(msg, e);
            }
            LogUtil.debug(this.getLogContext(), "Anaplan service connection information cached");
            availableWorkspaces = null;
            try {
                availableWorkspaces = service.getWorkspaces();
            }
            catch (AnaplanAPIException e) {
                this.closeConnection();
                LogUtil.error(this.getLogContext(), e.getMessage(), e);
                if (e.getMessage() != null && e.getMessage().toLowerCase().contains("credentials")) break block11;
                String exceptionDetails = e.getMessage();
                if (e.getCause() != null && e.getCause().getMessage() != null) {
                    exceptionDetails = exceptionDetails + " (" + e.getCause().getMessage() + ")";
                }
                throw new AnaplanConnectionException(exceptionDetails, e);
            }
        }
        if (availableWorkspaces == null || availableWorkspaces.isEmpty()) {
            String msg = UserMessages.getMessage("accessFail");
            LogUtil.error(this.getLogContext(), msg + " (availableWorkspaces=" + availableWorkspaces + ")");
            throw new AnaplanConnectionException(msg);
        }
        LogUtil.debug(this.getLogContext(), "Anaplan service connection validated successfully");
        this.openConnection = service;
        return service;
    }

    public Service openConnection() throws AnaplanConnectionException {
        LogUtil.status(this.getLogContext(), "Establishing connection....");
        if (this.openConnection == null) {
            LogUtil.status(this.getLogContext(), "No new connection found, establishing new connection!");
            return this.cacheService();
        }
        LogUtil.status(this.getLogContext(), "Connection exists, returning cached connection!");
        return this.openConnection;
    }

    public Service getConnection() {
        return this.openConnection;
    }

    public void closeConnection() {
        if (this.openConnection != null) {
            this.openConnection.close();
        }
        this.openConnection = null;
        LogUtil.status(this.getLogContext(), "Connection closed.");
    }

    public String getLogContext() {
        String apiUrl = this.connectionConfig.getStringProperty(URL_FIELD);
        String username = this.connectionConfig.getStringProperty(USERNAME_FIELD);
        return this.wrap(apiUrl) + " " + this.wrap(username);
    }

    private String wrap(String s) {
        return "[" + s + "]";
    }
}

