/*
 * Decompiled with CFR 0.152.
 */
package com.anaplan.connector.config;

import com.anaplan.connector.config.AnaplanConnectorBasicAuthConnectionStrategyConfigDefinitionParser;
import com.anaplan.connector.config.AnaplanConnectorCertAuthConnectionStrategyConfigDefinitionParser;
import com.anaplan.connector.config.DeleteFromModelDefinitionParser;
import com.anaplan.connector.config.ExportFromModelDefinitionParser;
import com.anaplan.connector.config.ImportToModelDefinitionParser;
import com.anaplan.connector.config.RunProcessDefinitionParser;
import org.mule.config.MuleManifest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.NamespaceHandlerSupport;

public class AnaplanNamespaceHandler
extends NamespaceHandlerSupport {
    private static Logger logger = LoggerFactory.getLogger(AnaplanNamespaceHandler.class);

    private void handleException(String beanName, String beanScope, NoClassDefFoundError noClassDefFoundError) {
        String muleVersion = "";
        try {
            muleVersion = MuleManifest.getProductVersion();
        }
        catch (Exception _x) {
            logger.error("Problem while reading mule version");
        }
        logger.error("Cannot launch the mule app, the  " + beanScope + " [" + beanName + "] within the connector [anaplan] is not supported in mule " + muleVersion);
        throw new FatalBeanException("Cannot launch the mule app, the  " + beanScope + " [" + beanName + "] within the connector [anaplan] is not supported in mule " + muleVersion, (Throwable)noClassDefFoundError);
    }

    public void init() {
        try {
            this.registerBeanDefinitionParser("basic-auth-connection", (BeanDefinitionParser)new AnaplanConnectorBasicAuthConnectionStrategyConfigDefinitionParser());
        }
        catch (NoClassDefFoundError ex) {
            this.handleException("basic-auth-connection", "@Config", ex);
        }
        try {
            this.registerBeanDefinitionParser("cert-auth-connection", (BeanDefinitionParser)new AnaplanConnectorCertAuthConnectionStrategyConfigDefinitionParser());
        }
        catch (NoClassDefFoundError ex) {
            this.handleException("cert-auth-connection", "@Config", ex);
        }
        try {
            this.registerBeanDefinitionParser("import-to-model", (BeanDefinitionParser)new ImportToModelDefinitionParser());
        }
        catch (NoClassDefFoundError ex) {
            this.handleException("import-to-model", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("export-from-model", (BeanDefinitionParser)new ExportFromModelDefinitionParser());
        }
        catch (NoClassDefFoundError ex) {
            this.handleException("export-from-model", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("delete-from-model", (BeanDefinitionParser)new DeleteFromModelDefinitionParser());
        }
        catch (NoClassDefFoundError ex) {
            this.handleException("delete-from-model", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("run-process", (BeanDefinitionParser)new RunProcessDefinitionParser());
        }
        catch (NoClassDefFoundError ex) {
            this.handleException("run-process", "@Processor", ex);
        }
    }
}

