/*
 * Decompiled with CFR 0.152.
 */
package com.anaplan.client.transport;

import com.anaplan.client.transport.TransportProviderBase;
import java.net.URI;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public abstract class HttpProvider
extends TransportProviderBase {
    protected final int DEFAULT_HTTP_PORT = 80;
    protected final int DEFAULT_HTTPS_PORT = 443;
    protected static final String MSG_NO_CONTENT = "noContent";
    protected static final String MSG_COMMS_FAILURE = "communicationFailure";
    protected static final String MSG_CODE_PREFIX = "code.";
    protected static final String MSG_CODE_OTHER = "code.other";
    private ResourceBundle messages = ResourceBundle.getBundle(HttpProvider.class.getName(), Locale.getDefault());

    protected HttpProvider() {
    }

    protected int getPort(URI uRI) {
        String string = uRI.getScheme();
        int n = uRI.getPort();
        if (n == -1) {
            if ("http".equalsIgnoreCase(string)) {
                n = 80;
            } else if ("https".equalsIgnoreCase(string)) {
                n = 443;
            }
        }
        return n;
    }

    protected String getMessage(String string, Object ... objectArray) {
        try {
            String string2 = this.messages.getString(string);
            if (objectArray == null || objectArray.length == 0) {
                return string2;
            }
            MessageFormat messageFormat = new MessageFormat(string2);
            return messageFormat.format(objectArray).toString();
        }
        catch (MissingResourceException missingResourceException) {
            StringBuilder stringBuilder = new StringBuilder(string);
            for (int i = 0; i < stringBuilder.length(); ++i) {
                char c = stringBuilder.charAt(i);
                if (!Character.isUpperCase(c)) continue;
                stringBuilder.insert(i++, ' ');
                stringBuilder.setCharAt(i, Character.toLowerCase(c));
            }
            return stringBuilder.toString();
        }
    }

    protected String getStatusMessage(int n, String string) {
        String string2 = MSG_CODE_PREFIX + n;
        if (this.messages.containsKey(string2)) {
            return this.messages.getString(string2);
        }
        return String.format(this.messages.getString(MSG_CODE_OTHER), n, string);
    }
}

