/*
 * Decompiled with CFR 0.152.
 */
package com.anaplan.client.transport;

import com.anaplan.client.Credentials;
import com.anaplan.client.transport.AnaplanAPITransportException;
import com.anaplan.client.transport.HttpProvider;
import com.anaplan.client.transport.JCIFSEngine;
import com.anaplan.client.transport.TransportProvider;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthSchemeFactory;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.NTCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.auth.NTLMScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.ProxySelectorRoutePlanner;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;

public class ApacheHttpProvider
extends HttpProvider
implements TransportProvider {
    private static final String RFC_2617_AUTHORISATION_SCHEME = "AnaplanCertificate";
    private static final String CHARACTER_ENCODING = "UTF-8";
    private static final Logger logger = Logger.getLogger("anaplan-connect.transport");
    private DefaultHttpClient httpClient;
    private HttpHost httpHost;
    private HttpContext httpContext;
    private ProxySelectorRoutePlanner routePlanner;
    private String certificateAuthorizationHeader;

    protected ApacheHttpProvider() {
    }

    private void initialise(Credentials credentials) throws AnaplanAPITransportException {
        block9: {
            this.httpClient = new DefaultHttpClient();
            if (credentials.getScheme() == Credentials.Scheme.USER_CERTIFICATE) {
                try {
                    X509Certificate x509Certificate = credentials.getCertificate();
                    String string = this.extractCommonName(x509Certificate);
                    String string2 = string + ":" + this.convertToPEMFormat(x509Certificate);
                    byte[] byArray = Base64.encodeBase64((byte[])string2.getBytes(CHARACTER_ENCODING));
                    this.certificateAuthorizationHeader = "AnaplanCertificate " + new String(byArray, CHARACTER_ENCODING);
                }
                catch (Throwable throwable) {
                    throw new AnaplanAPITransportException("Could not initialise transport given provided certificate credentials", throwable);
                }
            }
            this.httpClient.getParams().setParameter("http.protocol.handle-authentication", (Object)Boolean.TRUE);
            this.httpClient.setCredentialsProvider((CredentialsProvider)new ApacheCredentialsProvider());
            try {
                final JCIFSEngine jCIFSEngine = new JCIFSEngine();
                this.httpClient.getAuthSchemes().register("ntlm", new AuthSchemeFactory(){

                    public AuthScheme newInstance(HttpParams httpParams) {
                        return new NTLMScheme(jCIFSEngine);
                    }
                });
            }
            catch (InvocationTargetException invocationTargetException) {
                if (this.getDebugLevel() >= 2) {
                    logger.log(Level.INFO, "Not using JCIFS NTLM proxy authentication", invocationTargetException.getCause());
                } else if (this.getDebugLevel() >= 1) {
                    logger.log(Level.INFO, "Not using JCIFS NTLM proxy authentication due to " + invocationTargetException.getCause() + " (add jcifs.jar to lib folder if required)");
                }
            }
            catch (Throwable throwable) {
                if (this.getDebugLevel() < 1) break block9;
                logger.log(Level.WARNING, "Failed to set up JCIFS NTLM proxy authentication", throwable);
            }
        }
        this.routePlanner = new ProxySelectorRoutePlanner(this.httpClient.getConnectionManager().getSchemeRegistry(), this.getProxySelector()){
            private boolean suppressed;

            public HttpRoute determineRoute(HttpHost httpHost, HttpRequest httpRequest, HttpContext httpContext) throws HttpException {
                HttpRoute httpRoute = super.determineRoute(httpHost, httpRequest, httpContext);
                if (ApacheHttpProvider.this.getDebugLevel() >= 1 && !this.suppressed) {
                    logger.info(httpRoute.toString() + " (" + this.getProxySelector().getClass().getSimpleName() + ")");
                    if (ApacheHttpProvider.this.getDebugLevel() == 1) {
                        this.suppressed = true;
                    }
                }
                return httpRoute;
            }
        };
        this.httpClient.setRoutePlanner((HttpRoutePlanner)this.routePlanner);
    }

    @Override
    public String toString() {
        String string = this.getClass().getName();
        return string.substring(string.lastIndexOf(46) + 1);
    }

    @Override
    public void setServiceLocation(URI uRI) throws AnaplanAPITransportException {
        super.setServiceLocation(uRI);
        String string = uRI.getScheme();
        int n = this.getPort(uRI);
        this.httpHost = new HttpHost(uRI.getHost(), n, string);
        this.httpContext = new BasicHttpContext();
        if (this.getServiceCredentials() != null) {
            this.setServiceCredentials(this.getServiceCredentials());
        }
    }

    @Override
    public void setServiceCredentials(Credentials credentials) throws AnaplanAPITransportException {
        super.setServiceCredentials(credentials);
        this.initialise(credentials);
        if (credentials.getScheme() != Credentials.Scheme.USER_CERTIFICATE && this.getServiceLocation() != null) {
            BasicAuthCache basicAuthCache = new BasicAuthCache();
            BasicScheme basicScheme = new BasicScheme();
            basicAuthCache.put(this.httpHost, (AuthScheme)basicScheme);
            this.httpContext.setAttribute("http.auth.auth-cache", (Object)basicAuthCache);
        }
    }

    @Override
    public void setProxyLocation(URI uRI) throws AnaplanAPITransportException {
        super.setProxyLocation(uRI);
        this.routePlanner.setProxySelector(this.getProxySelector());
    }

    @Override
    public void setUserAgent(String string) {
        super.setUserAgent(string);
        HttpProtocolParams.setUserAgent((HttpParams)this.httpClient.getParams(), (String)string);
    }

    @Override
    public byte[] get(String string, String string2) throws AnaplanAPITransportException {
        try {
            HttpGet httpGet = new HttpGet(this.getRequestPath(string));
            if (string2 != null) {
                httpGet.setHeader("Accept", string2);
            }
            this.addHeaders((HttpRequestBase)httpGet);
            if (this.getDebugLevel() >= 1) {
                logger.info(httpGet.getRequestLine().toString());
            }
            HttpResponse httpResponse = this.httpClient.execute(this.httpHost, (HttpRequest)httpGet, this.httpContext);
            this.checkResponse(httpResponse);
            HttpEntity httpEntity = httpResponse.getEntity();
            if (httpEntity != null) {
                return this.readResponseBody(httpEntity.getContent());
            }
            throw new AnaplanAPITransportException(this.getMessage("noContent", new Object[0]), null);
        }
        catch (IOException iOException) {
            throw this.createTransportException(iOException);
        }
    }

    @Override
    public boolean head(String string) throws AnaplanAPITransportException {
        try {
            HttpHead httpHead = new HttpHead(this.getRequestPath(string));
            if (this.getDebugLevel() >= 1) {
                logger.info(httpHead.getRequestLine().toString());
            }
            this.addHeaders((HttpRequestBase)httpHead);
            HttpResponse httpResponse = this.httpClient.execute(this.httpHost, (HttpRequest)httpHead, this.httpContext);
            HttpEntity httpEntity = httpResponse.getEntity();
            int n = httpResponse.getStatusLine().getStatusCode();
            if (200 <= n && n <= 299) {
                if (httpEntity != null) {
                    EntityUtils.consume((HttpEntity)httpEntity);
                }
                return true;
            }
            if (n == 404) {
                if (httpEntity != null) {
                    EntityUtils.consume((HttpEntity)httpEntity);
                }
                return false;
            }
            this.checkResponse(httpResponse);
            return false;
        }
        catch (IOException iOException) {
            throw this.createTransportException(iOException);
        }
    }

    @Override
    public byte[] post(String string, byte[] byArray, String string2, String string3) throws AnaplanAPITransportException {
        try {
            HttpPost httpPost = new HttpPost(this.getRequestPath(string));
            if (string2 != null) {
                httpPost.setHeader("Content-Type", string2);
            }
            if (string3 != null) {
                httpPost.setHeader("Accept", string3);
            }
            this.addHeaders((HttpRequestBase)httpPost);
            if (this.getDebugLevel() >= 1) {
                logger.info(httpPost.getRequestLine().toString());
            }
            httpPost.setEntity((HttpEntity)new ByteArrayEntity(byArray));
            HttpResponse httpResponse = this.httpClient.execute(this.httpHost, (HttpRequest)httpPost, this.httpContext);
            this.checkResponse(httpResponse);
            HttpEntity httpEntity = httpResponse.getEntity();
            if (httpEntity != null) {
                return this.readResponseBody(httpEntity.getContent());
            }
            return null;
        }
        catch (IOException iOException) {
            throw this.createTransportException(iOException);
        }
    }

    @Override
    public byte[] put(String string, byte[] byArray, String string2) throws AnaplanAPITransportException {
        try {
            HttpPut httpPut = new HttpPut(this.getRequestPath(string));
            if (string2 == null) {
                string2 = "application/octet-stream";
            }
            if (string2.equals("application/octet-stream")) {
                string2 = "application/x-gzip";
                byArray = this.compress(byArray, 0, byArray.length);
            }
            httpPut.setHeader("Content-Type", string2);
            this.addHeaders((HttpRequestBase)httpPut);
            if (this.getDebugLevel() >= 1) {
                logger.info(httpPut.getRequestLine().toString());
            }
            httpPut.setEntity((HttpEntity)new ByteArrayEntity(byArray));
            HttpResponse httpResponse = this.httpClient.execute(this.httpHost, (HttpRequest)httpPut, this.httpContext);
            this.checkResponse(httpResponse);
            HttpEntity httpEntity = httpResponse.getEntity();
            if (httpEntity != null) {
                return this.readResponseBody(httpEntity.getContent());
            }
            return null;
        }
        catch (IOException iOException) {
            throw this.createTransportException(iOException);
        }
    }

    @Override
    public byte[] delete(String string, String string2) throws AnaplanAPITransportException {
        try {
            HttpDelete httpDelete = new HttpDelete(this.getRequestPath(string));
            if (string2 != null) {
                httpDelete.setHeader("Accept", string2);
            }
            this.addHeaders((HttpRequestBase)httpDelete);
            if (this.getDebugLevel() >= 1) {
                logger.info(httpDelete.getRequestLine().toString());
            }
            HttpResponse httpResponse = this.httpClient.execute(this.httpHost, (HttpRequest)httpDelete, this.httpContext);
            this.checkResponse(httpResponse);
            HttpEntity httpEntity = httpResponse.getEntity();
            if (httpEntity != null) {
                return this.readResponseBody(httpEntity.getContent());
            }
            throw new AnaplanAPITransportException(this.getMessage("noContent", new Object[0]), null);
        }
        catch (IOException iOException) {
            throw this.createTransportException(iOException);
        }
    }

    @Override
    public void close() {
        if (this.httpClient != null) {
            this.httpClient.getConnectionManager().shutdown();
        }
    }

    protected void checkResponse(HttpResponse httpResponse) throws AnaplanAPITransportException {
        int n = httpResponse.getStatusLine().getStatusCode();
        if (this.getDebugLevel() >= 1) {
            logger.info(httpResponse.getStatusLine().toString());
        }
        if (200 > n || n > 299) {
            block7: {
                HttpEntity httpEntity = httpResponse.getEntity();
                if (httpEntity != null) {
                    try {
                        Header header = httpEntity.getContentType();
                        String string = EntityUtils.toString((HttpEntity)httpEntity);
                        if (this.getDebugLevel() >= 2) {
                            logger.info(String.valueOf(header));
                            logger.info(string);
                        }
                        if (!string.isEmpty() && header != null && header.getValue().startsWith("text/plain")) {
                            throw new AnaplanAPITransportException(string);
                        }
                    }
                    catch (IOException iOException) {
                        if (this.getDebugLevel() < 1) break block7;
                        logger.log(Level.WARNING, "I/O exception whilst reading response", iOException);
                    }
                }
            }
            throw new AnaplanAPITransportException(this.getStatusMessage(n, httpResponse.getStatusLine().getReasonPhrase()));
        }
    }

    private AnaplanAPITransportException createTransportException(IOException iOException) {
        return new AnaplanAPITransportException(this.getMessage("communicationFailure", new Object[0]), iOException);
    }

    private String extractCommonName(X509Certificate x509Certificate) {
        try {
            String string = x509Certificate.getSubjectX500Principal().getName();
            LdapName ldapName = new LdapName(string);
            for (Rdn rdn : ldapName.getRdns()) {
                if (!"CN".equals(rdn.getType())) continue;
                return (String)rdn.getValue();
            }
            throw new RuntimeException("Could not load common name (CN) field from certificate");
        }
        catch (InvalidNameException invalidNameException) {
            throw new RuntimeException("Could not load common name (CN) field from certificate");
        }
    }

    private void addHeaders(HttpRequestBase httpRequestBase) throws AnaplanAPITransportException, IOException {
        if (this.getServiceCredentials().getScheme() == Credentials.Scheme.USER_CERTIFICATE) {
            httpRequestBase.setHeader("Authorization", this.certificateAuthorizationHeader);
        }
    }

    private String convertToPEMFormat(X509Certificate x509Certificate) throws AnaplanAPITransportException, IOException {
        try {
            return "-----BEGIN CERTIFICATE-----\n" + new String(Base64.encodeBase64((byte[])x509Certificate.getEncoded()), "US-ASCII") + "\n-----END CERTIFICATE-----";
        }
        catch (CertificateEncodingException certificateEncodingException) {
            throw new AnaplanAPITransportException("Failed to encode user certificate", certificateEncodingException);
        }
    }

    public class ApacheCredentialsProvider
    implements CredentialsProvider {
        public void clear() {
        }

        public org.apache.http.auth.Credentials getCredentials(AuthScope authScope) {
            try {
                InetAddress inetAddress = InetAddress.getByName(authScope.getHost());
                InetAddress inetAddress2 = InetAddress.getByName(ApacheHttpProvider.this.httpHost.getHostName());
                URI uRI = ApacheHttpProvider.this.getProxyLocation();
                if (inetAddress2.equals(inetAddress) && (authScope.getPort() == -1 || authScope.getPort() == ApacheHttpProvider.this.httpHost.getPort())) {
                    Credentials credentials = ApacheHttpProvider.this.getServiceCredentials();
                    if (credentials == null) {
                        return null;
                    }
                    return new UsernamePasswordCredentials(credentials.getUserName(), credentials.getPassphrase());
                }
                if (uRI != null) {
                    InetAddress inetAddress3 = InetAddress.getByName(uRI.getHost());
                    int n = ApacheHttpProvider.this.getPort(uRI);
                    if (inetAddress3.equals(inetAddress) && (authScope.getPort() == -1 || authScope.getPort() == n)) {
                        Credentials credentials = ApacheHttpProvider.this.getProxyCredentials();
                        if (credentials == null) {
                            return null;
                        }
                        if ("ntlm".equalsIgnoreCase(authScope.getScheme())) {
                            return new NTCredentials(credentials.getUserName(), credentials.getPassphrase(), credentials.getWorkstation(), credentials.getDomain());
                        }
                        return new UsernamePasswordCredentials(credentials.getUserName(), credentials.getPassphrase());
                    }
                }
            }
            catch (UnknownHostException unknownHostException) {
                if (ApacheHttpProvider.this.getDebugLevel() >= 1) {
                    logger.log(Level.WARNING, "Failed to resolve hostname for authentication", unknownHostException);
                }
                throw new IllegalArgumentException(unknownHostException.getMessage());
            }
            return null;
        }

        public void setCredentials(AuthScope authScope, org.apache.http.auth.Credentials credentials) {
        }
    }
}

