/*
 * Decompiled with CFR 0.152.
 */
package com.anaplan.client.serialization;

import com.anaplan.client.serialization.AnaplanAPISerializationException;
import com.anaplan.client.serialization.SerializationHandler;
import com.anaplan.client.serialization.TypeWrapper;
import com.google.gson.Gson;

public class GsonHandler
implements SerializationHandler {
    private Gson gson = new Gson();

    public String toString() {
        String string = this.getClass().getName();
        return string.substring(string.lastIndexOf(46) + 1);
    }

    @Override
    public String getContentType() {
        return "application/json";
    }

    @Override
    public <T> byte[] serialize(T t, TypeWrapper<T> typeWrapper) throws AnaplanAPISerializationException {
        try {
            String string = this.gson.toJson(t, typeWrapper.getType());
            return string.getBytes("UTF-8");
        }
        catch (Throwable throwable) {
            throw new AnaplanAPISerializationException("Failed to serialize API request parameters using GSON", throwable);
        }
    }

    @Override
    public <T> T deserialize(byte[] byArray, TypeWrapper<T> typeWrapper) throws AnaplanAPISerializationException {
        try {
            String string = new String(byArray, "UTF-8");
            return (T)this.gson.fromJson(string, typeWrapper.getType());
        }
        catch (Throwable throwable) {
            throw new AnaplanAPISerializationException("Failed to deserialize API response result using GSON", throwable);
        }
    }
}

