/*
 * Decompiled with CFR 0.152.
 */
package com.anaplan.client;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class TaskResultDetail {
    private Data data;
    private Map<String, String> values;

    TaskResultDetail(Data data) {
        this.data = data;
    }

    public String toString() {
        try {
            return this.appendTo(new StringBuilder()).toString();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public Appendable appendTo(Appendable appendable) throws IOException {
        appendable.append(this.data.localMessageText);
        if (this.data.occurrences != 0) {
            appendable.append(": ").append(Integer.toString(this.data.occurrences));
        }
        return appendable;
    }

    public String getType() {
        return this.data.type;
    }

    public Map<String, String> getValues() {
        if (this.data.values != null && this.values == null) {
            LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
            Iterator<String> iterator = this.data.values.iterator();
            while (iterator.hasNext()) {
                String string = iterator.next();
                if (!iterator.hasNext()) continue;
                linkedHashMap.put(string, iterator.next());
            }
            this.values = Collections.unmodifiableMap(linkedHashMap);
        }
        return this.values;
    }

    public String getLocalizedMessageText() {
        return this.data.localMessageText;
    }

    public int getOccurrences() {
        return this.data.occurrences;
    }

    static class Data {
        String type;
        List<String> values;
        String localMessageText;
        int occurrences;

        Data() {
        }
    }
}

