/*
 * Decompiled with CFR 0.152.
 */
package com.anaplan.client;

import com.anaplan.client.Action;
import com.anaplan.client.AnaplanAPIException;
import com.anaplan.client.AnaplanApiClientObject;
import com.anaplan.client.Export;
import com.anaplan.client.Import;
import com.anaplan.client.Module;
import com.anaplan.client.Process;
import com.anaplan.client.ServerFile;
import com.anaplan.client.Workspace;
import com.anaplan.client.serialization.TypeWrapper;
import java.util.ArrayList;
import java.util.List;

public class Model
extends AnaplanApiClientObject {
    static final TypeWrapper<List<Data>> DATA_LIST_TYPE = new TypeWrapper<List<Data>>(){};
    private final Workspace workspace;
    private final Data data;

    Model(Workspace workspace, Data data) {
        super(workspace.getService());
        this.workspace = workspace;
        this.data = data;
    }

    final Workspace getWorkspace() {
        return this.workspace;
    }

    @Override
    final String getPath() {
        return this.getWorkspace().getPath() + "/models/" + this.getId();
    }

    public String getId() {
        return this.data.id;
    }

    public String getName() {
        return this.data.name;
    }

    public List<Module> getModules() throws AnaplanAPIException {
        List<Module.Data> list = this.getSerializationHandler().deserialize(this.getTransportProvider().get(this.getPath() + "/modules", this.getSerializationHandler().getContentType()), Module.DATA_LIST_TYPE);
        ArrayList<Module> arrayList = new ArrayList<Module>(list.size());
        for (Module.Data data : list) {
            Module module = new Module(this, data);
            arrayList.add(module);
        }
        return arrayList;
    }

    public Module getModule(String string) throws AnaplanAPIException {
        for (Module module : this.getModules()) {
            if (!string.equals(module.getId()) && !string.equalsIgnoreCase(module.getCode()) && !string.equalsIgnoreCase(module.getName())) continue;
            return module;
        }
        return null;
    }

    public List<ServerFile> getServerFiles() throws AnaplanAPIException {
        List<ServerFile.Data> list = this.getSerializationHandler().deserialize(this.getTransportProvider().get(this.getPath() + "/files", this.getSerializationHandler().getContentType()), ServerFile.DATA_LIST_TYPE);
        ArrayList<ServerFile> arrayList = new ArrayList<ServerFile>(list.size());
        for (ServerFile.Data data : list) {
            ServerFile serverFile = new ServerFile(this, data);
            arrayList.add(serverFile);
        }
        return arrayList;
    }

    public ServerFile getServerFile(String string) throws AnaplanAPIException {
        for (ServerFile serverFile : this.getServerFiles()) {
            if (!string.equals(serverFile.getId()) && !string.equalsIgnoreCase(serverFile.getCode()) && !string.equalsIgnoreCase(serverFile.getName())) continue;
            return serverFile;
        }
        return null;
    }

    public ServerFile createServerFileImportDataSource(String string, String string2) throws AnaplanAPIException {
        ServerFile.Data data = new ServerFile.Data();
        data.name = string;
        data.chunkCount = -1;
        data.origin = string2;
        byte[] byArray = this.getSerializationHandler().serialize(data, ServerFile.DATA_TYPE);
        String string3 = this.getSerializationHandler().getContentType();
        byArray = this.getTransportProvider().post(this.getPath() + "/files/" + string, byArray, string3, string3);
        if (byArray != null) {
            data = this.getSerializationHandler().deserialize(byArray, ServerFile.DATA_TYPE);
        }
        ServerFile serverFile = new ServerFile(this, data);
        return serverFile;
    }

    public List<Import> getImports() throws AnaplanAPIException {
        List<Import.Data> list = this.getSerializationHandler().deserialize(this.getTransportProvider().get(this.getPath() + "/imports", this.getSerializationHandler().getContentType()), Import.DATA_LIST_TYPE);
        ArrayList<Import> arrayList = new ArrayList<Import>(list.size());
        for (Import.Data data : list) {
            arrayList.add(new Import(this, data));
        }
        return arrayList;
    }

    public Import getImport(String string) throws AnaplanAPIException {
        for (Import import_ : this.getImports()) {
            if (!string.equals(import_.getId()) && !string.equalsIgnoreCase(import_.getCode()) && !string.equalsIgnoreCase(import_.getName())) continue;
            return import_;
        }
        return null;
    }

    public List<Export> getExports() throws AnaplanAPIException {
        List<Export.Data> list = this.getSerializationHandler().deserialize(this.getTransportProvider().get(this.getPath() + "/exports", this.getSerializationHandler().getContentType()), Export.DATA_LIST_TYPE);
        ArrayList<Export> arrayList = new ArrayList<Export>(list.size());
        for (Export.Data data : list) {
            arrayList.add(new Export(this, data));
        }
        return arrayList;
    }

    public Export getExport(String string) throws AnaplanAPIException {
        for (Export export : this.getExports()) {
            if (!string.equals(export.getId()) && !string.equalsIgnoreCase(export.getCode()) && !string.equalsIgnoreCase(export.getName())) continue;
            return export;
        }
        return null;
    }

    public List<Action> getActions() throws AnaplanAPIException {
        List<Action.Data> list = this.getSerializationHandler().deserialize(this.getTransportProvider().get(this.getPath() + "/actions", this.getSerializationHandler().getContentType()), Action.DATA_LIST_TYPE);
        ArrayList<Action> arrayList = new ArrayList<Action>(list.size());
        for (Action.Data data : list) {
            arrayList.add(new Action(this, data));
        }
        return arrayList;
    }

    public Action getAction(String string) throws AnaplanAPIException {
        for (Action action : this.getActions()) {
            if (!string.equals(action.getId()) && !string.equalsIgnoreCase(action.getCode()) && !string.equalsIgnoreCase(action.getName())) continue;
            return action;
        }
        return null;
    }

    public List<Process> getProcesses() throws AnaplanAPIException {
        List<Process.Data> list = this.getSerializationHandler().deserialize(this.getTransportProvider().get(this.getPath() + "/processes", this.getSerializationHandler().getContentType()), Process.DATA_LIST_TYPE);
        ArrayList<Process> arrayList = new ArrayList<Process>(list.size());
        for (Process.Data data : list) {
            arrayList.add(new Process(this, data));
        }
        return arrayList;
    }

    public Process getProcess(String string) throws AnaplanAPIException {
        for (Process process : this.getProcesses()) {
            if (!string.equals(process.getId()) && !string.equalsIgnoreCase(process.getCode()) && !string.equalsIgnoreCase(process.getName())) continue;
            return process;
        }
        return null;
    }

    public byte[] doRefresh(byte[] byArray) throws AnaplanAPIException {
        String string = this.getSerializationHandler().getContentType();
        byte[] byArray2 = this.getTransportProvider().post(this.getPath() + "/refresh", byArray, string, string);
        return byArray2;
    }

    static final class Data {
        String id;
        String name;

        Data() {
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof Data)) {
                return false;
            }
            Data data = (Data)object;
            return this.id.equals(data.id) && this.name.equals(data.name);
        }

        public int hashCode() {
            return this.id.hashCode() * 31 + this.name.hashCode();
        }
    }
}

