/*
 * Decompiled with CFR 0.152.
 */
package com.anaplan.client;

import com.anaplan.client.AnaplanAPIException;
import com.anaplan.client.Model;
import com.anaplan.client.NamedObject;
import com.anaplan.client.TaskFactory;
import com.anaplan.client.serialization.TypeWrapper;
import java.util.List;

public class Import
extends TaskFactory {
    static final TypeWrapper<Data> DATA_TYPE = new TypeWrapper<Data>(){};
    static final TypeWrapper<List<Data>> DATA_LIST_TYPE = new TypeWrapper<List<Data>>(){};
    private Data data;

    Import(Model model, Data data) {
        super(model, data);
        this.data = data;
    }

    @Override
    String getPath() {
        return this.getModel().getPath() + "/imports/" + this.getId();
    }

    public String getSourceFileId() throws AnaplanAPIException {
        return this.data.importDataSourceId;
    }

    public ImportType getImportType() {
        try {
            return ImportType.valueOf(this.data.importType);
        }
        catch (Exception exception) {
            return null;
        }
    }

    static class Data
    extends NamedObject.Data {
        String importType;
        String importDataSourceId;

        Data() {
        }
    }

    public static enum ImportType {
        HIERARCHY_DATA("List data"),
        MODULE_DATA("Module data"),
        LINE_ITEM_DEFINITION("Module blueprint"),
        USERS("Users"),
        VERSIONS("Versions");

        private String description;

        private ImportType(String string2) {
            this.description = string2;
        }

        public String toString() {
            return this.description;
        }
    }
}

