package org.mule.module.xmlsecurity.validator;

import org.w3c.dom.Document;

import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dsig.XMLSignatureException;

/**
 * <p>Interface to validate a signature</p>
 *
 * @author fernando.federico@mulesource.com
 */
public interface SignatureValidator {

    /**
     * Validates a xml document
     * @param doc The document that needs to be validated
     * @return true/false if it is valid
     * @throws MarshalException
     * @throws XMLSignatureException
     */
    public boolean validate(Document doc) throws MarshalException, XMLSignatureException;
}
