package org.mule.module.xmlsecurity.validator;

import org.mule.module.xmlsecurity.Signer;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

import javax.xml.crypto.KeySelector;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.crypto.dsig.dom.DOMValidateContext;

/**
 * <p>Default validator, uses a key selector to determine which key was used</p>
 *
 * @author fernando.federico@mulesource.com
 */
public class DefaultSignatureValidator implements SignatureValidator{

    private KeySelector keySelector;

    /**
     * Constructor
     *
     * @param keySelector The key selector used to define the key type
     */
    public DefaultSignatureValidator(KeySelector keySelector) {
        this.keySelector = keySelector;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public boolean validate(Document doc) throws MarshalException, XMLSignatureException {
        NodeList nl =
                doc.getElementsByTagNameNS(XMLSignature.XMLNS, "Signature");
        if (nl.getLength() == 0) {
            throw new RuntimeException("Cannot find Signature element");
        }

        DOMValidateContext valContext = new DOMValidateContext
                (keySelector, nl.item(0));

        XMLSignature signature = Signer.fac.unmarshalXMLSignature(valContext);
        return signature.validate(valContext);
    }
}
