package org.mule.module.xmlsecurity.reference;

import org.mule.module.xmlsecurity.algorithms.DigestMethodAlgorithm;

import javax.xml.crypto.dsig.Reference;

import java.util.List;

import static org.mule.module.xmlsecurity.Signer.fac;

/**
 * <p>Factory of a Detached Reference</p>
 *
 * @author fernando.federico@mulesource.com
 */
public class DetachedReferenceProvider implements ReferenceProvider {

    private DigestMethodAlgorithm digestMethodAlgorithm;
    private String referenceUri;

    /**
     * Constructor
     *
     * @param digestMethodAlgorithm The digest method algorithm
     * @param referenceUri The URI to the referenced object
     */
    public DetachedReferenceProvider(DigestMethodAlgorithm digestMethodAlgorithm, String referenceUri) {
        this.digestMethodAlgorithm = digestMethodAlgorithm;
        this.referenceUri = referenceUri;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public Reference getReference() {
        try
        {
            return fac.newReference(referenceUri,
                    fac.newDigestMethod(digestMethodAlgorithm.getAlgorithm(), null));
        }
        catch (Exception e)
        {
            throw new RuntimeException("Could not getReference Detached Reference",e);
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public List<Object> getReferencedObjects() {
        return null;
    }
}
