package org.mule.module.xmlsecurity.keyinfo;

import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import java.security.Key;

/**
 * Provider of the Key Information needed to sign the document
 *
 * @author fernando.federico@mulesource.com
 */
public interface KeyInfoProvider {

    /**
     * @return The Key Info Object used to create the Key Info Tag.
     */
    KeyInfo getKeyInfo();

    /**
     * @return The private key of the public-private key pair.
     */
    Key getSecretKey();

    /**
     * Creates the SignedInfo object that will be used to create the SignedInfo tag.
     *
     * @param ref The referenced object.
     * @return The Signed info.
     */
    SignedInfo getSignedInfo(Reference ref);
}
