package org.mule.module.xmlsecurity.algorithms;

import javax.xml.crypto.dsig.DigestMethod;

/**
 * <p>Enumeration of the Digest Algorithms </p>
 * <p>For a definition of Digest Methods
 * see  <a href="http://www.w3.org/TR/2009/WD-xmlsec-algorithms-20090226/#digest-method-uris">Digest Method Algorithm</a></p>
 *
 * @author fernando.federico@mulesource.com
 */
public enum DigestMethodAlgorithm {

    /**
     * <a href="http://www.w3.org/TR/2002/REC-xmlenc-core-20021210/#sec-RIPEMD-160">RIPEMD160</a>
     */
    RIPEMD160(DigestMethod.RIPEMD160),
    /**
     * <a href="http://www.w3.org/TR/2008/REC-xmldsig-core-20080610/#sec-SHA-1">SHA1</a>
     */
    SHA1(DigestMethod.SHA1),
    /**
     * <a href="http://www.w3.org/TR/2002/REC-xmlenc-core-20021210/#sec-SHA256">SHA256</a>
     */
    SHA256(DigestMethod.SHA256),
    /**
     * <a href="http://www.w3.org/TR/2002/REC-xmlenc-core-20021210/#sec-SHA512">SHA512</a>
     */
    SHA512(DigestMethod.SHA512);

    private final String algorithm;

    DigestMethodAlgorithm(String algorithm)
    {
        this.algorithm = algorithm;
    }

    /**
     * Used to get the string uri for the Digest algorithm
     *
     * @return The Digest algorithm
     */
    public String getAlgorithm() {
        return algorithm;
    }
}
