/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extensions.java.api.exception;

import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.mule.extensions.java.api.error.JavaModuleError;
import org.mule.extensions.java.api.exception.JavaModuleException;
import org.mule.extensions.java.internal.parameters.ExecutableIdentifier;
import org.mule.extensions.java.internal.parameters.ExecutableIdentifierFactory;
import org.mule.runtime.api.metadata.TypedValue;

public class NoSuchConstructorModuleException
extends JavaModuleException {
    public NoSuchConstructorModuleException(ExecutableIdentifier id, Class<?> targetClass, Map<String, TypedValue<Object>> args) {
        super(NoSuchConstructorModuleException.buildMessage(id, targetClass, args), JavaModuleError.NO_SUCH_CONSTRUCTOR);
    }

    private static String buildMessage(ExecutableIdentifier id, Class<?> targetClass, Map<String, TypedValue<Object>> args) {
        List availableConstructors = Arrays.stream(targetClass.getConstructors()).filter(c -> Modifier.isPublic(c.getModifiers())).map(c -> ExecutableIdentifierFactory.create(c).getElementId()).collect(Collectors.toList());
        StringBuilder sb = new StringBuilder().append("No public Constructor").append(id.getExecutableTypeName()).append(" found with signature '").append(id.getElementId()).append("' for Class '").append(id.getClazz()).append("'.");
        if (availableConstructors.isEmpty()) {
            sb.append("\nNo public Constructors are available.");
        } else {
            sb.append("\nPublic Constructors are ").append(availableConstructors);
        }
        return sb.toString();
    }
}

