/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extensions.java.internal.parameters;

import java.lang.reflect.Executable;
import java.util.Arrays;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public abstract class ExecutableIdentifier {
    private static final String METHOD_MASK = "%s(%s)";
    private static final String ARG_SEPARATOR = ",";
    private static final Pattern METHOD_MATCHER = Pattern.compile("(.+)\\((.*)\\)");

    public abstract String getClazz();

    public abstract String getElementId();

    public String getElementName() {
        Matcher match = METHOD_MATCHER.matcher(this.getElementId().trim().replaceAll(" ", ""));
        return match.matches() ? match.group(1) : "";
    }

    public Optional<String[]> getArgumentTypeNames() {
        Matcher match = METHOD_MATCHER.matcher(this.getElementId().trim().replaceAll(" ", ""));
        if (match.matches()) {
            String[] argumentTypeNames = match.group(2).split(ARG_SEPARATOR);
            if (argumentTypeNames.length == 1 && argumentTypeNames[0].equals("")) {
                return Optional.of(new String[0]);
            }
            return Optional.of(argumentTypeNames);
        }
        return Optional.empty();
    }

    public abstract boolean matches(Executable var1);

    public abstract String getExecutableTypeName();

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExecutableIdentifier)) {
            return false;
        }
        ExecutableIdentifier that = (ExecutableIdentifier)o;
        return this.getClazz().equals(that.getClazz()) && this.sanitize(this.getElementId()).equals(this.sanitize(that.getElementId()));
    }

    public int hashCode() {
        return this.getClazz().hashCode() * 31 + this.sanitize(this.getElementId()).hashCode();
    }

    public String toString() {
        return this.getClazz() + "::" + this.getElementId();
    }

    protected String buildId(String elementName, Class<?>[] argTypes) {
        return String.format(METHOD_MASK, elementName.trim(), Arrays.stream(argTypes).map(Class::getCanonicalName).collect(Collectors.joining(ARG_SEPARATOR)));
    }

    protected boolean matchesArguments(Class[] arguments) {
        Optional<String[]> optionalArgumentTypeNames = this.getArgumentTypeNames();
        if (!optionalArgumentTypeNames.isPresent()) {
            return false;
        }
        String[] argumentTypeNames = optionalArgumentTypeNames.get();
        if (arguments.length != argumentTypeNames.length) {
            return false;
        }
        for (int i = 0; i < arguments.length; ++i) {
            if (argumentTypeNames[i].equals(arguments[i].getSimpleName()) || argumentTypeNames[i].equals(arguments[i].getCanonicalName()) || argumentTypeNames[i].equals(arguments[i].getName())) continue;
            return false;
        }
        return true;
    }

    private String sanitize(String id) {
        return id.trim().replaceAll(" ", "");
    }
}

