/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extensions.java.internal.metadata;

import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.mule.extensions.java.internal.parameters.ExecutableIdentifier;
import org.mule.extensions.java.internal.parameters.ExecutableIdentifierFactory;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.metadata.MetadataContext;
import org.mule.runtime.api.metadata.MetadataKey;
import org.mule.runtime.api.metadata.MetadataKeyBuilder;
import org.mule.runtime.api.metadata.MetadataResolvingException;
import org.mule.runtime.api.metadata.resolving.FailureCode;
import org.mule.runtime.api.metadata.resolving.InputTypeResolver;
import org.mule.runtime.api.metadata.resolving.OutputTypeResolver;
import org.mule.runtime.api.metadata.resolving.TypeKeysResolver;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.api.util.StringUtils;
import org.mule.runtime.extension.api.declaration.type.ExtensionsTypeLoaderFactory;

abstract class ExecutableElementTypeResolver
implements OutputTypeResolver<ExecutableIdentifier>,
InputTypeResolver<ExecutableIdentifier>,
TypeKeysResolver {
    ExecutableElementTypeResolver() {
    }

    public String getCategoryName() {
        return "MethodTypes";
    }

    public String getResolverName() {
        return "MethodTypeResolver";
    }

    protected abstract List<Executable> getExecutableElements(Class<?> var1);

    public MetadataType getInputMetadata(MetadataContext ctx, ExecutableIdentifier key) throws MetadataResolvingException, ConnectionException {
        Executable element = this.findElement(key);
        if (element.getParameters().length == 0) {
            return ctx.getTypeBuilder().nullType().build();
        }
        ObjectTypeBuilder inputParameters = ctx.getTypeBuilder().objectType().id(key.getElementId() + "_INPUT");
        Arrays.stream(element.getParameters()).forEach(param -> inputParameters.addField().key(param.getName()).value(this.getTypeLoader(ctx, (Parameter)param).load(param.getType())));
        return inputParameters.build();
    }

    private ClassTypeLoader getTypeLoader(MetadataContext context, Parameter param) {
        return param.getType().getClassLoader() == null ? context.getTypeLoader() : ExtensionsTypeLoaderFactory.getDefault().createTypeLoader(param.getType().getClassLoader());
    }

    public MetadataType getOutputType(MetadataContext context, ExecutableIdentifier key) throws MetadataResolvingException, ConnectionException {
        Executable element = this.findElement(key);
        Class<?> output = element instanceof Method ? ((Method)element).getGenericReturnType() : this.loadClass(key.getClazz());
        return context.getTypeLoader().load(output);
    }

    public Set<MetadataKey> getKeys(MetadataContext context) throws MetadataResolvingException, ConnectionException {
        return Collections.emptySet();
    }

    private Executable findElement(ExecutableIdentifier key) throws MetadataResolvingException {
        if (StringUtils.isBlank((String)key.getClazz())) {
            throw new MetadataResolvingException("Missing Class name", FailureCode.INVALID_METADATA_KEY);
        }
        if (StringUtils.isBlank((String)key.getElementId())) {
            throw new MetadataResolvingException("Missing Method name", FailureCode.INVALID_METADATA_KEY);
        }
        Class<?> targetClass = this.loadClass(key.getClazz());
        return this.getExecutableElements(targetClass).stream().filter(m -> Modifier.isPublic(m.getModifiers())).filter(m -> this.hasExpectedSignature((Executable)m, key)).findFirst().orElseThrow(() -> new MetadataResolvingException(String.format("No public Method found in Class [%s] with signature [%s]", key.getClazz(), key.getElementId()), FailureCode.INVALID_METADATA_KEY));
    }

    private boolean hasExpectedSignature(Executable m, ExecutableIdentifier key) {
        return key.matches(m);
    }

    protected MetadataKey buildMethodKeys(String clazz) throws MetadataResolvingException {
        if (StringUtils.isBlank((String)clazz)) {
            throw new MetadataResolvingException("Missing Class name. Cannot resolve Methods without a target Class", FailureCode.INVALID_METADATA_KEY);
        }
        Class<?> targetClass = this.loadClass(clazz);
        LinkedList methods = new LinkedList();
        this.getExecutableElements(targetClass).stream().filter(method -> Modifier.isPublic(method.getModifiers())).forEach(method -> methods.add(this.buildOverloadedMethodKey((Executable)method)));
        MetadataKeyBuilder key = MetadataKeyBuilder.newKey((String)clazz).withDisplayName(targetClass.getSimpleName());
        methods.forEach(arg_0 -> ((MetadataKeyBuilder)key).withChild(arg_0));
        return key.build();
    }

    private Class<?> loadClass(String className) throws MetadataResolvingException {
        try {
            return ClassUtils.loadClass((String)className, (ClassLoader)Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new MetadataResolvingException(String.format("Failed to load Class with name [%s]: %s", className, e.getMessage()), FailureCode.INVALID_METADATA_KEY);
        }
    }

    private MetadataKey buildOverloadedMethodKey(Executable method) {
        List argTypes = Arrays.stream(method.getParameters()).map(p -> p.getType().getSimpleName() + " " + p.getName()).collect(Collectors.toList());
        ExecutableIdentifier identifier = ExecutableIdentifierFactory.create(method);
        String displayName = String.format("%s(%s)", identifier.getElementName(), String.join((CharSequence)", ", argTypes));
        return MetadataKeyBuilder.newKey((String)identifier.getElementId()).withDisplayName(displayName).build();
    }
}

