/*
 * Decompiled with CFR 0.152.
 */
package org.mule.ibeans.module.guice;

import com.google.inject.AbstractModule;
import com.google.inject.Key;
import com.google.inject.MembersInjector;
import com.google.inject.TypeLiteral;
import com.google.inject.matcher.Matchers;
import com.google.inject.spi.TypeEncounter;
import com.google.inject.spi.TypeListener;
import java.util.List;
import org.mule.api.MuleContext;
import org.mule.api.annotations.meta.Channel;
import org.mule.ibeans.module.guice.GuiceIBeansAnnotatedObjectProcessor;
import org.mule.module.ibeans.config.IntegrationBeanAnnotatedObjectProcessor;
import org.mule.util.annotation.AnnotationMetaData;
import org.mule.util.annotation.AnnotationUtils;

public class IBeansSupportModule
extends AbstractModule {
    private MuleContext muleContext;

    public IBeansSupportModule(MuleContext muleContext) {
        this.muleContext = muleContext;
    }

    protected void configure() {
        this.bindListener(Matchers.any(), new ServiceIBeansTypeListener());
        this.bindListener(Matchers.any(), new IBeansTypeListener());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class IBeansTypeListener
    implements TypeListener {
        IBeansTypeListener() {
        }

        public <I> void hear(TypeLiteral<I> iTypeLiteral, TypeEncounter<I> iTypeEncounter) {
            iTypeEncounter.register(new MembersInjector<I>(){
                private IntegrationBeanAnnotatedObjectProcessor processor;
                {
                    this.processor = new IntegrationBeanAnnotatedObjectProcessor(IBeansSupportModule.this.muleContext);
                }

                public void injectMembers(I o) {
                    this.processor.process(o);
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ServiceIBeansTypeListener
    implements TypeListener {
        ServiceIBeansTypeListener() {
        }

        public <I> void hear(TypeLiteral<I> iTypeLiteral, TypeEncounter<I> iTypeEncounter) {
            iTypeEncounter.register(new MembersInjector<I>(){

                public void injectMembers(I o) {
                    List annos = AnnotationUtils.getAllMethodAnnotations(o.getClass());
                    if (annos.size() > 0) {
                        for (AnnotationMetaData data : annos) {
                            if (!data.getAnnotation().annotationType().isAnnotationPresent(Channel.class)) continue;
                            GuiceIBeansAnnotatedObjectProcessor processor = new GuiceIBeansAnnotatedObjectProcessor(IBeansSupportModule.this.muleContext, Key.get(o.getClass()));
                            processor.process(o);
                        }
                    }
                }
            });
        }
    }
}

