/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.jaxws;

import com.sun.istack.Nullable;
import com.sun.xml.stream.buffer.XMLStreamBuffer;
import com.sun.xml.stream.buffer.XMLStreamBufferResult;
import com.sun.xml.ws.api.BindingID;
import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.server.InstanceResolver;
import com.sun.xml.ws.api.server.Invoker;
import com.sun.xml.ws.api.server.SDDocumentSource;
import com.sun.xml.ws.api.server.WSEndpoint;
import com.sun.xml.ws.binding.BindingImpl;
import com.sun.xml.ws.server.EndpointFactory;
import com.sun.xml.ws.server.ServerRtException;
import com.sun.xml.ws.transport.http.HttpAdapter;
import com.sun.xml.ws.transport.http.WSHTTPConnection;
import com.sun.xml.ws.util.xml.XmlUtil;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.EmptyCompletionHandler;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.http.Method;
import org.glassfish.grizzly.http.server.HttpHandler;
import org.glassfish.grizzly.http.server.Request;
import org.glassfish.grizzly.http.server.Response;
import org.glassfish.grizzly.jaxws.JaxwsConnection;
import org.xml.sax.EntityResolver;
import org.xml.sax.SAXException;

public class JaxwsHandler
extends HttpHandler {
    private static final Logger LOGGER = Grizzly.logger(JaxwsHandler.class);
    private final List<Source> metadata;
    private final Map<String, Object> properties;
    private final Object implementor;
    private final boolean isAsync;
    private WSEndpoint endpoint;
    private HttpAdapter httpAdapter;
    private volatile long timeoutMillis = TimeUnit.MILLISECONDS.convert(15L, TimeUnit.MINUTES);

    public JaxwsHandler(Object implementor) {
        this(implementor, false);
    }

    public JaxwsHandler(Object implementor, boolean isAsync) {
        this(implementor, isAsync, null, null);
    }

    public JaxwsHandler(Object implementor, boolean isAsync, List<Source> metadata, Map<String, Object> properties) {
        this.implementor = implementor;
        this.isAsync = isAsync;
        this.metadata = metadata;
        this.properties = properties;
    }

    public JaxwsHandler(WSEndpoint endpoint) {
        this(endpoint, false);
    }

    public JaxwsHandler(WSEndpoint endpoint, boolean isAsync) {
        this.endpoint = endpoint;
        this.isAsync = isAsync;
        this.implementor = null;
        this.metadata = null;
        this.properties = null;
    }

    public void start() {
        if (this.implementor != null) {
            this.endpoint = WSEndpoint.create(this.implementor.getClass(), (boolean)true, (Invoker)InstanceResolver.createSingleton((Object)this.implementor).createInvoker(), (QName)this.getProperty(QName.class, "javax.xml.ws.wsdl.service"), (QName)this.getProperty(QName.class, "javax.xml.ws.wsdl.port"), null, (WSBinding)BindingImpl.create((BindingID)BindingID.parse(this.implementor.getClass())), (SDDocumentSource)this.getPrimaryWsdl(this.implementor), this.buildDocList(), (EntityResolver)null, (!this.isAsync ? 1 : 0) != 0);
        }
        this.httpAdapter = HttpAdapter.createAlone((WSEndpoint)this.endpoint);
    }

    public boolean isAsync() {
        return this.isAsync;
    }

    public void setAsyncTimeout(long timeout, TimeUnit timeUnit) {
        this.timeoutMillis = TimeUnit.MILLISECONDS.convert(timeout, timeUnit);
    }

    public long getAsyncTimeout(TimeUnit timeUnit) {
        return timeUnit.convert(this.timeoutMillis, TimeUnit.MILLISECONDS);
    }

    public void service(Request req, Response res) throws Exception {
        LOGGER.log(Level.FINE, "Received a request. The request thread {0} .", Thread.currentThread());
        final JaxwsConnection connection = new JaxwsConnection(this.httpAdapter, req, res, req.isSecure(), this.isAsync);
        if (Method.GET.equals(req.getMethod()) && this.isMetadataQuery(connection.getQueryString())) {
            this.httpAdapter.publishWSDL((WSHTTPConnection)connection);
            return;
        }
        if (this.isAsync) {
            res.suspend(this.timeoutMillis, TimeUnit.MILLISECONDS, (CompletionHandler)new EmptyCompletionHandler<Response>(){

                public void cancelled() {
                    connection.close();
                }
            });
            this.httpAdapter.invokeAsync((WSHTTPConnection)connection);
        } else {
            this.httpAdapter.handle((WSHTTPConnection)connection);
        }
        LOGGER.log(Level.FINE, "Getting out of service(). Done with the request thread {0} .", Thread.currentThread());
    }

    private boolean isMetadataQuery(String query) {
        return query != null && (query.equals("WSDL") || query.startsWith("wsdl") || query.startsWith("xsd="));
    }

    private <T> T getProperty(Class<T> type, String key) {
        if (this.properties == null) {
            return null;
        }
        Object o = this.properties.get(key);
        if (o == null) {
            return null;
        }
        if (type.isInstance(o)) {
            return type.cast(o);
        }
        throw new IllegalArgumentException("Property " + key + " has to be of type " + type);
    }

    @Nullable
    private SDDocumentSource getPrimaryWsdl(Object implementor) {
        Class<?> implType = implementor.getClass();
        EndpointFactory.verifyImplementorClass(implType);
        String wsdlLocation = EndpointFactory.getWsdlLocation(implType);
        if (wsdlLocation != null) {
            ClassLoader cl = implType.getClassLoader();
            URL url = cl.getResource(wsdlLocation);
            if (url != null) {
                return SDDocumentSource.create((URL)url);
            }
            throw new ServerRtException("cannot.load.wsdl", new Object[]{wsdlLocation});
        }
        return null;
    }

    private List<SDDocumentSource> buildDocList() {
        ArrayList<SDDocumentSource> r = new ArrayList<SDDocumentSource>();
        if (this.metadata != null) {
            for (Source source : this.metadata) {
                try {
                    XMLStreamBufferResult xsbr = (XMLStreamBufferResult)XmlUtil.identityTransform((Source)source, (Result)new XMLStreamBufferResult());
                    String systemId = source.getSystemId();
                    r.add(SDDocumentSource.create((URL)new URL(systemId), (XMLStreamBuffer)xsbr.getXMLStreamBuffer()));
                }
                catch (TransformerException te) {
                    throw new ServerRtException("server.rt.err", new Object[]{te});
                }
                catch (IOException te) {
                    throw new ServerRtException("server.rt.err", new Object[]{te});
                }
                catch (SAXException e) {
                    throw new ServerRtException("server.rt.err", new Object[]{e});
                }
                catch (ParserConfigurationException e) {
                    throw new ServerRtException("server.rt.err", new Object[]{e});
                }
            }
        }
        return r;
    }
}

