/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.util;

import com.ning.http.client.ProxyServer;
import com.ning.http.client.Realm;
import com.ning.http.client.Request;
import com.ning.http.client.RequestBuilder;
import com.ning.http.client.async.RetryNonBlockingIssue;
import com.ning.http.util.AuthenticatorUtils;
import java.io.IOException;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class AuthenticatorUtilsTest {
    private final int port = RetryNonBlockingIssue.findFreePort();
    private static final String METHOD = "GET";
    private static final String URL = "http://127.0.0.1:%d/foo/test";
    private static final String HOST = "127.0.0.1";
    private static final String PASSWORD = "Beeblebrox";
    private static final String NTLM_PRINCIPAL = "Zaphod";
    private static final String NTLM_DOMAIN = "Ursa-Minor";
    private static final String NTLM_MSG_TYPE_1 = "NTLM TlRMTVNTUAABAAAAAYIIogAAAAAoAAAAAAAAACgAAAAFASgKAAAADw==";
    private static final String NTLM_HEADER_KEY = "Proxy-Authorization";
    private static final String NTLM_HEADER_VALUE = "NTLM TlRMTVNTUAADAAAAGAAYAEgAAAAYABgAYAAAABQAFAB4AAAADAAMAIwAAAASABIAmAAAAAAAAACqAAAAAYIAAgUBKAoAAAAPrYfKbe/jRoW5xDxHeoxC1gBmfWiS5+iX4OAN4xBKG/IFPwfH3agtPEia6YnhsADTVQBSAFMAQQAtAE0ASQBOAE8AUgBaAGEAcABoAG8AZABMAGkAZwBoAHQAQwBpAHQAeQA=";

    @DataProvider(name="proxyAuthorization")
    public Object[][] createData() {
        return new Object[][]{{Boolean.TRUE, Realm.AuthScheme.BASIC, null, null, null, null, null}, {Boolean.TRUE, Realm.AuthScheme.DIGEST, null, null, null, null, null}, {Boolean.TRUE, Realm.AuthScheme.KERBEROS, null, null, null, null, null}, {Boolean.TRUE, Realm.AuthScheme.NONE, null, null, null, null, null}, {Boolean.TRUE, Realm.AuthScheme.NTLM, NTLM_PRINCIPAL, NTLM_DOMAIN, null, null, NTLM_MSG_TYPE_1}, {Boolean.FALSE, Realm.AuthScheme.NTLM, NTLM_PRINCIPAL, NTLM_DOMAIN, null, null, NTLM_MSG_TYPE_1}, {Boolean.TRUE, Realm.AuthScheme.NTLM, NTLM_PRINCIPAL, NTLM_DOMAIN, NTLM_HEADER_KEY, NTLM_HEADER_VALUE, NTLM_HEADER_VALUE}, {Boolean.FALSE, Realm.AuthScheme.NTLM, NTLM_PRINCIPAL, NTLM_DOMAIN, NTLM_HEADER_KEY, NTLM_HEADER_VALUE, null}, {Boolean.TRUE, Realm.AuthScheme.SPNEGO, null, null, null, null, null}};
    }

    @Test(description="W-10863931: When the connection is not an NTLM one, the NTLM proxy authorization is not required.", dataProvider="proxyAuthorization")
    public void perConnectionProxyAuthorizationHeaderReturnsTheProxyAuthorizationExpected(boolean connect, Realm.AuthScheme authScheme, String principal, String ntlDomain, String headerKey, String headerValue, String proxyAuthorizationExpected) throws IOException {
        ProxyServer proxyServer = new ProxyServer(HOST, this.port, principal, PASSWORD);
        proxyServer.setNtlmDomain(ntlDomain);
        proxyServer.setScheme(authScheme);
        Request request = new RequestBuilder(METHOD).setProxyServer(proxyServer).setUrl(this.getUrl()).setHeader(headerKey, headerValue).build();
        String proxyAuthorization = AuthenticatorUtils.perConnectionProxyAuthorizationHeader((Request)request, (ProxyServer)proxyServer, (boolean)connect);
        Assert.assertEquals((String)proxyAuthorization, (String)proxyAuthorizationExpected);
    }

    private String getUrl() {
        return String.format(URL, this.port);
    }
}

