/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.oauth;

import com.ning.http.client.Param;
import com.ning.http.client.Request;
import com.ning.http.client.RequestBuilder;
import com.ning.http.client.SignatureCalculator;
import com.ning.http.client.oauth.ConsumerKey;
import com.ning.http.client.oauth.OAuthSignatureCalculator;
import com.ning.http.client.oauth.RequestToken;
import com.ning.http.client.uri.Uri;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.testng.Assert;
import org.testng.annotations.Test;

public class OAuthSignatureCalculatorTest {
    private static final String CONSUMER_KEY = "dpf43f3p2l4k3l03";
    private static final String CONSUMER_SECRET = "kd94hf93k423kf44";
    public static final String TOKEN_KEY = "nnch734d00sl2jdk";
    public static final String TOKEN_SECRET = "pfkkdhi9sl3r4s00";
    public static final String NONCE = "kllo9940pd9333jh";
    static final long TIMESTAMP = 1191242096L;

    private void testSignatureBaseString(Request request) {
        ConsumerKey consumer = new ConsumerKey("9djdj82h48djs9d2", CONSUMER_SECRET);
        RequestToken user = new RequestToken("kkk9d7dh3k39sjv7", TOKEN_SECRET);
        OAuthSignatureCalculator calc = new OAuthSignatureCalculator(consumer, user);
        String signatureBaseString = calc.signatureBaseString(request.getMethod(), request.getUri(), 137131201L, "7d8f3e4a", request.getFormParams(), request.getQueryParams()).toString();
        Assert.assertEquals((String)signatureBaseString, (String)"POST&http%3A%2F%2Fexample.com%2Frequest&a2%3Dr%2520b%26a3%3D2%2520q%26a3%3Da%26b5%3D%253D%25253D%26c%2540%3D%26c2%3D%26oauth_consumer_key%3D9djdj82h48djs9d2%26oauth_nonce%3D7d8f3e4a%26oauth_signature_method%3DHMAC-SHA1%26oauth_timestamp%3D137131201%26oauth_token%3Dkkk9d7dh3k39sjv7%26oauth_version%3D1.0");
    }

    private void testSignatureBaseStringWithEncodableOAuthToken(Request request) {
        ConsumerKey consumer = new ConsumerKey("9djdj82h48djs9d2", CONSUMER_SECRET);
        RequestToken user = new RequestToken("kkk9d7dh3k39sjv7", TOKEN_SECRET);
        OAuthSignatureCalculator calc = new OAuthSignatureCalculator(consumer, user);
        String signatureBaseString = calc.signatureBaseString(request.getMethod(), request.getUri(), 137131201L, "ZLc92RAkooZcIO/0cctl0Q==", request.getFormParams(), request.getQueryParams()).toString();
        Assert.assertEquals((String)signatureBaseString, (String)"POST&http%3A%2F%2Fexample.com%2Frequest&a2%3Dr%2520b%26a3%3D2%2520q%26a3%3Da%26b5%3D%253D%25253D%26c%2540%3D%26c2%3D%26oauth_consumer_key%3D9djdj82h48djs9d2%26oauth_nonce%3DZLc92RAkooZcIO%252F0cctl0Q%253D%253D%26oauth_signature_method%3DHMAC-SHA1%26oauth_timestamp%3D137131201%26oauth_token%3Dkkk9d7dh3k39sjv7%26oauth_version%3D1.0");
    }

    @Test(groups={"fast"})
    public void testSignatureBaseStringWithProperlyEncodedUri() {
        Request request = new RequestBuilder("POST").setUrl("http://example.com/request?b5=%3D%253D&a3=a&c%40=&a2=r%20b").addFormParam("c2", "").addFormParam("a3", "2 q").build();
        this.testSignatureBaseString(request);
        this.testSignatureBaseStringWithEncodableOAuthToken(request);
    }

    @Test(groups={"fast"})
    public void testSignatureBaseStringWithProperlyEncodedUriAndUpperCaseScheme() {
        Request request = new RequestBuilder("POST").setUrl("HTTP://example.com/request?b5=%3D%253D&a3=a&c%40=&a2=r%20b").addFormParam("c2", "").addFormParam("a3", "2 q").build();
        this.testSignatureBaseString(request);
        this.testSignatureBaseStringWithEncodableOAuthToken(request);
    }

    @Test(groups={"fast"})
    public void testSignatureBaseStringWithRawUri() {
        Request request = new RequestBuilder("POST").setUrl("http://example.com/request?b5=%3D%253D&a3=a&c%40=&a2=r b").addFormParam("c2", "").addFormParam("a3", "2 q").build();
        this.testSignatureBaseString(request);
        this.testSignatureBaseStringWithEncodableOAuthToken(request);
    }

    @Test(groups={"fast"})
    public void testGetCalculateSignature() {
        ConsumerKey consumer = new ConsumerKey(CONSUMER_KEY, CONSUMER_SECRET);
        RequestToken user = new RequestToken(TOKEN_KEY, TOKEN_SECRET);
        OAuthSignatureCalculator calc = new OAuthSignatureCalculator(consumer, user);
        ArrayList<Param> queryParams = new ArrayList<Param>();
        queryParams.add(new Param("file", "vacation.jpg"));
        queryParams.add(new Param("size", "original"));
        String url = "http://photos.example.net/photos";
        String sig = calc.calculateSignature("GET", Uri.create((String)url), 1191242096L, NONCE, null, queryParams);
        Assert.assertEquals((String)sig, (String)"tR3+Ty81lMeYAr/Fid0kMTYa/WM=");
    }

    @Test(groups={"fast"})
    public void testPostCalculateSignature() {
        ConsumerKey consumer = new ConsumerKey(CONSUMER_KEY, CONSUMER_SECRET);
        RequestToken user = new RequestToken(TOKEN_KEY, TOKEN_SECRET);
        StaticOAuthSignatureCalculator calc = new StaticOAuthSignatureCalculator(consumer, user, 1191242096L, NONCE);
        ArrayList<Param> formParams = new ArrayList<Param>();
        formParams.add(new Param("file", "vacation.jpg"));
        formParams.add(new Param("size", "original"));
        String url = "http://photos.example.net/photos";
        Request req = ((RequestBuilder)((RequestBuilder)new RequestBuilder("POST").setUri(Uri.create((String)url))).setFormParams(formParams).setSignatureCalculator((SignatureCalculator)calc)).build();
        String authHeader = (String)req.getHeaders().get((Object)"Authorization").get(0);
        Matcher m = Pattern.compile("oauth_signature=\"(.+?)\"").matcher(authHeader);
        Assert.assertEquals((boolean)m.find(), (boolean)true);
        String encodedSig = m.group(1);
        String sig = null;
        try {
            sig = URLDecoder.decode(encodedSig, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            Assert.fail((String)"bad encoding", (Throwable)e);
        }
        Assert.assertEquals((String)sig, (String)"wPkvxykrw+BTdCcGqKr+3I+PsiM=");
    }

    @Test(groups={"fast"})
    public void testGetWithRequestBuilderAndQueryParams() {
        ConsumerKey consumer = new ConsumerKey(CONSUMER_KEY, CONSUMER_SECRET);
        RequestToken user = new RequestToken(TOKEN_KEY, TOKEN_SECRET);
        StaticOAuthSignatureCalculator calc = new StaticOAuthSignatureCalculator(consumer, user, 1191242096L, NONCE);
        ArrayList<Param> queryParams = new ArrayList<Param>();
        queryParams.add(new Param("file", "vacation.jpg"));
        queryParams.add(new Param("size", "original"));
        String url = "http://photos.example.net/photos";
        Request req = ((RequestBuilder)((RequestBuilder)new RequestBuilder("GET").setUri(Uri.create((String)url))).setQueryParams(queryParams).setSignatureCalculator((SignatureCalculator)calc)).build();
        List params = req.getQueryParams();
        Assert.assertEquals((int)params.size(), (int)2);
        String authHeader = (String)req.getHeaders().get((Object)"Authorization").get(0);
        Matcher m = Pattern.compile("oauth_signature=\"(.+?)\"").matcher(authHeader);
        Assert.assertEquals((boolean)m.find(), (boolean)true);
        String encodedSig = m.group(1);
        String sig = null;
        try {
            sig = URLDecoder.decode(encodedSig, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            Assert.fail((String)"bad encoding", (Throwable)e);
        }
        Assert.assertEquals((String)sig, (String)"tR3+Ty81lMeYAr/Fid0kMTYa/WM=");
        Assert.assertEquals((String)req.getUrl(), (String)"http://photos.example.net/photos?file=vacation.jpg&size=original");
    }

    @Test(groups={"fast"})
    public void testGetWithRequestBuilderAndQuery() {
        ConsumerKey consumer = new ConsumerKey(CONSUMER_KEY, CONSUMER_SECRET);
        RequestToken user = new RequestToken(TOKEN_KEY, TOKEN_SECRET);
        StaticOAuthSignatureCalculator calc = new StaticOAuthSignatureCalculator(consumer, user, 1191242096L, NONCE);
        String url = "http://photos.example.net/photos?file=vacation.jpg&size=original";
        Request req = ((RequestBuilder)((RequestBuilder)new RequestBuilder("GET").setUri(Uri.create((String)url))).setSignatureCalculator((SignatureCalculator)calc)).build();
        List params = req.getQueryParams();
        Assert.assertEquals((int)params.size(), (int)2);
        String authHeader = (String)req.getHeaders().get((Object)"Authorization").get(0);
        Matcher m = Pattern.compile("oauth_signature=\"(.+?)\"").matcher(authHeader);
        Assert.assertEquals((boolean)m.find(), (boolean)true);
        String encodedSig = m.group(1);
        String sig = null;
        try {
            sig = URLDecoder.decode(encodedSig, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            Assert.fail((String)"bad encoding", (Throwable)e);
        }
        Assert.assertEquals((String)sig, (String)"tR3+Ty81lMeYAr/Fid0kMTYa/WM=");
        Assert.assertEquals((String)req.getUrl(), (String)"http://photos.example.net/photos?file=vacation.jpg&size=original");
    }

    private static class StaticOAuthSignatureCalculator
    extends OAuthSignatureCalculator {
        private final long timestamp;
        private final String nonce;

        public StaticOAuthSignatureCalculator(ConsumerKey consumerAuth, RequestToken userAuth, long timestamp, String nonce) {
            super(consumerAuth, userAuth);
            this.timestamp = timestamp;
            this.nonce = nonce;
        }

        protected long generateTimestamp() {
            return this.timestamp;
        }

        protected String generateNonce() {
            return this.nonce;
        }
    }
}

