/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.async;

import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.async.AbstractBasicTest;
import com.ning.http.util.AsyncHttpProviderUtils;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.testng.Assert;
import org.testng.annotations.Test;

public abstract class RetryRequestTest
extends AbstractBasicTest {
    @Override
    protected String getTargetUrl() {
        return String.format("http://127.0.0.1:%d/", this.port1);
    }

    @Override
    public AbstractHandler configureHandler() throws Exception {
        return new SlowAndBigHandler();
    }

    @Test(groups={"standalone", "default_provider"})
    public void testMaxRetry() throws Throwable {
        block8: {
            try (AsyncHttpClient client = this.getAsyncHttpClient(new AsyncHttpClientConfig.Builder().setMaxRequestRetry(0).build());){
                client.executeRequest(client.prepareGet(this.getTargetUrl()).build()).get();
                Assert.fail();
            }
            catch (Exception t) {
                Assert.assertNotNull((Object)t.getCause());
                Assert.assertEquals(t.getCause().getClass(), IOException.class);
                if (t.getCause() == AsyncHttpProviderUtils.REMOTELY_CLOSED_EXCEPTION) break block8;
                Assert.fail();
            }
        }
    }

    public static class SlowAndBigHandler
    extends AbstractHandler {
        public void handle(String pathInContext, Request request, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException, ServletException {
            int load = 100;
            httpResponse.setStatus(200);
            httpResponse.setContentLength(load);
            httpResponse.setContentType("application/octet-stream");
            httpResponse.flushBuffer();
            ServletOutputStream os = httpResponse.getOutputStream();
            for (int i = 0; i < load; ++i) {
                os.write(i % 255);
                try {
                    Thread.sleep(300L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (i <= load / 10) continue;
                httpResponse.sendError(500);
            }
            httpResponse.getOutputStream().flush();
            httpResponse.getOutputStream().close();
        }
    }
}

