/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.async;

import com.ning.http.client.AsyncHandler;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.HttpResponseBodyPart;
import com.ning.http.client.HttpResponseHeaders;
import com.ning.http.client.HttpResponseStatus;
import com.ning.http.client.ListenableFuture;
import com.ning.http.client.Response;
import com.ning.http.client.async.AbstractBasicTest;
import com.ning.http.client.providers.grizzly.PauseHandler;
import com.ning.http.util.CountingOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.testng.Assert;
import org.testng.annotations.Test;

public abstract class PauseAsyncHandlerTest
extends AbstractBasicTest {
    private static final int NUMBER_OF_CHUNKS = 5;
    private static final String CHUNK_CONTENT = "This is a chunk";

    @Override
    public AbstractHandler configureHandler() throws Exception {
        return new SlowChunkedHandler();
    }

    private AsyncHttpClientConfig getAsyncHttpClientConfig() {
        return new AsyncHttpClientConfig.Builder().setMaxRequestRetry(0).setRequestTimeout(10000).build();
    }

    @Test(groups={"standalone", "default_provider"})
    public void testPauseInTheMiddleOfResponseAndThenResume() throws Exception {
        this.doTest(false, (requestBuilder, asyncHandler, countingOutputStream, totalResponseLength) -> {
            ListenableFuture responseFuture = requestBuilder.execute((AsyncHandler)asyncHandler);
            PauseHandler pauseHandler = asyncHandler.pauseFuture().get();
            Thread.sleep(1000L);
            Assert.assertEquals((int)countingOutputStream.getByteCount(), (int)asyncHandler.bytesReceivedWhenPause(), (String)"Handler shouldn't read anything while paused");
            pauseHandler.resume();
            responseFuture.get();
            Assert.assertEquals((int)countingOutputStream.getByteCount(), (int)totalResponseLength, (String)"After resume, the whole response has to be received");
        });
    }

    @Test(groups={"standalone", "default_provider"})
    public void testPauseAndResumeBeforeActuallyPaused() throws Exception {
        this.doTest(false, (requestBuilder, asyncHandler, countingOutputStream, totalResponseLength) -> {
            ListenableFuture responseFuture = requestBuilder.execute((AsyncHandler)asyncHandler);
            ((CompletableFuture)asyncHandler.pauseFuture().whenComplete((pauseHandler, throwable) -> pauseHandler.resume())).get();
            responseFuture.get();
            Assert.assertEquals((int)countingOutputStream.getByteCount(), (int)totalResponseLength, (String)"After resume, the whole response has to be received");
        });
    }

    @Test(groups={"standalone", "default_provider"})
    public void testPausedHandlerDoesntReceiveErrorUntilResume() throws Exception {
        this.doTest(true, (requestBuilder, asyncHandler, countingOutputStream, totalResponseLength) -> {
            ListenableFuture responseFuture = requestBuilder.execute((AsyncHandler)asyncHandler);
            PauseHandler pauseHandler = asyncHandler.pauseFuture().get();
            Thread.sleep(1000L);
            ((TestPauseAsyncHandler)Mockito.verify((Object)asyncHandler, (VerificationMode)Mockito.times((int)0))).onThrowable((Throwable)ArgumentMatchers.any(Throwable.class));
            pauseHandler.resume();
            try {
                responseFuture.get();
                Assert.fail((String)"An exception is expected");
            }
            catch (ExecutionException remotelyClosed) {
                Assert.assertTrue((boolean)remotelyClosed.getMessage().contains("Remotely closed"), (String)"A remotely closed exception is expected here");
            }
            Assert.assertTrue((countingOutputStream.getByteCount() < totalResponseLength ? 1 : 0) != 0, (String)"We expect to receive less than the full response");
        });
    }

    private void doTest(boolean wantsFailure, TestCallback testCallback) throws Exception {
        try (AsyncHttpClient client = this.getAsyncHttpClient(this.getAsyncHttpClientConfig());){
            AsyncHttpClient.BoundRequestBuilder r = client.prepareGet("http://127.0.0.1:" + this.port1 + "/");
            if (wantsFailure) {
                PauseAsyncHandlerTest.configureRequestToReceiveAFailure(r);
            }
            int totalResponseLength = 5 * CHUNK_CONTENT.length();
            int pauseThreshold = totalResponseLength / 2;
            CountingOutputStream cos = new CountingOutputStream();
            TestPauseAsyncHandler asyncHandler = (TestPauseAsyncHandler)Mockito.spy((Object)new TestPauseAsyncHandler(cos, pauseThreshold));
            testCallback.apply(r, asyncHandler, cos, totalResponseLength);
            ((TestPauseAsyncHandler)Mockito.verify((Object)asyncHandler, (VerificationMode)Mockito.times((int)1))).onStatusReceived((HttpResponseStatus)ArgumentMatchers.any(HttpResponseStatus.class));
            ((TestPauseAsyncHandler)Mockito.verify((Object)asyncHandler, (VerificationMode)Mockito.times((int)1))).onHeadersReceived((HttpResponseHeaders)ArgumentMatchers.any(HttpResponseHeaders.class));
            if (wantsFailure) {
                ((TestPauseAsyncHandler)Mockito.verify((Object)asyncHandler, (VerificationMode)Mockito.times((int)0))).onCompleted();
                ((TestPauseAsyncHandler)Mockito.verify((Object)asyncHandler, (VerificationMode)Mockito.times((int)1))).onThrowable((Throwable)ArgumentMatchers.any(Throwable.class));
            } else {
                ((TestPauseAsyncHandler)Mockito.verify((Object)asyncHandler, (VerificationMode)Mockito.times((int)1))).onCompleted();
                ((TestPauseAsyncHandler)Mockito.verify((Object)asyncHandler, (VerificationMode)Mockito.times((int)0))).onThrowable((Throwable)ArgumentMatchers.any(Throwable.class));
            }
        }
    }

    private static void configureRequestToReceiveASlowResponse(AsyncHttpClient.BoundRequestBuilder r) {
        r.setHeader("X-SLOW", "yup");
    }

    private static void configureRequestToReceiveAFailure(AsyncHttpClient.BoundRequestBuilder r) {
        r.setHeader("X-FAIL-TRANSFER", "please");
    }

    private static class SlowChunkedHandler
    extends AbstractHandler {
        private SlowChunkedHandler() {
        }

        public void handle(String pathInContext, Request request, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException, ServletException {
            httpResponse.setStatus(200);
            httpResponse.setHeader("Transfer-encoding", "chunked");
            httpResponse.setContentType("application/text");
            httpResponse.flushBuffer();
            boolean wantFailure = httpRequest.getHeader("X-FAIL-TRANSFER") != null;
            boolean wantSlow = httpRequest.getHeader("X-SLOW") != null;
            ServletOutputStream os = httpResponse.getOutputStream();
            for (int i = 0; i < 5; ++i) {
                os.write(PauseAsyncHandlerTest.CHUNK_CONTENT.getBytes(), 0, PauseAsyncHandlerTest.CHUNK_CONTENT.length());
                if (wantSlow) {
                    try {
                        Thread.sleep(300L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (wantFailure && i == 4) {
                    httpResponse.sendError(500);
                    break;
                }
                httpResponse.getOutputStream().flush();
            }
            httpResponse.getOutputStream().flush();
            httpResponse.getOutputStream().close();
        }
    }

    private static interface TestCallback {
        public void apply(AsyncHttpClient.BoundRequestBuilder var1, TestPauseAsyncHandler var2, CountingOutputStream var3, int var4) throws ExecutionException, InterruptedException;
    }

    private static class TestPauseAsyncHandler
    implements AsyncHandler<Response> {
        private final CountingOutputStream cos;
        private final int countThresholdToPause;
        private final CompletableFuture<PauseHandler> pauseFuture = new CompletableFuture();
        private int bytesReceivedWhenPause = -1;

        public TestPauseAsyncHandler(CountingOutputStream cos, int countThresholdToPause) {
            this.cos = cos;
            this.countThresholdToPause = countThresholdToPause;
        }

        public void onThrowable(Throwable t) {
        }

        public AsyncHandler.STATE onBodyPartReceived(HttpResponseBodyPart bodyPart) throws Exception {
            bodyPart.writeTo((OutputStream)this.cos);
            if (this.cos.getByteCount() >= this.countThresholdToPause && !this.pauseFuture.isDone()) {
                PauseHandler pauseHandler = bodyPart.getPauseHandler();
                pauseHandler.requestPause();
                this.bytesReceivedWhenPause = this.cos.getByteCount();
                this.pauseFuture.complete(pauseHandler);
            }
            return AsyncHandler.STATE.CONTINUE;
        }

        public AsyncHandler.STATE onStatusReceived(HttpResponseStatus responseStatus) throws Exception {
            return AsyncHandler.STATE.CONTINUE;
        }

        public AsyncHandler.STATE onHeadersReceived(HttpResponseHeaders headers) throws Exception {
            return AsyncHandler.STATE.CONTINUE;
        }

        public Response onCompleted() throws Exception {
            return null;
        }

        public int bytesReceivedWhenPause() {
            return this.bytesReceivedWhenPause;
        }

        public CompletableFuture<PauseHandler> pauseFuture() {
            return this.pauseFuture;
        }
    }
}

