/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.async;

import com.ning.http.client.AsyncCompletionHandlerBase;
import com.ning.http.client.AsyncHandler;
import com.ning.http.client.AsyncHandlerExtensions;
import com.ning.http.client.HttpResponseHeaders;
import com.ning.http.client.HttpResponseStatus;
import com.ning.http.client.Response;
import java.net.InetAddress;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.testng.Assert;

public class EventCollectingHandler
extends AsyncCompletionHandlerBase
implements AsyncHandlerExtensions {
    public Queue<String> firedEvents = new ConcurrentLinkedQueue<String>();
    private CountDownLatch completionLatch = new CountDownLatch(1);

    public void waitForCompletion() throws InterruptedException {
        if (!this.completionLatch.await(30L, TimeUnit.SECONDS)) {
            Assert.fail((String)"Timeout out");
        }
    }

    public Response onCompleted(Response response) throws Exception {
        this.firedEvents.add("Completed");
        try {
            Response response2 = super.onCompleted(response);
            return response2;
        }
        finally {
            this.completionLatch.countDown();
        }
    }

    public AsyncHandler.STATE onStatusReceived(HttpResponseStatus status) throws Exception {
        this.firedEvents.add("StatusReceived");
        return super.onStatusReceived(status);
    }

    public AsyncHandler.STATE onHeadersReceived(HttpResponseHeaders headers) throws Exception {
        this.firedEvents.add("HeadersReceived");
        return super.onHeadersReceived(headers);
    }

    public AsyncHandler.STATE onHeaderWriteCompleted() {
        this.firedEvents.add("HeaderWriteCompleted");
        return super.onHeaderWriteCompleted();
    }

    public AsyncHandler.STATE onContentWriteCompleted() {
        this.firedEvents.add("ContentWriteCompleted");
        return super.onContentWriteCompleted();
    }

    public void onOpenConnection() {
        this.firedEvents.add("OpenConnection");
    }

    public void onConnectionOpen() {
        this.firedEvents.add("ConnectionOpen");
    }

    public void onPoolConnection() {
        this.firedEvents.add("PoolConnection");
    }

    public void onConnectionPooled() {
        this.firedEvents.add("ConnectionPooled");
    }

    public void onSendRequest(Object request) {
        this.firedEvents.add("SendRequest");
    }

    public void onRetry() {
        this.firedEvents.add("Retry");
    }

    public void onDnsResolved(InetAddress address) {
        this.firedEvents.add("DnsResolved");
    }

    public void onSslHandshakeCompleted() {
        this.firedEvents.add("SslHandshakeCompleted");
    }
}

