/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.async;

import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.BodyGenerator;
import com.ning.http.client.ListenableFuture;
import com.ning.http.client.Request;
import com.ning.http.client.RequestBuilder;
import com.ning.http.client.Response;
import com.ning.http.client.async.AbstractBasicTest;
import com.ning.http.client.generators.InputStreamBodyGenerator;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Random;
import java.util.concurrent.ExecutionException;
import org.testng.Assert;
import org.testng.FileAssert;
import org.testng.annotations.Test;

public abstract class ChunkingTest
extends AbstractBasicTest {
    public static byte[] LARGE_IMAGE_BYTES;

    @Test
    public void testBufferLargerThanFileWithStreamBodyGenerator() throws Throwable {
        this.doTestWithInputStreamBodyGenerator(new BufferedInputStream(new ByteArrayInputStream(LARGE_IMAGE_BYTES), 400000));
    }

    @Test
    public void testBufferSmallThanFileWithStreamBodyGenerator() throws Throwable {
        this.doTestWithInputStreamBodyGenerator(new BufferedInputStream(new ByteArrayInputStream(LARGE_IMAGE_BYTES)));
    }

    @Test
    public void testDirectFileWithStreamBodyGenerator() throws Throwable {
        this.doTestWithInputStreamBodyGenerator(new ByteArrayInputStream(LARGE_IMAGE_BYTES));
    }

    private void doTestWithInputStreamBodyGenerator(InputStream is) throws Throwable {
        AsyncHttpClientConfig.Builder bc = this.httpClientBuilder();
        try (AsyncHttpClient c = this.getAsyncHttpClient(bc.build());){
            RequestBuilder builder = new RequestBuilder("POST");
            builder.setUrl(this.getTargetUrl());
            builder.setBody((BodyGenerator)new InputStreamBodyGenerator(is));
            Request r = builder.build();
            ListenableFuture responseFuture = c.executeRequest(r);
            this.waitForAndAssertResponse((ListenableFuture<Response>)responseFuture);
        }
    }

    protected AsyncHttpClientConfig.Builder httpClientBuilder() {
        return new AsyncHttpClientConfig.Builder().setAllowPoolingConnections(true).setMaxConnectionsPerHost(1).setMaxConnections(1).setConnectTimeout(1000).setRequestTimeout(1000).setFollowRedirect(true);
    }

    protected void waitForAndAssertResponse(ListenableFuture<Response> responseFuture) throws InterruptedException, ExecutionException, IOException {
        Response response = (Response)responseFuture.get();
        if (500 == response.getStatusCode()) {
            StringBuilder sb = new StringBuilder();
            sb.append("==============\n");
            sb.append("500 response from call\n");
            sb.append("Headers:" + response.getHeaders() + "\n");
            sb.append("==============\n");
            this.log.debug(sb.toString());
            Assert.assertEquals((int)response.getStatusCode(), (int)500, (String)"Should have 500 status code");
            Assert.assertTrue((boolean)response.getHeader("X-Exception").contains("invalid.chunk.length"), (String)"Should have failed due to chunking");
            FileAssert.fail((String)("HARD Failing the test due to provided InputStreamBodyGenerator, chunking incorrectly:" + response.getHeader("X-Exception")));
        } else {
            Assert.assertEquals((byte[])response.getResponseBodyAsBytes(), (byte[])LARGE_IMAGE_BYTES);
        }
    }

    static {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        FileInputStream instream = null;
        try {
            ClassLoader cl = ChunkingTest.class.getClassLoader();
            URL url = cl.getResource("300k.png");
            File sourceFile = new File(url.toURI());
            instream = new FileInputStream(sourceFile);
            byte[] buf = new byte[8092];
            int len = 0;
            while ((len = ((InputStream)instream).read(buf)) > 0) {
                baos.write(buf, 0, len);
            }
            LARGE_IMAGE_BYTES = baos.toByteArray();
        }
        catch (Throwable e) {
            LARGE_IMAGE_BYTES = new byte[265495];
            Random x = new Random();
            x.nextBytes(LARGE_IMAGE_BYTES);
        }
    }
}

