/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.async;

import com.ning.http.client.AsyncHandler;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.FluentCaseInsensitiveStringsMap;
import com.ning.http.client.HttpResponseBodyPart;
import com.ning.http.client.HttpResponseHeaders;
import com.ning.http.client.HttpResponseStatus;
import com.ning.http.client.ListenableFuture;
import com.ning.http.client.Response;
import com.ning.http.client.async.AbstractBasicTest;
import java.util.Arrays;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.testng.Assert;
import org.testng.annotations.Test;

public abstract class AsyncStreamHandlerTest
extends AbstractBasicTest {
    private static final String RESPONSE = "param_1_";

    private String jetty8ContentTypeMadness(String saneValue) {
        return saneValue.replace(" ", "");
    }

    @Test(groups={"standalone", "default_provider"})
    public void asyncStreamGETTest() throws Exception {
        final CountDownLatch l = new CountDownLatch(1);
        final AtomicReference responseHeaders = new AtomicReference();
        final AtomicReference throwable = new AtomicReference();
        try (AsyncHttpClient client = this.getAsyncHttpClient(null);){
            client.prepareGet(this.getTargetUrl()).execute((AsyncHandler)new AbstractBasicTest.AsyncHandlerAdapter(){

                @Override
                public AsyncHandler.STATE onHeadersReceived(HttpResponseHeaders content) throws Exception {
                    try {
                        responseHeaders.set(content.getHeaders());
                        AsyncHandler.STATE sTATE = AsyncHandler.STATE.ABORT;
                        return sTATE;
                    }
                    finally {
                        l.countDown();
                    }
                }

                @Override
                public void onThrowable(Throwable t) {
                    try {
                        throwable.set(t);
                    }
                    finally {
                        l.countDown();
                    }
                }
            });
            if (!l.await(5L, TimeUnit.SECONDS)) {
                Assert.fail((String)"Timeout out");
            }
            FluentCaseInsensitiveStringsMap h = (FluentCaseInsensitiveStringsMap)responseHeaders.get();
            Assert.assertNotNull((Object)h, (String)"No response headers");
            Assert.assertEquals((String)h.getJoinedValue("content-type", ","), (String)this.jetty8ContentTypeMadness("text/html; charset=utf-8"), (String)"Unexpected content-type");
            Assert.assertNull(throwable.get(), (String)"Unexpected exception");
        }
    }

    @Test(groups={"standalone", "default_provider"})
    public void asyncStreamPOSTTest() throws Exception {
        final AtomicReference responseHeaders = new AtomicReference();
        try (AsyncHttpClient client = this.getAsyncHttpClient(null);){
            ListenableFuture f = client.preparePost(this.getTargetUrl()).setHeader("Content-Type", "application/x-www-form-urlencoded").addFormParam("param_1", "value_1").execute((AsyncHandler)new AbstractBasicTest.AsyncHandlerAdapter(){
                private StringBuilder builder = new StringBuilder();

                @Override
                public AsyncHandler.STATE onHeadersReceived(HttpResponseHeaders content) throws Exception {
                    responseHeaders.set(content.getHeaders());
                    return AsyncHandler.STATE.CONTINUE;
                }

                @Override
                public AsyncHandler.STATE onBodyPartReceived(HttpResponseBodyPart content) throws Exception {
                    this.builder.append(new String(content.getBodyPartBytes()));
                    return AsyncHandler.STATE.CONTINUE;
                }

                @Override
                public String onCompleted() throws Exception {
                    return this.builder.toString().trim();
                }
            });
            String responseBody = (String)f.get(10L, TimeUnit.SECONDS);
            FluentCaseInsensitiveStringsMap h = (FluentCaseInsensitiveStringsMap)responseHeaders.get();
            Assert.assertNotNull((Object)h);
            Assert.assertEquals((String)h.getJoinedValue("content-type", ","), (String)this.jetty8ContentTypeMadness("text/html; charset=utf-8"));
            Assert.assertEquals((String)responseBody, (String)RESPONSE);
        }
    }

    @Test(groups={"standalone", "default_provider"})
    public void asyncStreamInterruptTest() throws Exception {
        final CountDownLatch l = new CountDownLatch(1);
        final AtomicReference responseHeaders = new AtomicReference();
        final AtomicBoolean bodyReceived = new AtomicBoolean(false);
        final AtomicReference throwable = new AtomicReference();
        try (AsyncHttpClient client = this.getAsyncHttpClient(null);){
            client.preparePost(this.getTargetUrl()).setHeader("Content-Type", "application/x-www-form-urlencoded").addFormParam("param_1", "value_1").execute((AsyncHandler)new AbstractBasicTest.AsyncHandlerAdapter(){

                @Override
                public AsyncHandler.STATE onHeadersReceived(HttpResponseHeaders content) throws Exception {
                    responseHeaders.set(content.getHeaders());
                    return AsyncHandler.STATE.ABORT;
                }

                @Override
                public AsyncHandler.STATE onBodyPartReceived(HttpResponseBodyPart content) throws Exception {
                    bodyReceived.set(true);
                    return AsyncHandler.STATE.ABORT;
                }

                @Override
                public void onThrowable(Throwable t) {
                    throwable.set(t);
                    l.countDown();
                }
            });
            l.await(5L, TimeUnit.SECONDS);
            Assert.assertTrue((!bodyReceived.get() ? 1 : 0) != 0, (String)"Interrupted not working");
            FluentCaseInsensitiveStringsMap h = (FluentCaseInsensitiveStringsMap)responseHeaders.get();
            Assert.assertNotNull((Object)h, (String)"Should receive non null headers");
            Assert.assertEquals((String)h.getJoinedValue("content-type", ", "), (String)this.jetty8ContentTypeMadness("text/html; charset=utf-8"), (String)"Unexpected content-type");
            Assert.assertNull(throwable.get(), (String)"Should get an exception");
        }
    }

    @Test(groups={"standalone", "default_provider"})
    public void asyncStreamFutureTest() throws Exception {
        final AtomicReference responseHeaders = new AtomicReference();
        final AtomicReference throwable = new AtomicReference();
        try (AsyncHttpClient client = this.getAsyncHttpClient(null);){
            ListenableFuture f = client.preparePost(this.getTargetUrl()).addFormParam("param_1", "value_1").execute((AsyncHandler)new AbstractBasicTest.AsyncHandlerAdapter(){
                private StringBuilder builder = new StringBuilder();

                @Override
                public AsyncHandler.STATE onHeadersReceived(HttpResponseHeaders content) throws Exception {
                    responseHeaders.set(content.getHeaders());
                    return AsyncHandler.STATE.CONTINUE;
                }

                @Override
                public AsyncHandler.STATE onBodyPartReceived(HttpResponseBodyPart content) throws Exception {
                    this.builder.append(new String(content.getBodyPartBytes()));
                    return AsyncHandler.STATE.CONTINUE;
                }

                @Override
                public String onCompleted() throws Exception {
                    return this.builder.toString().trim();
                }

                @Override
                public void onThrowable(Throwable t) {
                    throwable.set(t);
                }
            });
            String responseBody = (String)f.get(5L, TimeUnit.SECONDS);
            FluentCaseInsensitiveStringsMap h = (FluentCaseInsensitiveStringsMap)responseHeaders.get();
            Assert.assertNotNull((Object)h, (String)"Should receive non null headers");
            Assert.assertEquals((String)h.getJoinedValue("content-type", ", "), (String)this.jetty8ContentTypeMadness("text/html; charset=utf-8"), (String)"Unexpected content-type");
            Assert.assertNotNull((Object)responseBody, (String)"No response body");
            Assert.assertEquals((String)responseBody.trim(), (String)RESPONSE, (String)"Unexpected response body");
            Assert.assertNull(throwable.get(), (String)"Unexpected exception");
        }
    }

    @Test(groups={"standalone", "default_provider"})
    public void asyncStreamThrowableRefusedTest() throws Exception {
        final CountDownLatch l = new CountDownLatch(1);
        try (AsyncHttpClient client = this.getAsyncHttpClient(null);){
            client.prepareGet(this.getTargetUrl()).execute((AsyncHandler)new AbstractBasicTest.AsyncHandlerAdapter(){

                @Override
                public AsyncHandler.STATE onHeadersReceived(HttpResponseHeaders content) throws Exception {
                    throw new RuntimeException("FOO");
                }

                @Override
                public void onThrowable(Throwable t) {
                    try {
                        if (t.getMessage() != null) {
                            Assert.assertEquals((String)t.getMessage(), (String)"FOO");
                        }
                    }
                    finally {
                        l.countDown();
                    }
                }
            });
            if (!l.await(10L, TimeUnit.SECONDS)) {
                Assert.fail((String)"Timed out");
            }
        }
    }

    @Test(groups={"standalone", "default_provider"})
    public void asyncStreamReusePOSTTest() throws Exception {
        final AtomicReference responseHeaders = new AtomicReference();
        try (AsyncHttpClient client = this.getAsyncHttpClient(null);){
            AsyncHttpClient.BoundRequestBuilder rb = client.preparePost(this.getTargetUrl()).setHeader("Content-Type", "application/x-www-form-urlencoded").addFormParam("param_1", "value_1");
            ListenableFuture f = rb.execute((AsyncHandler)new AbstractBasicTest.AsyncHandlerAdapter(){
                private StringBuilder builder = new StringBuilder();

                @Override
                public AsyncHandler.STATE onHeadersReceived(HttpResponseHeaders content) throws Exception {
                    responseHeaders.set(content.getHeaders());
                    return AsyncHandler.STATE.CONTINUE;
                }

                @Override
                public AsyncHandler.STATE onBodyPartReceived(HttpResponseBodyPart content) throws Exception {
                    this.builder.append(new String(content.getBodyPartBytes()));
                    return AsyncHandler.STATE.CONTINUE;
                }

                @Override
                public String onCompleted() throws Exception {
                    return this.builder.toString();
                }
            });
            String r = (String)f.get(5L, TimeUnit.SECONDS);
            FluentCaseInsensitiveStringsMap h = (FluentCaseInsensitiveStringsMap)responseHeaders.get();
            Assert.assertNotNull((Object)h, (String)"Should receive non null headers");
            Assert.assertEquals((String)h.getJoinedValue("content-type", ", "), (String)this.jetty8ContentTypeMadness("text/html; charset=utf-8"), (String)"Unexpected content-type");
            Assert.assertNotNull((Object)r, (String)"No response body");
            Assert.assertEquals((String)r.trim(), (String)RESPONSE, (String)"Unexpected response body");
            responseHeaders.set(null);
            f = rb.execute((AsyncHandler)new AbstractBasicTest.AsyncHandlerAdapter(){
                private StringBuilder builder = new StringBuilder();

                @Override
                public AsyncHandler.STATE onHeadersReceived(HttpResponseHeaders content) throws Exception {
                    responseHeaders.set(content.getHeaders());
                    return AsyncHandler.STATE.CONTINUE;
                }

                @Override
                public AsyncHandler.STATE onBodyPartReceived(HttpResponseBodyPart content) throws Exception {
                    this.builder.append(new String(content.getBodyPartBytes()));
                    return AsyncHandler.STATE.CONTINUE;
                }

                @Override
                public String onCompleted() throws Exception {
                    return this.builder.toString();
                }
            });
            f.get(5L, TimeUnit.SECONDS);
            h = (FluentCaseInsensitiveStringsMap)responseHeaders.get();
            Assert.assertNotNull((Object)h, (String)"Should receive non null headers");
            Assert.assertEquals((String)h.getJoinedValue("content-type", ", "), (String)this.jetty8ContentTypeMadness("text/html; charset=utf-8"), (String)"Unexpected content-type");
            Assert.assertNotNull((Object)r, (String)"No response body");
            Assert.assertEquals((String)r.trim(), (String)RESPONSE, (String)"Unexpected response body");
        }
    }

    @Test(groups={"online", "default_provider"})
    public void asyncStream302RedirectWithBody() throws Exception {
        final AtomicReference<Integer> statusCode = new AtomicReference<Integer>(0);
        final AtomicReference responseHeaders = new AtomicReference();
        try (AsyncHttpClient client = this.getAsyncHttpClient(new AsyncHttpClientConfig.Builder().setFollowRedirect(true).build());){
            ListenableFuture f = client.prepareGet("http://google.com").execute((AsyncHandler)new AbstractBasicTest.AsyncHandlerAdapter(){

                @Override
                public AsyncHandler.STATE onStatusReceived(HttpResponseStatus status) throws Exception {
                    statusCode.set(status.getStatusCode());
                    return AsyncHandler.STATE.CONTINUE;
                }

                @Override
                public AsyncHandler.STATE onHeadersReceived(HttpResponseHeaders content) throws Exception {
                    responseHeaders.set(content.getHeaders());
                    return AsyncHandler.STATE.CONTINUE;
                }

                @Override
                public String onCompleted() throws Exception {
                    return null;
                }
            });
            f.get(20L, TimeUnit.SECONDS);
            Assert.assertTrue((statusCode.get() != 302 ? 1 : 0) != 0);
            FluentCaseInsensitiveStringsMap h = (FluentCaseInsensitiveStringsMap)responseHeaders.get();
            Assert.assertNotNull((Object)h);
            Assert.assertEquals((String)h.getFirstValue("server"), (String)"gws");
        }
    }

    @Test(groups={"standalone", "default_provider"}, timeOut=3000L, description="Test behavior of 'read only status line' scenario.")
    public void asyncStreamJustStatusLine() throws Exception {
        boolean STATUS = false;
        boolean COMPLETED = true;
        int OTHER = 2;
        final boolean[] whatCalled = new boolean[]{false, false, false};
        final CountDownLatch latch = new CountDownLatch(1);
        try (AsyncHttpClient client = this.getAsyncHttpClient(null);){
            ListenableFuture statusCode = client.prepareGet(this.getTargetUrl()).execute((AsyncHandler)new AsyncHandler<Integer>(){
                private int status = -1;

                public void onThrowable(Throwable t) {
                    whatCalled[2] = true;
                    latch.countDown();
                }

                public AsyncHandler.STATE onBodyPartReceived(HttpResponseBodyPart bodyPart) throws Exception {
                    whatCalled[2] = true;
                    latch.countDown();
                    return AsyncHandler.STATE.ABORT;
                }

                public AsyncHandler.STATE onStatusReceived(HttpResponseStatus responseStatus) throws Exception {
                    whatCalled[0] = true;
                    this.status = responseStatus.getStatusCode();
                    latch.countDown();
                    return AsyncHandler.STATE.ABORT;
                }

                public AsyncHandler.STATE onHeadersReceived(HttpResponseHeaders headers) throws Exception {
                    whatCalled[2] = true;
                    latch.countDown();
                    return AsyncHandler.STATE.ABORT;
                }

                public Integer onCompleted() throws Exception {
                    whatCalled[1] = true;
                    latch.countDown();
                    return this.status;
                }
            });
            if (!latch.await(2L, TimeUnit.SECONDS)) {
                Assert.fail((String)"Timeout");
                return;
            }
            Integer status = (Integer)statusCode.get(30L, TimeUnit.SECONDS);
            Assert.assertEquals((int)status, (int)200, (String)"Expected status code failed.");
            if (!whatCalled[0]) {
                Assert.fail((String)"onStatusReceived not called.");
            }
            if (!whatCalled[1]) {
                Assert.fail((String)"onCompleted not called.");
            }
            if (whatCalled[2]) {
                Assert.fail((String)"Other method of AsyncHandler got called.");
            }
        }
    }

    @Test(groups={"online", "default_provider"})
    public void asyncOptionsTest() throws Exception {
        final AtomicReference responseHeaders = new AtomicReference();
        try (AsyncHttpClient client = this.getAsyncHttpClient(null);){
            Object[] expected = new String[]{"GET", "HEAD", "OPTIONS", "POST", "TRACE"};
            ListenableFuture f = client.prepareOptions(this.getTargetUrl()).execute((AsyncHandler)new AbstractBasicTest.AsyncHandlerAdapter(){

                @Override
                public AsyncHandler.STATE onHeadersReceived(HttpResponseHeaders content) throws Exception {
                    responseHeaders.set(content.getHeaders());
                    return AsyncHandler.STATE.ABORT;
                }

                @Override
                public String onCompleted() throws Exception {
                    return "OK";
                }
            });
            f.get(20L, TimeUnit.SECONDS);
            FluentCaseInsensitiveStringsMap h = (FluentCaseInsensitiveStringsMap)responseHeaders.get();
            Assert.assertNotNull((Object)h);
            Object[] values = ((String)h.get((Object)"Allow").get(0)).split(",|, ");
            Assert.assertNotNull((Object)values);
            Assert.assertEquals((int)values.length, (int)expected.length);
            Arrays.sort(values);
            Assert.assertEquals((Object[])values, (Object[])expected);
        }
    }

    @Test(groups={"standalone", "default_provider"})
    public void closeConnectionTest() throws Exception {
        try (AsyncHttpClient client = this.getAsyncHttpClient(null);){
            Response r = (Response)client.prepareGet(this.getTargetUrl()).execute((AsyncHandler)new AsyncHandler<Response>(){
                private Response.ResponseBuilder builder = new Response.ResponseBuilder();

                public AsyncHandler.STATE onHeadersReceived(HttpResponseHeaders content) throws Exception {
                    this.builder.accumulate(content);
                    return AsyncHandler.STATE.CONTINUE;
                }

                public void onThrowable(Throwable t) {
                }

                public AsyncHandler.STATE onBodyPartReceived(HttpResponseBodyPart content) throws Exception {
                    this.builder.accumulate(content);
                    if (content.isLast()) {
                        content.markUnderlyingConnectionAsToBeClosed();
                    }
                    return AsyncHandler.STATE.CONTINUE;
                }

                public AsyncHandler.STATE onStatusReceived(HttpResponseStatus responseStatus) throws Exception {
                    this.builder.accumulate(responseStatus);
                    return AsyncHandler.STATE.CONTINUE;
                }

                public Response onCompleted() throws Exception {
                    return this.builder.build();
                }
            }).get();
            Assert.assertNotNull((Object)r);
            Assert.assertEquals((int)r.getStatusCode(), (int)200);
        }
    }
}

