/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.async;

import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.FluentCaseInsensitiveStringsMap;
import com.ning.http.client.ListenableFuture;
import com.ning.http.client.Request;
import com.ning.http.client.RequestBuilder;
import com.ning.http.client.Response;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.URI;
import java.util.ArrayList;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class RetryNonBlockingIssue {
    private URI servletEndpointUri;
    private Server server;
    private int port1;

    public static int findFreePort() throws IOException {
        try (ServerSocket socket = new ServerSocket(0);){
            int n = socket.getLocalPort();
            return n;
        }
    }

    @BeforeMethod
    public void setUp() throws Exception {
        this.server = new Server();
        this.port1 = RetryNonBlockingIssue.findFreePort();
        ServerConnector listener = new ServerConnector(this.server);
        listener.setHost("127.0.0.1");
        listener.setPort(this.port1);
        this.server.addConnector((Connector)listener);
        ServletContextHandler context = new ServletContextHandler(1);
        context.setContextPath("/");
        this.server.setHandler((Handler)context);
        context.addServlet(new ServletHolder((Servlet)new MockExceptionServlet()), "/*");
        this.server.start();
        this.servletEndpointUri = new URI("http://127.0.0.1:" + this.port1 + "/");
    }

    @AfterMethod
    public void stop() {
        try {
            if (this.server != null) {
                this.server.stop();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private ListenableFuture<Response> testMethodRequest(AsyncHttpClient fetcher, int requests, String action, String id) throws IOException {
        RequestBuilder builder = new RequestBuilder("GET");
        builder.addQueryParam(action, "1");
        builder.addQueryParam("maxRequests", "" + requests);
        builder.addQueryParam("id", id);
        builder.setUrl(this.servletEndpointUri.toString());
        Request r = builder.build();
        return fetcher.executeRequest(r);
    }

    @Test
    public void testRetryNonBlocking() throws IOException, InterruptedException, ExecutionException {
        AsyncHttpClientConfig.Builder bc = new AsyncHttpClientConfig.Builder().setAllowPoolingConnections(true).setMaxConnections(100).setConnectTimeout(60000).setRequestTimeout(30000);
        ArrayList<ListenableFuture<Response>> res = new ArrayList<ListenableFuture<Response>>();
        try (AsyncHttpClient client = new AsyncHttpClient(bc.build());){
            for (int i = 0; i < 32; ++i) {
                res.add(this.testMethodRequest(client, 3, "servlet", UUID.randomUUID().toString()));
            }
            StringBuilder b = new StringBuilder();
            for (ListenableFuture listenableFuture : res) {
                Response theres = (Response)listenableFuture.get();
                b.append("==============\r\n");
                b.append("Response Headers\r\n");
                FluentCaseInsensitiveStringsMap heads = theres.getHeaders();
                b.append(heads + "\r\n");
                b.append("==============\r\n");
                Assert.assertTrue((heads.size() > 0 ? 1 : 0) != 0);
            }
            System.out.println(b.toString());
            System.out.flush();
        }
    }

    @Test
    public void testRetryNonBlockingAsyncConnect() throws IOException, InterruptedException, ExecutionException {
        AsyncHttpClientConfig.Builder bc = new AsyncHttpClientConfig.Builder().setAllowPoolingConnections(true).setMaxConnections(100).setConnectTimeout(60000).setRequestTimeout(30000);
        ArrayList<ListenableFuture<Response>> res = new ArrayList<ListenableFuture<Response>>();
        try (AsyncHttpClient client = new AsyncHttpClient(bc.build());){
            for (int i = 0; i < 32; ++i) {
                res.add(this.testMethodRequest(client, 3, "servlet", UUID.randomUUID().toString()));
            }
            StringBuilder b = new StringBuilder();
            for (ListenableFuture listenableFuture : res) {
                Response theres = (Response)listenableFuture.get();
                b.append("==============\r\n");
                b.append("Response Headers\r\n");
                FluentCaseInsensitiveStringsMap heads = theres.getHeaders();
                b.append(heads + "\r\n");
                b.append("==============\r\n");
                Assert.assertTrue((heads.size() > 0 ? 1 : 0) != 0);
            }
            System.out.println(b.toString());
            System.out.flush();
        }
    }

    @Test
    public void testRetryBlocking() throws IOException, InterruptedException, ExecutionException {
        AsyncHttpClientConfig.Builder bc = new AsyncHttpClientConfig.Builder().setAllowPoolingConnections(true).setMaxConnections(100).setConnectTimeout(30000).setRequestTimeout(30000);
        ArrayList<ListenableFuture<Response>> res = new ArrayList<ListenableFuture<Response>>();
        try (AsyncHttpClient client = new AsyncHttpClient(bc.build());){
            for (int i = 0; i < 32; ++i) {
                res.add(this.testMethodRequest(client, 3, "servlet", UUID.randomUUID().toString()));
            }
            StringBuilder b = new StringBuilder();
            for (ListenableFuture listenableFuture : res) {
                Response theres = (Response)listenableFuture.get();
                b.append("==============\r\n");
                b.append("Response Headers\r\n");
                FluentCaseInsensitiveStringsMap heads = theres.getHeaders();
                b.append(heads + "\r\n");
                b.append("==============\r\n");
                Assert.assertTrue((heads.size() > 0 ? 1 : 0) != 0);
            }
            System.out.println(b.toString());
            System.out.flush();
        }
    }

    public class MockExceptionServlet
    extends HttpServlet {
        private Map<String, Integer> requests = new ConcurrentHashMap<String, Integer>();

        private synchronized int increment(String id) {
            int val = 0;
            if (this.requests.containsKey(id)) {
                Integer i = this.requests.get(id);
                val = i + 1;
                this.requests.put(id, val);
            } else {
                this.requests.put(id, 1);
                val = 1;
            }
            System.out.println("REQUESTS: " + this.requests);
            return val;
        }

        public void service(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
            String maxRequests = req.getParameter("maxRequests");
            int max = 0;
            try {
                max = Integer.parseInt(maxRequests);
            }
            catch (NumberFormatException e) {
                max = 3;
            }
            String id = req.getParameter("id");
            int requestNo = this.increment(id);
            String servlet = req.getParameter("servlet");
            String io = req.getParameter("io");
            String error = req.getParameter("500");
            if (requestNo >= max) {
                res.setHeader("Success-On-Attempt", "" + requestNo);
                res.setHeader("id", id);
                if (servlet != null && servlet.trim().length() > 0) {
                    res.setHeader("type", "servlet");
                }
                if (error != null && error.trim().length() > 0) {
                    res.setHeader("type", "500");
                }
                if (io != null && io.trim().length() > 0) {
                    res.setHeader("type", "io");
                }
                res.setStatus(200);
                res.setContentLength(0);
                return;
            }
            res.setStatus(200);
            res.setContentLength(100);
            res.setContentType("application/octet-stream");
            res.flushBuffer();
            if (servlet != null && servlet.trim().length() > 0) {
                throw new ServletException("Servlet Exception");
            }
            if (io != null && io.trim().length() > 0) {
                throw new IOException("IO Exception");
            }
            if (error != null && error.trim().length() > 0) {
                res.sendError(500, "servlet process was 500");
            }
        }
    }
}

