/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.async;

import com.ning.http.client.AsyncCompletionHandlerBase;
import com.ning.http.client.AsyncHandler;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.ListenableFuture;
import com.ning.http.client.Response;
import com.ning.http.client.async.AbstractBasicTest;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

public abstract class MaxTotalConnectionTest
extends AbstractBasicTest {
    protected final Logger log = LoggerFactory.getLogger(AbstractBasicTest.class);

    @Test(groups={"standalone", "default_provider"})
    public void testMaxTotalConnectionsExceedingException() throws IOException {
        String[] urls = new String[]{"http://google.com", "http://github.com/"};
        AsyncHttpClientConfig config = new AsyncHttpClientConfig.Builder().setConnectTimeout(1000).setRequestTimeout(5000).setAllowPoolingConnections(false).setMaxConnections(1).setMaxConnectionsPerHost(1).build();
        try (AsyncHttpClient client = this.getAsyncHttpClient(config);){
            int i;
            ArrayList<ListenableFuture> futures = new ArrayList<ListenableFuture>();
            for (int i2 = 0; i2 < urls.length; ++i2) {
                futures.add(client.prepareGet(urls[i2]).execute());
            }
            boolean caughtError = false;
            for (i = 0; i < urls.length; ++i) {
                try {
                    ((ListenableFuture)futures.get(i)).get();
                    continue;
                }
                catch (Exception e) {
                    caughtError = true;
                    break;
                }
            }
            Assert.assertEquals((int)i, (int)1);
            Assert.assertTrue((boolean)caughtError);
        }
    }

    @Test
    public void testMaxTotalConnections() throws InterruptedException {
        String[] urls = new String[]{"http://google.com", "https://mulesoft.com"};
        AsyncHttpClientConfig config = new AsyncHttpClientConfig.Builder().setConnectTimeout(1000).setRequestTimeout(5000).setAllowPoolingConnections(false).setMaxConnections(2).setMaxConnectionsPerHost(1).build();
        final CountDownLatch latch = new CountDownLatch(2);
        final AtomicReference failedUrl = new AtomicReference();
        try (AsyncHttpClient client = this.getAsyncHttpClient(config);){
            String[] stringArray = urls;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String url;
                final String thisUrl = url = stringArray[i];
                client.prepareGet(url).execute((AsyncHandler)new AsyncCompletionHandlerBase(){

                    public Response onCompleted(Response response) throws Exception {
                        Response r = super.onCompleted(response);
                        latch.countDown();
                        return r;
                    }

                    public void onThrowable(Throwable t) {
                        super.onThrowable(t);
                        failedUrl.set(thisUrl);
                        latch.countDown();
                    }
                });
            }
            latch.await();
            Assert.assertNull(failedUrl.get());
        }
    }
}

