/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.async;

import com.ning.http.client.AsyncCompletionHandlerBase;
import com.ning.http.client.AsyncHandler;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.ListenableFuture;
import com.ning.http.client.Request;
import com.ning.http.client.RequestBuilder;
import com.ning.http.client.Response;
import com.ning.http.client.async.AbstractBasicTest;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

public abstract class ConnectionPoolTest
extends AbstractBasicTest {
    protected final Logger log = LoggerFactory.getLogger(AbstractBasicTest.class);

    @Test(groups={"standalone", "default_provider"})
    public void testMaxTotalConnections() {
        try (AsyncHttpClient client = this.getAsyncHttpClient(new AsyncHttpClientConfig.Builder().setAllowPoolingConnections(true).setMaxConnections(1).build());){
            String url = this.getTargetUrl();
            Exception exception = null;
            for (int i = 0; i < 3; ++i) {
                try {
                    this.log.info("{} requesting url [{}]...", (Object)i, (Object)url);
                    Response response = (Response)client.prepareGet(url).execute().get();
                    this.log.info("{} response [{}].", (Object)i, (Object)response);
                    continue;
                }
                catch (Exception ex) {
                    exception = ex;
                }
            }
            Assert.assertNull(exception);
        }
    }

    @Test(groups={"standalone", "default_provider"})
    public void testMaxTotalConnectionsException() throws IOException {
        try (AsyncHttpClient client = this.getAsyncHttpClient(new AsyncHttpClientConfig.Builder().setAllowPoolingConnections(true).setMaxConnections(1).build());){
            String url = this.getTargetUrl();
            ArrayList<ListenableFuture> futures = new ArrayList<ListenableFuture>();
            for (int i = 0; i < 5; ++i) {
                this.log.info("{} requesting url [{}]...", (Object)i, (Object)url);
                futures.add(client.prepareGet(url).execute());
            }
            Throwable exception = null;
            for (ListenableFuture future : futures) {
                try {
                    future.get();
                }
                catch (Exception ex) {
                    exception = ex;
                    break;
                }
            }
            Assert.assertNotNull(exception);
            Assert.assertNotNull((Object)exception.getCause());
            Assert.assertEquals((String)exception.getCause().getMessage(), (String)"Too many connections 1");
        }
    }

    @Test(groups={"standalone", "default_provider", "async"}, enabled=true, invocationCount=10, alwaysRun=true)
    public void asyncDoGetKeepAliveHandlerTest_channelClosedDoesNotFail() throws Throwable {
        try (AsyncHttpClient client = this.getAsyncHttpClient(null);){
            final CountDownLatch l = new CountDownLatch(2);
            final ConcurrentHashMap remoteAddresses = new ConcurrentHashMap();
            AbstractBasicTest.AsyncCompletionHandlerAdapter handler = new AbstractBasicTest.AsyncCompletionHandlerAdapter(){

                @Override
                public Response onCompleted(Response response) throws Exception {
                    System.out.println("ON COMPLETED INVOKED " + response.getHeader("X-KEEP-ALIVE"));
                    try {
                        Assert.assertEquals((int)response.getStatusCode(), (int)200);
                        remoteAddresses.put(response.getHeader("X-KEEP-ALIVE"), true);
                    }
                    finally {
                        l.countDown();
                    }
                    return response;
                }
            };
            client.prepareGet(this.getTargetUrl()).execute((AsyncHandler)handler).get();
            this.server.stop();
            this.server.start();
            client.prepareGet(this.getTargetUrl()).execute((AsyncHandler)handler);
            if (!l.await(30L, TimeUnit.SECONDS)) {
                Assert.fail((String)"Timed out");
            }
            Assert.assertEquals((int)remoteAddresses.size(), (int)2);
        }
    }

    @Test(groups={"standalone", "default_provider"})
    public void multipleMaxConnectionOpenTest() throws Throwable {
        AsyncHttpClientConfig cg = new AsyncHttpClientConfig.Builder().setAllowPoolingConnections(true).setConnectTimeout(5000).setMaxConnections(1).build();
        try (AsyncHttpClient client = this.getAsyncHttpClient(cg);){
            String body = "hello there";
            Response response = (Response)client.preparePost(this.getTargetUrl()).setBody(body).execute().get(30L, TimeUnit.SECONDS);
            Assert.assertEquals((String)response.getResponseBody(), (String)body);
            Exception exception = null;
            try {
                client.preparePost(String.format("http://127.0.0.1:%d/foo/test", this.port2)).setBody(body).execute().get(30L, TimeUnit.SECONDS);
                Assert.fail((String)"Should throw exception. Too many connections issued.");
            }
            catch (Exception ex) {
                ex.printStackTrace();
                exception = ex;
            }
            Assert.assertNotNull((Object)exception);
            Assert.assertNotNull((Object)exception.getCause());
            Assert.assertEquals((String)exception.getCause().getMessage(), (String)"Too many connections 1");
        }
    }

    @Test(groups={"standalone", "default_provider"})
    public void multipleMaxConnectionOpenTestWithQuery() throws Throwable {
        AsyncHttpClientConfig cg = new AsyncHttpClientConfig.Builder().setAllowPoolingConnections(true).setConnectTimeout(5000).setMaxConnections(1).build();
        try (AsyncHttpClient client = this.getAsyncHttpClient(cg);){
            String body = "hello there";
            Response response = (Response)client.preparePost(this.getTargetUrl() + "?foo=bar").setBody(body).execute().get(30L, TimeUnit.SECONDS);
            Assert.assertEquals((String)response.getResponseBody(), (String)("foo_" + body));
            Object exception = null;
            try {
                response = (Response)client.preparePost(this.getTargetUrl()).setBody(body).execute().get(30L, TimeUnit.SECONDS);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            Assert.assertNull(exception);
            Assert.assertNotNull((Object)response);
            Assert.assertEquals((int)response.getStatusCode(), (int)200);
        }
    }

    @Test(groups={"standalone", "default_provider"})
    public void win7DisconnectTest() throws Throwable {
        final AtomicInteger count = new AtomicInteger(0);
        try (AsyncHttpClient client = this.getAsyncHttpClient(null);){
            AbstractBasicTest.AsyncCompletionHandlerAdapter handler = new AbstractBasicTest.AsyncCompletionHandlerAdapter(){

                @Override
                public Response onCompleted(Response response) throws Exception {
                    count.incrementAndGet();
                    StackTraceElement e = new StackTraceElement("sun.nio.ch.SocketDispatcher", "read0", null, -1);
                    IOException t = new IOException();
                    t.setStackTrace(new StackTraceElement[]{e});
                    throw t;
                }
            };
            try {
                client.prepareGet(this.getTargetUrl()).execute((AsyncHandler)handler).get();
                Assert.fail((String)"Must have received an exception");
            }
            catch (ExecutionException ex) {
                Assert.assertNotNull((Object)ex);
                Assert.assertNotNull((Object)ex.getCause());
                Assert.assertEquals(ex.getCause().getClass(), IOException.class);
                Assert.assertEquals((int)count.get(), (int)1);
            }
        }
    }

    @Test(groups={"standalone", "default_provider"})
    public void asyncHandlerOnThrowableTest() throws Throwable {
        try (AsyncHttpClient client = this.getAsyncHttpClient(null);){
            final AtomicInteger count = new AtomicInteger();
            String THIS_IS_NOT_FOR_YOU = "This is not for you";
            final CountDownLatch latch = new CountDownLatch(16);
            for (int i = 0; i < 16; ++i) {
                client.prepareGet(this.getTargetUrl()).execute((AsyncHandler)new AsyncCompletionHandlerBase(){

                    public Response onCompleted(Response response) throws Exception {
                        throw new Exception("This is not for you");
                    }
                });
                client.prepareGet(this.getTargetUrl()).execute((AsyncHandler)new AsyncCompletionHandlerBase(){

                    public void onThrowable(Throwable t) {
                        if (t.getMessage() != null && t.getMessage().equalsIgnoreCase("This is not for you")) {
                            count.incrementAndGet();
                        }
                    }

                    public Response onCompleted(Response response) throws Exception {
                        latch.countDown();
                        return response;
                    }
                });
            }
            latch.await(30L, TimeUnit.SECONDS);
            Assert.assertEquals((int)count.get(), (int)0);
        }
    }

    @Test(groups={"standalone", "default_provider"})
    public void nonPoolableConnectionReleaseSemaphoresTest() throws Throwable {
        AsyncHttpClientConfig config = new AsyncHttpClientConfig.Builder().setMaxConnections(6).setMaxConnectionsPerHost(3).build();
        Request request = new RequestBuilder().setUrl(this.getTargetUrl()).setHeader("Connection", "close").build();
        try (AsyncHttpClient client = this.getAsyncHttpClient(config);){
            client.executeRequest(request).get();
            Thread.sleep(1000L);
            client.executeRequest(request).get();
            Thread.sleep(1000L);
            client.executeRequest(request).get();
            Thread.sleep(1000L);
            client.executeRequest(request).get();
        }
    }
}

