/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.async;

import com.ning.http.client.AsyncCompletionHandler;
import com.ning.http.client.AsyncHandler;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.AsyncHttpClientConfigBean;
import com.ning.http.client.AsyncHttpProviderConfig;
import com.ning.http.client.FluentCaseInsensitiveStringsMap;
import com.ning.http.client.ListenableFuture;
import com.ning.http.client.MaxRedirectException;
import com.ning.http.client.ProxyServer;
import com.ning.http.client.Request;
import com.ning.http.client.RequestBuilder;
import com.ning.http.client.Response;
import com.ning.http.client.async.AbstractBasicTest;
import com.ning.http.client.cookie.Cookie;
import com.ning.http.client.multipart.Part;
import com.ning.http.client.multipart.StringPart;
import com.ning.http.util.DateUtils;
import com.ning.http.util.MiscUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.channels.UnresolvedAddressException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.SSLException;
import org.glassfish.grizzly.http.util.HttpStatus;
import org.testng.Assert;
import org.testng.annotations.Test;

public abstract class AsyncProvidersBasicTest
extends AbstractBasicTest {
    private static final String TEXT_HTML_UTF_8 = "text/html;charset=utf-8";

    @Test(groups={"standalone", "default_provider", "async"})
    public void asyncProviderEncodingTest() throws Throwable {
        try (AsyncHttpClient client = this.getAsyncHttpClient(null);){
            Request request = new RequestBuilder("GET").setUrl(this.getTargetUrl() + "?q=+%20x").build();
            String requestUrl = request.getUrl();
            Assert.assertEquals((String)requestUrl, (String)(this.getTargetUrl() + "?q=+%20x"));
            ListenableFuture responseFuture = client.executeRequest(request, (AsyncHandler)new AsyncCompletionHandler<String>(){

                public String onCompleted(Response response) throws Exception {
                    return response.getUri().toString();
                }

                public void onThrowable(Throwable t) {
                    t.printStackTrace();
                    Assert.fail((String)("Unexpected exception: " + t.getMessage()), (Throwable)t);
                }
            });
            String url = (String)responseFuture.get();
            Assert.assertEquals((String)url, (String)(this.getTargetUrl() + "?q=+%20x"));
        }
    }

    @Test(groups={"standalone", "default_provider", "async"})
    public void asyncProviderEncodingTest2() throws Throwable {
        try (AsyncHttpClient client = this.getAsyncHttpClient(null);){
            Request request = new RequestBuilder("GET").setUrl(this.getTargetUrl() + "").addQueryParam("q", "a b").build();
            ListenableFuture responseFuture = client.executeRequest(request, (AsyncHandler)new AsyncCompletionHandler<String>(){

                public String onCompleted(Response response) throws Exception {
                    return response.getUri().toString();
                }

                public void onThrowable(Throwable t) {
                    t.printStackTrace();
                    Assert.fail((String)("Unexpected exception: " + t.getMessage()), (Throwable)t);
                }
            });
            String url = (String)responseFuture.get();
            Assert.assertEquals((String)url, (String)(this.getTargetUrl() + "?q=a%20b"));
        }
    }

    @Test(groups={"standalone", "default_provider", "async"}, expectedExceptions={ExecutionException.class})
    public void asyncProviderMaxRequestHeadersTest() throws Throwable {
        AsyncHttpClientConfig.Builder builder = new AsyncHttpClientConfig.Builder();
        builder.setMaxRequestHeaders(2);
        AsyncHttpClientConfig asyncHttpClientConfig = builder.build();
        try (AsyncHttpClient client = this.getAsyncHttpClient(asyncHttpClientConfig);){
            Request request = new RequestBuilder("GET").setUrl(this.getTargetUrl() + "").addQueryParam("q", "a b").addHeader("header1", "someValue").addHeader("header2", "someValue").addHeader("header3", "someValue").build();
            ListenableFuture responseFuture = client.executeRequest(request, (AsyncHandler)new AsyncCompletionHandler<String>(){

                public String onCompleted(Response response) throws Exception {
                    return response.getUri().toString();
                }

                public void onThrowable(Throwable t) {
                    t.printStackTrace();
                    Assert.fail((String)("Unexpected exception: " + t.getMessage()), (Throwable)t);
                }
            });
            responseFuture.get();
        }
        catch (ExecutionException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("MaxHeaderCountExceededException"));
            throw e;
        }
    }

    @Test(groups={"standalone", "default_provider", "async"})
    public void emptyRequestURI() throws Throwable {
        try (AsyncHttpClient client = this.getAsyncHttpClient(null);){
            Request request = new RequestBuilder("GET").setUrl(this.getTargetUrl()).build();
            ListenableFuture responseFuture = client.executeRequest(request, (AsyncHandler)new AsyncCompletionHandler<String>(){

                public String onCompleted(Response response) throws Exception {
                    return response.getUri().toString();
                }

                public void onThrowable(Throwable t) {
                    t.printStackTrace();
                    Assert.fail((String)("Unexpected exception: " + t.getMessage()), (Throwable)t);
                }
            });
            String url = (String)responseFuture.get();
            Assert.assertEquals((String)url, (String)this.getTargetUrl());
        }
    }

    @Test(groups={"standalone", "default_provider", "async"})
    public void asyncProviderContentLenghtGETTest() throws Throwable {
        try (AsyncHttpClient client = this.getAsyncHttpClient(null);){
            final CountDownLatch l = new CountDownLatch(1);
            URL url = new URL(this.getTargetUrl());
            final HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.connect();
            Request request = new RequestBuilder("GET").setUrl(this.getTargetUrl()).build();
            client.executeRequest(request, (AsyncHandler)new AbstractBasicTest.AsyncCompletionHandlerAdapter(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Response onCompleted(Response response) throws Exception {
                    try {
                        int contentLenght = -1;
                        Assert.assertEquals((int)response.getStatusCode(), (int)HttpStatus.OK_200.getStatusCode());
                        if (response.getHeader("content-length") != null) {
                            contentLenght = Integer.valueOf(response.getHeader("content-length"));
                        }
                        int ct = connection.getContentLength();
                        Assert.assertEquals((int)contentLenght, (int)ct);
                    }
                    finally {
                        l.countDown();
                    }
                    return response;
                }

                @Override
                public void onThrowable(Throwable t) {
                    try {
                        Assert.fail((String)"Unexpected exception", (Throwable)t);
                    }
                    finally {
                        l.countDown();
                    }
                }
            }).get();
            if (!l.await(30L, TimeUnit.SECONDS)) {
                Assert.fail((String)"Timeout out");
            }
        }
    }

    @Test(groups={"standalone", "default_provider", "async"})
    public void asyncContentTypeGETTest() throws Throwable {
        try (AsyncHttpClient client = this.getAsyncHttpClient(null);){
            final CountDownLatch l = new CountDownLatch(1);
            Request request = new RequestBuilder("GET").setUrl(this.getTargetUrl()).build();
            client.executeRequest(request, (AsyncHandler)new AbstractBasicTest.AsyncCompletionHandlerAdapter(){

                @Override
                public Response onCompleted(Response response) throws Exception {
                    try {
                        Assert.assertEquals((int)response.getStatusCode(), (int)HttpStatus.OK_200.getStatusCode());
                        Assert.assertEquals((String)response.getContentType(), (String)AsyncProvidersBasicTest.TEXT_HTML_UTF_8);
                    }
                    finally {
                        l.countDown();
                    }
                    return response;
                }
            }).get();
            if (!l.await(30L, TimeUnit.SECONDS)) {
                Assert.fail((String)"Timeout out");
            }
        }
    }

    @Test(groups={"standalone", "default_provider", "async"})
    public void asyncHeaderGETTest() throws Throwable {
        try (AsyncHttpClient client = this.getAsyncHttpClient(null);){
            final CountDownLatch l = new CountDownLatch(1);
            Request request = new RequestBuilder("GET").setUrl(this.getTargetUrl()).build();
            client.executeRequest(request, (AsyncHandler)new AbstractBasicTest.AsyncCompletionHandlerAdapter(){

                @Override
                public Response onCompleted(Response response) throws Exception {
                    try {
                        Assert.assertEquals((int)response.getStatusCode(), (int)HttpStatus.OK_200.getStatusCode());
                        Assert.assertEquals((String)response.getContentType(), (String)AsyncProvidersBasicTest.TEXT_HTML_UTF_8);
                    }
                    finally {
                        l.countDown();
                    }
                    return response;
                }
            }).get();
            if (!l.await(30L, TimeUnit.SECONDS)) {
                Assert.fail((String)"Timeout out");
            }
        }
    }

    @Test(groups={"standalone", "default_provider", "async"})
    public void asyncHeaderPOSTTest() throws Throwable {
        try (AsyncHttpClient client = this.getAsyncHttpClient(null);){
            final CountDownLatch l = new CountDownLatch(1);
            FluentCaseInsensitiveStringsMap h = new FluentCaseInsensitiveStringsMap();
            h.add("Test1", "Test1");
            h.add("Test2", "Test2");
            h.add("Test3", "Test3");
            h.add("Test4", "Test4");
            h.add("Test5", "Test5");
            Request request = new RequestBuilder("GET").setUrl(this.getTargetUrl()).setHeaders(h).build();
            client.executeRequest(request, (AsyncHandler)new AbstractBasicTest.AsyncCompletionHandlerAdapter(){

                @Override
                public Response onCompleted(Response response) throws Exception {
                    try {
                        System.out.println(">>>>> " + response.getStatusText());
                        Assert.assertEquals((int)response.getStatusCode(), (int)HttpStatus.OK_200.getStatusCode());
                        for (int i = 1; i < 5; ++i) {
                            Assert.assertEquals((String)response.getHeader("X-Test" + i), (String)("Test" + i));
                        }
                    }
                    finally {
                        l.countDown();
                    }
                    return response;
                }
            }).get();
            if (!l.await(30L, TimeUnit.SECONDS)) {
                Assert.fail((String)"Timeout out");
            }
        }
    }

    @Test(groups={"standalone", "default_provider", "async"})
    public void asyncParamPOSTTest() throws Throwable {
        try (AsyncHttpClient client = this.getAsyncHttpClient(null);){
            final CountDownLatch l = new CountDownLatch(1);
            FluentCaseInsensitiveStringsMap h = new FluentCaseInsensitiveStringsMap();
            h.add("Content-Type", "application/x-www-form-urlencoded");
            HashMap<String, List<String>> m = new HashMap<String, List<String>>();
            for (int i = 0; i < 5; ++i) {
                m.put("param_" + i, Arrays.asList("value_" + i));
            }
            Request request = new RequestBuilder("POST").setUrl(this.getTargetUrl()).setHeaders(h).setFormParams(m).build();
            client.executeRequest(request, (AsyncHandler)new AbstractBasicTest.AsyncCompletionHandlerAdapter(){

                @Override
                public Response onCompleted(Response response) throws Exception {
                    try {
                        Assert.assertEquals((int)response.getStatusCode(), (int)HttpStatus.OK_200.getStatusCode());
                        for (int i = 1; i < 5; ++i) {
                            System.out.println(">>>>> " + response.getHeader("X-param_" + i));
                            Assert.assertEquals((String)response.getHeader("X-param_" + i), (String)("value_" + i));
                        }
                    }
                    finally {
                        l.countDown();
                    }
                    return response;
                }
            }).get();
            if (!l.await(30L, TimeUnit.SECONDS)) {
                Assert.fail((String)"Timeout out");
            }
        }
    }

    @Test(groups={"standalone", "default_provider", "async"})
    public void asyncStatusHEADTest() throws Throwable {
        try (AsyncHttpClient client = this.getAsyncHttpClient(null);){
            final CountDownLatch l = new CountDownLatch(1);
            Request request = new RequestBuilder("HEAD").setUrl(this.getTargetUrl()).build();
            Response response = (Response)client.executeRequest(request, (AsyncHandler)new AbstractBasicTest.AsyncCompletionHandlerAdapter(){

                @Override
                public Response onCompleted(Response response) throws Exception {
                    try {
                        Assert.assertEquals((int)response.getStatusCode(), (int)HttpStatus.OK_200.getStatusCode());
                    }
                    finally {
                        l.countDown();
                    }
                    return response;
                }
            }).get();
            try {
                String s = response.getResponseBody();
                Assert.assertEquals((String)"", (String)s);
            }
            catch (IllegalStateException ex) {
                Assert.fail();
            }
            if (!l.await(30L, TimeUnit.SECONDS)) {
                Assert.fail((String)"Timeout out");
            }
        }
    }

    @Test(groups={"standalone", "default_provider", "async"}, enabled=false)
    public void asyncStatusHEADContentLenghtTest() throws Throwable {
        try (AsyncHttpClient client = this.getAsyncHttpClient(new AsyncHttpClientConfig.Builder().setRequestTimeout(120000).build());){
            final CountDownLatch l = new CountDownLatch(1);
            Request request = new RequestBuilder("HEAD").setUrl(this.getTargetUrl()).build();
            final AtomicReference<Object> responseRef = new AtomicReference<Object>(null);
            final AtomicReference<Object> throwableRef = new AtomicReference<Object>(null);
            client.executeRequest(request, (AsyncHandler)new AbstractBasicTest.AsyncCompletionHandlerAdapter(){

                @Override
                public Response onCompleted(Response response) throws Exception {
                    responseRef.set(response);
                    return response;
                }

                @Override
                public void onThrowable(Throwable t) {
                    throwableRef.set(t);
                    l.countDown();
                }
            }).get();
            if (!l.await(50000L, TimeUnit.SECONDS)) {
                Assert.fail((String)"Timeout out");
            }
            Assert.assertNull(responseRef.get(), (String)"Got a Response while expecting a Throwable");
            Throwable t = throwableRef.get();
            Assert.assertNotNull((Object)t, (String)"Expected a Throwable");
            Assert.assertEquals(t.getClass(), IOException.class);
            Assert.assertEquals((String)t.getMessage(), (String)"No response received. Connection timed out");
        }
    }

    @Test(groups={"online", "default_provider", "async"}, expectedExceptions={NullPointerException.class})
    public void asyncNullSchemeTest() throws Throwable {
        try (AsyncHttpClient client = this.getAsyncHttpClient(null);){
            client.prepareGet("www.sun.com").execute();
        }
    }

    @Test(groups={"standalone", "default_provider", "async"})
    public void asyncDoGetTransferEncodingTest() throws Throwable {
        try (AsyncHttpClient client = this.getAsyncHttpClient(null);){
            final CountDownLatch l = new CountDownLatch(1);
            client.prepareGet(this.getTargetUrl()).execute((AsyncHandler)new AbstractBasicTest.AsyncCompletionHandlerAdapter(){

                @Override
                public Response onCompleted(Response response) throws Exception {
                    try {
                        Assert.assertEquals((int)response.getStatusCode(), (int)HttpStatus.OK_200.getStatusCode());
                        Assert.assertEquals((String)response.getHeader("Transfer-Encoding"), (String)"chunked");
                    }
                    finally {
                        l.countDown();
                    }
                    return response;
                }
            }).get();
            if (!l.await(30L, TimeUnit.SECONDS)) {
                Assert.fail((String)"Timeout out");
            }
        }
    }

    @Test(groups={"standalone", "default_provider", "async"})
    public void asyncDoGetHeadersTest() throws Throwable {
        try (AsyncHttpClient client = this.getAsyncHttpClient(null);){
            final CountDownLatch l = new CountDownLatch(1);
            FluentCaseInsensitiveStringsMap h = new FluentCaseInsensitiveStringsMap();
            h.add("Test1", "Test1");
            h.add("Test2", "Test2");
            h.add("Test3", "Test3");
            h.add("Test4", "Test4");
            h.add("Test5", "Test5");
            client.prepareGet(this.getTargetUrl()).setHeaders(h).execute((AsyncHandler)new AbstractBasicTest.AsyncCompletionHandlerAdapter(){

                @Override
                public Response onCompleted(Response response) throws Exception {
                    try {
                        Assert.assertEquals((int)response.getStatusCode(), (int)HttpStatus.OK_200.getStatusCode());
                        for (int i = 1; i < 5; ++i) {
                            Assert.assertEquals((String)response.getHeader("X-Test" + i), (String)("Test" + i));
                        }
                    }
                    finally {
                        l.countDown();
                    }
                    return response;
                }
            }).get();
            if (!l.await(30L, TimeUnit.SECONDS)) {
                Assert.fail((String)"Timeout out");
            }
        }
    }

    @Test(groups={"standalone", "default_provider", "async"})
    public void asyncDoGetCookieTest() throws Throwable {
        try (AsyncHttpClient client = this.getAsyncHttpClient(null);){
            final CountDownLatch l = new CountDownLatch(1);
            FluentCaseInsensitiveStringsMap h = new FluentCaseInsensitiveStringsMap();
            h.add("Test1", "Test1");
            h.add("Test2", "Test2");
            h.add("Test3", "Test3");
            h.add("Test4", "Test4");
            h.add("Test5", "Test5");
            Cookie coo = new Cookie("foo", "value", false, "/", "/", Long.MIN_VALUE, false, false);
            client.prepareGet(this.getTargetUrl()).setHeaders(h).addCookie(coo).execute((AsyncHandler)new AbstractBasicTest.AsyncCompletionHandlerAdapter(){

                @Override
                public Response onCompleted(Response response) throws Exception {
                    try {
                        Assert.assertEquals((int)response.getStatusCode(), (int)HttpStatus.OK_200.getStatusCode());
                        List cookies = response.getCookies();
                        Assert.assertEquals((int)cookies.size(), (int)1);
                        Assert.assertEquals((String)((Cookie)cookies.get(0)).toString(), (String)"foo=value");
                    }
                    finally {
                        l.countDown();
                    }
                    return response;
                }
            }).get();
            if (!l.await(30L, TimeUnit.SECONDS)) {
                Assert.fail((String)"Timeout out");
            }
        }
    }

    @Test(groups={"standalone", "default_provider", "async"})
    public void asyncDoGetCookieExpiredCookiesRemovedTest() throws Throwable {
        try (AsyncHttpClient client = this.getAsyncHttpClient(null);){
            Cookie cookie = new Cookie("cookie1", "myCookie", false, "/", "/", Long.MIN_VALUE, false, false);
            Cookie expiredCookie = new Cookie("cookie2", "myExpCookie", false, "/", "/", 0L, false, false);
            Response response = (Response)client.prepareGet(this.getTargetUrl()).addCookie(cookie).addCookie(expiredCookie).execute().get(30L, TimeUnit.SECONDS);
            Assert.assertEquals((int)response.getStatusCode(), (int)HttpStatus.OK_200.getStatusCode());
            List cookies = response.getCookies();
            Assert.assertEquals((int)cookies.size(), (int)1);
            Assert.assertEquals((String)((Cookie)cookies.get(0)).toString(), (String)"cookie1=myCookie");
        }
    }

    @Test(groups={"standalone", "default_provider", "async"})
    public void asyncDoPostDefaultContentType() throws Throwable {
        try (AsyncHttpClient client = this.getAsyncHttpClient(null);){
            final CountDownLatch l = new CountDownLatch(1);
            client.preparePost(this.getTargetUrl()).addFormParam("foo", "bar").execute((AsyncHandler)new AbstractBasicTest.AsyncCompletionHandlerAdapter(){

                @Override
                public Response onCompleted(Response response) throws Exception {
                    try {
                        Assert.assertEquals((int)response.getStatusCode(), (int)HttpStatus.OK_200.getStatusCode());
                        FluentCaseInsensitiveStringsMap h = response.getHeaders();
                        Assert.assertEquals((String)h.getJoinedValue("X-Content-Type", ", "), (String)"application/x-www-form-urlencoded");
                    }
                    finally {
                        l.countDown();
                    }
                    return response;
                }
            }).get();
            if (!l.await(30L, TimeUnit.SECONDS)) {
                Assert.fail((String)"Timeout out");
            }
        }
    }

    @Test(groups={"standalone", "default_provider", "async"})
    public void asyncDoPostBodyIsoTest() throws Throwable {
        try (AsyncHttpClient client = this.getAsyncHttpClient(null);){
            Response r = (Response)client.preparePost(this.getTargetUrl()).addHeader("X-ISO", "true").setBody("\u017d\u017d\u017d\u017d\u017d\u017d").execute().get();
            Assert.assertEquals((byte[])r.getResponseBody().getBytes(StandardCharsets.ISO_8859_1), (byte[])"\u017d\u017d\u017d\u017d\u017d\u017d".getBytes(StandardCharsets.ISO_8859_1));
        }
    }

    @Test(groups={"standalone", "default_provider", "async"})
    public void asyncDoPostBytesTest() throws Throwable {
        try (AsyncHttpClient client = this.getAsyncHttpClient(null);){
            final CountDownLatch l = new CountDownLatch(1);
            FluentCaseInsensitiveStringsMap h = new FluentCaseInsensitiveStringsMap();
            h.add("Content-Type", "application/x-www-form-urlencoded");
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < 5; ++i) {
                sb.append("param_");
                sb.append(i);
                sb.append("=value_");
                sb.append(i);
                sb.append("&");
            }
            sb.setLength(sb.length() - 1);
            client.preparePost(this.getTargetUrl()).setHeaders(h).setBody(sb.toString()).execute((AsyncHandler)new AbstractBasicTest.AsyncCompletionHandlerAdapter(){

                @Override
                public Response onCompleted(Response response) throws Exception {
                    try {
                        Assert.assertEquals((int)response.getStatusCode(), (int)HttpStatus.OK_200.getStatusCode());
                        for (int i = 1; i < 5; ++i) {
                            System.out.println(">>>>> " + response.getHeader("X-param_" + i));
                            Assert.assertEquals((String)response.getHeader("X-param_" + i), (String)("value_" + i));
                        }
                    }
                    finally {
                        l.countDown();
                    }
                    return response;
                }
            }).get();
            if (!l.await(30L, TimeUnit.SECONDS)) {
                Assert.fail((String)"Timeout out");
            }
        }
    }

    @Test(groups={"standalone", "default_provider", "async"})
    public void asyncDoPostInputStreamTest() throws Throwable {
        try (AsyncHttpClient client = this.getAsyncHttpClient(null);){
            final CountDownLatch l = new CountDownLatch(1);
            FluentCaseInsensitiveStringsMap h = new FluentCaseInsensitiveStringsMap();
            h.add("Content-Type", "application/x-www-form-urlencoded");
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < 5; ++i) {
                sb.append("param_");
                sb.append(i);
                sb.append("=value_");
                sb.append(i);
                sb.append("&");
            }
            sb.setLength(sb.length() - 1);
            ByteArrayInputStream is = new ByteArrayInputStream(sb.toString().getBytes());
            client.preparePost(this.getTargetUrl()).setHeaders(h).setBody((InputStream)is).execute((AsyncHandler)new AbstractBasicTest.AsyncCompletionHandlerAdapter(){

                @Override
                public Response onCompleted(Response response) throws Exception {
                    try {
                        Assert.assertEquals((int)response.getStatusCode(), (int)HttpStatus.OK_200.getStatusCode());
                        for (int i = 1; i < 5; ++i) {
                            System.out.println(">>>>> " + response.getHeader("X-param_" + i));
                            Assert.assertEquals((String)response.getHeader("X-param_" + i), (String)("value_" + i));
                        }
                    }
                    finally {
                        l.countDown();
                    }
                    return response;
                }
            }).get();
            if (!l.await(30L, TimeUnit.SECONDS)) {
                Assert.fail((String)"Timeout out");
            }
        }
    }

    @Test(groups={"standalone", "default_provider", "async"})
    public void asyncDoPutInputStreamTest() throws Throwable {
        try (AsyncHttpClient client = this.getAsyncHttpClient(null);){
            final CountDownLatch l = new CountDownLatch(1);
            FluentCaseInsensitiveStringsMap h = new FluentCaseInsensitiveStringsMap();
            h.add("Content-Type", "application/x-www-form-urlencoded");
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < 5; ++i) {
                sb.append("param_");
                sb.append(i);
                sb.append("=value_");
                sb.append(i);
                sb.append("&");
            }
            sb.setLength(sb.length() - 1);
            ByteArrayInputStream is = new ByteArrayInputStream(sb.toString().getBytes());
            client.preparePut(this.getTargetUrl()).setHeaders(h).setBody((InputStream)is).execute((AsyncHandler)new AbstractBasicTest.AsyncCompletionHandlerAdapter(){

                @Override
                public Response onCompleted(Response response) throws Exception {
                    try {
                        Assert.assertEquals((int)response.getStatusCode(), (int)HttpStatus.OK_200.getStatusCode());
                        for (int i = 1; i < 5; ++i) {
                            System.out.println(">>>>> " + response.getHeader("X-param_" + i));
                            Assert.assertEquals((String)response.getHeader("X-param_" + i), (String)("value_" + i));
                        }
                    }
                    finally {
                        l.countDown();
                    }
                    return response;
                }
            }).get();
            if (!l.await(30L, TimeUnit.SECONDS)) {
                Assert.fail((String)"Timeout out");
            }
        }
    }

    @Test(groups={"standalone", "default_provider", "async"})
    public void asyncDoPostMultiPartTest() throws Throwable {
        try (AsyncHttpClient client = this.getAsyncHttpClient(null);){
            final CountDownLatch l = new CountDownLatch(1);
            StringPart p = new StringPart("foo", "bar");
            client.preparePost(this.getTargetUrl()).addBodyPart((Part)p).execute((AsyncHandler)new AbstractBasicTest.AsyncCompletionHandlerAdapter(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Response onCompleted(Response response) throws Exception {
                    try {
                        String xContentType = response.getHeader("X-Content-Type");
                        String boundary = xContentType.substring(xContentType.indexOf("boundary") + "boundary".length() + 1);
                        String s = response.getResponseBodyExcerpt(boundary.length() + "--".length()).substring("--".length());
                        Assert.assertEquals((String)boundary, (String)s);
                    }
                    finally {
                        l.countDown();
                    }
                    return response;
                }
            }).get();
            if (!l.await(30L, TimeUnit.SECONDS)) {
                Assert.fail((String)"Timeout out");
            }
        }
    }

    protected abstract String generatedAcceptEncodingHeader();

    @Test(groups={"standalone", "default_provider", "async"})
    public void asyncDoPostBasicGZIPTest() throws Throwable {
        AsyncHttpClientConfig cf = new AsyncHttpClientConfig.Builder().setCompressionEnforced(true).build();
        try (AsyncHttpClient client = this.getAsyncHttpClient(cf);){
            final CountDownLatch l = new CountDownLatch(1);
            FluentCaseInsensitiveStringsMap h = new FluentCaseInsensitiveStringsMap();
            h.add("Content-Type", "application/x-www-form-urlencoded");
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < 5; ++i) {
                sb.append("param_");
                sb.append(i);
                sb.append("=value_");
                sb.append(i);
                sb.append("&");
            }
            sb.setLength(sb.length() - 1);
            client.preparePost(this.getTargetUrl()).setHeaders(h).setBody(sb.toString()).execute((AsyncHandler)new AbstractBasicTest.AsyncCompletionHandlerAdapter(){

                @Override
                public Response onCompleted(Response response) throws Exception {
                    try {
                        Assert.assertEquals((int)response.getStatusCode(), (int)HttpStatus.OK_200.getStatusCode());
                        Assert.assertEquals((String)response.getHeader("X-Accept-Encoding"), (String)AsyncProvidersBasicTest.this.generatedAcceptEncodingHeader());
                    }
                    finally {
                        l.countDown();
                    }
                    return response;
                }
            }).get();
            if (!l.await(30L, TimeUnit.SECONDS)) {
                Assert.fail((String)"Timeout out");
            }
        }
    }

    @Test(groups={"standalone", "default_provider", "async"})
    public void asyncDoPostProxyTest() throws Throwable {
        AsyncHttpClientConfig cf = new AsyncHttpClientConfig.Builder().setProxyServer(new ProxyServer("127.0.0.1", this.port2)).build();
        try (AsyncHttpClient client = this.getAsyncHttpClient(cf);){
            FluentCaseInsensitiveStringsMap h = new FluentCaseInsensitiveStringsMap();
            h.add("Content-Type", "application/x-www-form-urlencoded");
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < 5; ++i) {
                sb.append("param_");
                sb.append(i);
                sb.append("=value_");
                sb.append(i);
                sb.append("&");
            }
            sb.setLength(sb.length() - 1);
            Response response = (Response)client.preparePost(this.getTargetUrl()).setHeaders(h).setBody(sb.toString()).execute((AsyncHandler)new AsyncCompletionHandler<Response>(){

                public Response onCompleted(Response response) throws Exception {
                    return response;
                }

                public void onThrowable(Throwable t) {
                }
            }).get();
            Assert.assertEquals((int)response.getStatusCode(), (int)HttpStatus.OK_200.getStatusCode());
            Assert.assertEquals((String)response.getHeader("X-Connection"), (String)"keep-alive");
        }
    }

    @Test(groups={"standalone", "default_provider", "async"})
    public void asyncRequestVirtualServerPOSTTest() throws Throwable {
        try (AsyncHttpClient client = this.getAsyncHttpClient(null);){
            FluentCaseInsensitiveStringsMap h = new FluentCaseInsensitiveStringsMap();
            h.add("Content-Type", "application/x-www-form-urlencoded");
            HashMap<String, List<String>> m = new HashMap<String, List<String>>();
            for (int i = 0; i < 5; ++i) {
                m.put("param_" + i, Arrays.asList("value_" + i));
            }
            Request request = new RequestBuilder("POST").setUrl(this.getTargetUrl()).setHeaders(h).setFormParams(m).setVirtualHost("localhost:" + this.port1).build();
            Response response = (Response)client.executeRequest(request, (AsyncHandler)new AbstractBasicTest.AsyncCompletionHandlerAdapter()).get();
            Assert.assertEquals((int)response.getStatusCode(), (int)HttpStatus.OK_200.getStatusCode());
            if (response.getHeader("X-Host").startsWith("localhost")) {
                Assert.assertEquals((String)response.getHeader("X-Host"), (String)("localhost:" + this.port1));
            } else {
                Assert.assertEquals((String)response.getHeader("X-Host"), (String)("127.0.0.1:" + this.port1));
            }
        }
    }

    @Test(groups={"standalone", "default_provider", "async"})
    public void asyncDoPutTest() throws Throwable {
        try (AsyncHttpClient client = this.getAsyncHttpClient(null);){
            FluentCaseInsensitiveStringsMap h = new FluentCaseInsensitiveStringsMap();
            h.add("Content-Type", "application/x-www-form-urlencoded");
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < 5; ++i) {
                sb.append("param_");
                sb.append(i);
                sb.append("=value_");
                sb.append(i);
                sb.append("&");
            }
            sb.setLength(sb.length() - 1);
            Response response = (Response)client.preparePut(this.getTargetUrl()).setHeaders(h).setBody(sb.toString()).execute((AsyncHandler)new AbstractBasicTest.AsyncCompletionHandlerAdapter()).get();
            Assert.assertEquals((int)response.getStatusCode(), (int)HttpStatus.OK_200.getStatusCode());
        }
    }

    @Test(groups={"standalone", "default_provider", "async"})
    public void asyncDoPostLatchBytesTest() throws Throwable {
        try (AsyncHttpClient client = this.getAsyncHttpClient(null);){
            final CountDownLatch l = new CountDownLatch(1);
            FluentCaseInsensitiveStringsMap h = new FluentCaseInsensitiveStringsMap();
            h.add("Content-Type", "application/x-www-form-urlencoded");
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < 5; ++i) {
                sb.append("param_");
                sb.append(i);
                sb.append("=value_");
                sb.append(i);
                sb.append("&");
            }
            sb.setLength(sb.length() - 1);
            client.preparePost(this.getTargetUrl()).setHeaders(h).setBody(sb.toString()).execute((AsyncHandler)new AbstractBasicTest.AsyncCompletionHandlerAdapter(){

                @Override
                public Response onCompleted(Response response) throws Exception {
                    try {
                        Assert.assertEquals((int)response.getStatusCode(), (int)HttpStatus.OK_200.getStatusCode());
                        for (int i = 1; i < 5; ++i) {
                            System.out.println(">>>>> " + response.getHeader("X-param_" + i));
                            Assert.assertEquals((String)response.getHeader("X-param_" + i), (String)("value_" + i));
                        }
                        Response response2 = response;
                        return response2;
                    }
                    finally {
                        l.countDown();
                    }
                }
            });
            if (!l.await(30L, TimeUnit.SECONDS)) {
                Assert.fail((String)"Timeout out");
            }
        }
    }

    @Test(groups={"standalone", "default_provider", "async"}, expectedExceptions={CancellationException.class})
    public void asyncDoPostDelayCancelTest() throws Throwable {
        try (AsyncHttpClient client = this.getAsyncHttpClient(null);){
            FluentCaseInsensitiveStringsMap h = new FluentCaseInsensitiveStringsMap();
            h.add("Content-Type", "application/x-www-form-urlencoded");
            h.add("LockThread", "true");
            StringBuilder sb = new StringBuilder();
            sb.append("LockThread=true");
            ListenableFuture future = client.preparePost(this.getTargetUrl()).setHeaders(h).setBody(sb.toString()).execute((AsyncHandler)new AbstractBasicTest.AsyncCompletionHandlerAdapter(){

                @Override
                public void onThrowable(Throwable t) {
                }
            });
            Thread.sleep(1000L);
            future.cancel(true);
            future.get(30L, TimeUnit.SECONDS);
        }
    }

    @Test(groups={"standalone", "default_provider", "async"})
    public void asyncDoPostDelayBytesTest() throws Throwable {
        try (AsyncHttpClient client = this.getAsyncHttpClient(null);){
            FluentCaseInsensitiveStringsMap h = new FluentCaseInsensitiveStringsMap();
            h.add("Content-Type", "application/x-www-form-urlencoded");
            h.add("LockThread", "true");
            StringBuilder sb = new StringBuilder();
            sb.append("LockThread=true");
            try {
                ListenableFuture future = client.preparePost(this.getTargetUrl()).setHeaders(h).setBody(sb.toString()).execute((AsyncHandler)new AbstractBasicTest.AsyncCompletionHandlerAdapter(){

                    @Override
                    public void onThrowable(Throwable t) {
                        t.printStackTrace();
                    }
                });
                future.get(10L, TimeUnit.SECONDS);
            }
            catch (ExecutionException ex) {
                if (ex.getCause() instanceof TimeoutException) {
                    Assert.assertTrue((boolean)true);
                }
            }
            catch (TimeoutException te) {
                Assert.assertTrue((boolean)true);
            }
            catch (IllegalStateException ex) {
                Assert.assertTrue((boolean)false);
            }
        }
    }

    @Test(groups={"standalone", "default_provider", "async"})
    public void asyncDoPostNullBytesTest() throws Throwable {
        try (AsyncHttpClient client = this.getAsyncHttpClient(null);){
            FluentCaseInsensitiveStringsMap h = new FluentCaseInsensitiveStringsMap();
            h.add("Content-Type", "application/x-www-form-urlencoded");
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < 5; ++i) {
                sb.append("param_");
                sb.append(i);
                sb.append("=value_");
                sb.append(i);
                sb.append("&");
            }
            sb.setLength(sb.length() - 1);
            ListenableFuture future = client.preparePost(this.getTargetUrl()).setHeaders(h).setBody(sb.toString()).execute((AsyncHandler)new AbstractBasicTest.AsyncCompletionHandlerAdapter());
            Response response = (Response)future.get();
            Assert.assertNotNull((Object)response);
            Assert.assertEquals((int)response.getStatusCode(), (int)HttpStatus.OK_200.getStatusCode());
        }
    }

    @Test(groups={"standalone", "default_provider", "async"})
    public void asyncDoPostListenerBytesTest() throws Throwable {
        try (AsyncHttpClient client = this.getAsyncHttpClient(null);){
            FluentCaseInsensitiveStringsMap h = new FluentCaseInsensitiveStringsMap();
            h.add("Content-Type", "application/x-www-form-urlencoded");
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < 5; ++i) {
                sb.append("param_");
                sb.append(i);
                sb.append("=value_");
                sb.append(i);
                sb.append("&");
            }
            sb.setLength(sb.length() - 1);
            final CountDownLatch l = new CountDownLatch(1);
            client.preparePost(this.getTargetUrl()).setHeaders(h).setBody(sb.toString()).execute((AsyncHandler)new AbstractBasicTest.AsyncCompletionHandlerAdapter(){

                @Override
                public Response onCompleted(Response response) throws Exception {
                    try {
                        Assert.assertEquals((int)response.getStatusCode(), (int)HttpStatus.OK_200.getStatusCode());
                    }
                    finally {
                        l.countDown();
                    }
                    return response;
                }
            });
            if (!l.await(30L, TimeUnit.SECONDS)) {
                Assert.fail((String)"Latch time out");
            }
        }
    }

    @Test(groups={"standalone", "default_provider", "async"})
    public void asyncConnectInvalidFuture() throws Throwable {
        try (AsyncHttpClient client = this.getAsyncHttpClient(null);){
            int dummyPort = this.findFreePort();
            final AtomicInteger count = new AtomicInteger();
            for (int i = 0; i < 20; ++i) {
                try {
                    Response response = (Response)client.preparePost(String.format("http://127.0.0.1:%d/", dummyPort)).execute((AsyncHandler)new AbstractBasicTest.AsyncCompletionHandlerAdapter(){

                        @Override
                        public void onThrowable(Throwable t) {
                            count.incrementAndGet();
                        }
                    }).get();
                    Assert.assertNull((Object)response, (String)"Should have thrown ExecutionException");
                    continue;
                }
                catch (ExecutionException ex) {
                    Throwable cause = ex.getCause();
                    if (cause instanceof ConnectException) continue;
                    Assert.fail((String)("Should have been caused by ConnectException, not by " + cause.getClass().getName()));
                }
            }
            Assert.assertEquals((int)count.get(), (int)20);
        }
    }

    @Test(groups={"standalone", "default_provider", "async"})
    public void asyncConnectInvalidPortFuture() throws Throwable {
        try (AsyncHttpClient client = this.getAsyncHttpClient(null);){
            int dummyPort = this.findFreePort();
            try {
                Response response = (Response)client.preparePost(String.format("http://127.0.0.1:%d/", dummyPort)).execute((AsyncHandler)new AbstractBasicTest.AsyncCompletionHandlerAdapter(){

                    @Override
                    public void onThrowable(Throwable t) {
                        t.printStackTrace();
                    }
                }).get();
                Assert.assertNull((Object)response, (String)"Should have thrown ExecutionException");
            }
            catch (ExecutionException ex) {
                Throwable cause = ex.getCause();
                if (!(cause instanceof ConnectException)) {
                    Assert.fail((String)("Should have been caused by ConnectException, not by " + cause.getClass().getName()));
                }
            }
        }
    }

    @Test(groups={"standalone", "default_provider", "async"})
    public void asyncConnectInvalidPort() throws Throwable {
        try (AsyncHttpClient client = this.getAsyncHttpClient(null);){
            int port = this.findFreePort();
            try {
                Response response = (Response)client.preparePost(String.format("http://127.0.0.1:%d/", port)).execute((AsyncHandler)new AbstractBasicTest.AsyncCompletionHandlerAdapter(){

                    @Override
                    public void onThrowable(Throwable t) {
                        t.printStackTrace();
                    }
                }).get();
                Assert.assertNull((Object)response, (String)"No ExecutionException was thrown");
            }
            catch (ExecutionException ex) {
                Assert.assertEquals(ex.getCause().getClass(), ConnectException.class);
            }
        }
    }

    @Test(groups={"standalone", "default_provider", "async"})
    public void asyncConnectInvalidHandlerPort() throws Throwable {
        try (AsyncHttpClient client = this.getAsyncHttpClient(null);){
            final CountDownLatch l = new CountDownLatch(1);
            int port = this.findFreePort();
            client.prepareGet(String.format("http://127.0.0.1:%d/", port)).execute((AsyncHandler)new AbstractBasicTest.AsyncCompletionHandlerAdapter(){

                @Override
                public void onThrowable(Throwable t) {
                    try {
                        Assert.assertEquals(t.getClass(), ConnectException.class);
                    }
                    finally {
                        l.countDown();
                    }
                }
            });
            if (!l.await(30L, TimeUnit.SECONDS)) {
                Assert.fail((String)"Timed out");
            }
        }
    }

    @Test(groups={"online", "default_provider", "async"}, expectedExceptions={ConnectException.class, UnresolvedAddressException.class, UnknownHostException.class})
    public void asyncConnectInvalidHandlerHost() throws Throwable {
        AsyncHttpClient client = this.getAsyncHttpClient(null);
        try {
            final AtomicReference e = new AtomicReference();
            final CountDownLatch l = new CountDownLatch(1);
            client.prepareGet("http://null.apache.org:9999/").execute((AsyncHandler)new AbstractBasicTest.AsyncCompletionHandlerAdapter(){

                @Override
                public void onThrowable(Throwable t) {
                    e.set(t);
                    l.countDown();
                }
            });
            if (!l.await(30L, TimeUnit.SECONDS)) {
                Assert.fail((String)"Timed out");
            }
            Assert.assertNotNull(e.get());
            throw (Throwable)e.get();
        }
        catch (Throwable throwable) {
            if (client != null) {
                try {
                    client.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            }
            throw throwable;
        }
    }

    @Test(groups={"standalone", "default_provider", "async"})
    public void asyncConnectInvalidFuturePort() throws Throwable {
        try (AsyncHttpClient client = this.getAsyncHttpClient(null);){
            final AtomicBoolean called = new AtomicBoolean(false);
            final AtomicBoolean rightCause = new AtomicBoolean(false);
            int port = this.findFreePort();
            try {
                Response response = (Response)client.prepareGet(String.format("http://127.0.0.1:%d/", port)).execute((AsyncHandler)new AbstractBasicTest.AsyncCompletionHandlerAdapter(){

                    @Override
                    public void onThrowable(Throwable t) {
                        called.set(true);
                        if (t instanceof ConnectException) {
                            rightCause.set(true);
                        }
                    }
                }).get();
                Assert.assertNull((Object)response, (String)"No ExecutionException was thrown");
            }
            catch (ExecutionException ex) {
                Assert.assertEquals(ex.getCause().getClass(), ConnectException.class);
            }
            Assert.assertTrue((boolean)called.get(), (String)"onThrowable should get called.");
            Assert.assertTrue((boolean)rightCause.get(), (String)"onThrowable should get called with ConnectionException");
        }
    }

    @Test(groups={"standalone", "default_provider", "async"})
    public void asyncContentLenghtGETTest() throws Throwable {
        try (AsyncHttpClient client = this.getAsyncHttpClient(null);){
            Response response = (Response)client.prepareGet(this.getTargetUrl()).execute((AsyncHandler)new AbstractBasicTest.AsyncCompletionHandlerAdapter(){

                @Override
                public void onThrowable(Throwable t) {
                    Assert.fail((String)"Unexpected exception", (Throwable)t);
                }
            }).get();
            Assert.assertNotNull((Object)response);
            Assert.assertEquals((int)response.getStatusCode(), (int)HttpStatus.OK_200.getStatusCode());
        }
    }

    @Test(groups={"standalone", "default_provider", "async"})
    public void asyncResponseBodyTooLarge() throws Throwable {
        try (AsyncHttpClient client = this.getAsyncHttpClient(null);){
            Response response = (Response)client.preparePost(this.getTargetUrl()).setBody("0123456789").execute((AsyncHandler)new AbstractBasicTest.AsyncCompletionHandlerAdapter(){

                @Override
                public void onThrowable(Throwable t) {
                    Assert.fail((String)"Unexpected exception", (Throwable)t);
                }
            }).get();
            Assert.assertNotNull((Object)response.getResponseBodyExcerpt(Integer.MAX_VALUE));
        }
    }

    @Test(groups={"standalone", "default_provider", "async"})
    public void asyncResponseEmptyBody() throws Throwable {
        try (AsyncHttpClient client = this.getAsyncHttpClient(null);){
            Response response = (Response)client.prepareGet(this.getTargetUrl()).execute((AsyncHandler)new AbstractBasicTest.AsyncCompletionHandlerAdapter(){

                @Override
                public void onThrowable(Throwable t) {
                    Assert.fail((String)"Unexpected exception", (Throwable)t);
                }
            }).get();
            Assert.assertEquals((String)response.getResponseBody(), (String)"");
        }
    }

    @Test(groups={"standalone", "default_provider", "asyncAPI"})
    public void asyncAPIContentLenghtGETTest() throws Throwable {
        try (AsyncHttpClient client = this.getAsyncHttpClient(null);){
            final CountDownLatch l = new CountDownLatch(1);
            client.prepareGet(this.getTargetUrl()).execute((AsyncHandler)new AbstractBasicTest.AsyncCompletionHandlerAdapter(){

                @Override
                public Response onCompleted(Response response) throws Exception {
                    try {
                        Assert.assertEquals((int)response.getStatusCode(), (int)HttpStatus.OK_200.getStatusCode());
                    }
                    finally {
                        l.countDown();
                    }
                    return response;
                }

                @Override
                public void onThrowable(Throwable t) {
                }
            });
            if (!l.await(30L, TimeUnit.SECONDS)) {
                Assert.fail((String)"Timed out");
            }
        }
    }

    @Test(groups={"standalone", "default_provider", "asyncAPI"})
    public void asyncAPIHandlerExceptionTest() throws Throwable {
        try (AsyncHttpClient client = this.getAsyncHttpClient(null);){
            final CountDownLatch l = new CountDownLatch(1);
            client.prepareGet(this.getTargetUrl()).execute((AsyncHandler)new AbstractBasicTest.AsyncCompletionHandlerAdapter(){

                @Override
                public Response onCompleted(Response response) throws Exception {
                    throw new IllegalStateException("FOO");
                }

                @Override
                public void onThrowable(Throwable t) {
                    try {
                        if (t.getMessage() != null) {
                            Assert.assertEquals((String)t.getMessage(), (String)"FOO");
                        }
                    }
                    finally {
                        l.countDown();
                    }
                }
            });
            if (!l.await(30L, TimeUnit.SECONDS)) {
                Assert.fail((String)"Timed out");
            }
        }
    }

    @Test(groups={"standalone", "default_provider", "async"})
    public void asyncDoGetDelayHandlerTest() throws Throwable {
        try (AsyncHttpClient client = this.getAsyncHttpClient(new AsyncHttpClientConfig.Builder().setRequestTimeout(5000).build());){
            FluentCaseInsensitiveStringsMap h = new FluentCaseInsensitiveStringsMap();
            h.add("LockThread", "true");
            final CountDownLatch l = new CountDownLatch(1);
            client.prepareGet(this.getTargetUrl()).setHeaders(h).execute((AsyncHandler)new AbstractBasicTest.AsyncCompletionHandlerAdapter(){

                @Override
                public Response onCompleted(Response response) throws Exception {
                    try {
                        Assert.fail((String)"Must not receive a response");
                    }
                    finally {
                        l.countDown();
                    }
                    return response;
                }

                @Override
                public void onThrowable(Throwable t) {
                    try {
                        if (t instanceof TimeoutException) {
                            Assert.assertTrue((boolean)true);
                        } else {
                            Assert.fail((String)"Unexpected exception", (Throwable)t);
                        }
                    }
                    finally {
                        l.countDown();
                    }
                }
            });
            if (!l.await(30L, TimeUnit.SECONDS)) {
                Assert.fail((String)"Timed out");
            }
        }
    }

    @Test(groups={"standalone", "default_provider", "async"})
    public void asyncDoGetQueryStringTest() throws Throwable {
        try (AsyncHttpClient client = this.getAsyncHttpClient(null);){
            final CountDownLatch l = new CountDownLatch(1);
            AbstractBasicTest.AsyncCompletionHandlerAdapter handler = new AbstractBasicTest.AsyncCompletionHandlerAdapter(){

                @Override
                public Response onCompleted(Response response) throws Exception {
                    try {
                        Assert.assertTrue((response.getHeader("X-pathInfo") != null ? 1 : 0) != 0);
                        Assert.assertTrue((response.getHeader("X-queryString") != null ? 1 : 0) != 0);
                    }
                    finally {
                        l.countDown();
                    }
                    return response;
                }
            };
            Request req = new RequestBuilder("GET").setUrl(this.getTargetUrl() + "?foo=bar").build();
            client.executeRequest(req, (AsyncHandler)handler).get();
            if (!l.await(30L, TimeUnit.SECONDS)) {
                Assert.fail((String)"Timed out");
            }
        }
    }

    @Test(groups={"standalone", "default_provider", "async"})
    public void asyncDoGetKeepAliveHandlerTest() throws Throwable {
        try (AsyncHttpClient client = this.getAsyncHttpClient(null);){
            final CountDownLatch l = new CountDownLatch(2);
            AbstractBasicTest.AsyncCompletionHandlerAdapter handler = new AbstractBasicTest.AsyncCompletionHandlerAdapter(){
                String remoteAddr = null;

                @Override
                public Response onCompleted(Response response) throws Exception {
                    Assert.assertEquals((int)response.getStatusCode(), (int)HttpStatus.OK_200.getStatusCode());
                    if (this.remoteAddr == null) {
                        this.remoteAddr = response.getHeader("X-KEEP-ALIVE");
                        l.countDown();
                    } else {
                        Assert.assertEquals((String)response.getHeader("X-KEEP-ALIVE"), (String)this.remoteAddr);
                        l.countDown();
                    }
                    return response;
                }
            };
            client.prepareGet(this.getTargetUrl()).execute((AsyncHandler)handler).get();
            client.prepareGet(this.getTargetUrl()).execute((AsyncHandler)handler);
            if (!l.await(30L, TimeUnit.SECONDS)) {
                Assert.fail((String)"Timed out");
            }
        }
    }

    @Test(groups={"online", "default_provider", "async"})
    public void asyncDoGetMaxRedirectTest() throws Throwable {
        try (AsyncHttpClient client = this.getAsyncHttpClient(new AsyncHttpClientConfig.Builder().setMaxRedirects(0).setFollowRedirect(true).build());){
            final CountDownLatch l = new CountDownLatch(1);
            AbstractBasicTest.AsyncCompletionHandlerAdapter handler = new AbstractBasicTest.AsyncCompletionHandlerAdapter(){

                @Override
                public Response onCompleted(Response response) throws Exception {
                    Assert.fail((String)"Should not be here");
                    return response;
                }

                @Override
                public void onThrowable(Throwable t) {
                    t.printStackTrace();
                    try {
                        Assert.assertEquals(t.getClass(), MaxRedirectException.class);
                    }
                    finally {
                        l.countDown();
                    }
                }
            };
            client.prepareGet("http://google.com/").execute((AsyncHandler)handler);
            if (!l.await(30L, TimeUnit.SECONDS)) {
                Assert.fail((String)"Timed out");
            }
        }
    }

    @Test(groups={"online", "default_provider", "async"})
    public void asyncDoGetNestedTest() throws Throwable {
        try (final AsyncHttpClient client = this.getAsyncHttpClient(new AsyncHttpClientConfig.Builder().build());){
            final CountDownLatch l = new CountDownLatch(2);
            AbstractBasicTest.AsyncCompletionHandlerAdapter handler = new AbstractBasicTest.AsyncCompletionHandlerAdapter(){
                private static final int MAX_NESTED = 2;
                private AtomicInteger nestedCount = new AtomicInteger(0);

                @Override
                public Response onCompleted(Response response) throws Exception {
                    try {
                        if (this.nestedCount.getAndIncrement() < 2) {
                            System.out.println("Executing a nested request: " + this.nestedCount);
                            client.prepareGet("http://google.com/").execute((AsyncHandler)this);
                        }
                    }
                    finally {
                        l.countDown();
                    }
                    return response;
                }

                @Override
                public void onThrowable(Throwable t) {
                    t.printStackTrace();
                }
            };
            client.prepareGet("http://www.google.com/").execute((AsyncHandler)handler);
            if (!l.await(30L, TimeUnit.SECONDS)) {
                Assert.fail((String)"Timed out");
            }
        }
    }

    @Test(groups={"online", "default_provider", "async"})
    public void asyncDoGetStreamAndBodyTest() throws Throwable {
        try (AsyncHttpClient client = this.getAsyncHttpClient(new AsyncHttpClientConfig.Builder().build());){
            Response r = (Response)client.prepareGet("http://www.google.com/").execute().get();
            r.getResponseBody();
            r.getResponseBodyAsStream();
        }
    }

    @Test(groups={"online", "default_provider", "async"})
    public void asyncUrlWithoutPathTest() throws Throwable {
        try (AsyncHttpClient client = this.getAsyncHttpClient(new AsyncHttpClientConfig.Builder().build());){
            Response r = (Response)client.prepareGet("http://www.google.com").execute().get();
            r.getResponseBody();
            r.getResponseBodyAsStream();
        }
    }

    @Test(groups={"default_provider", "async"})
    public void optionsTest() throws Throwable {
        try (AsyncHttpClient client = this.getAsyncHttpClient(new AsyncHttpClientConfig.Builder().build());){
            Response r = (Response)client.prepareOptions(this.getTargetUrl()).execute().get();
            Assert.assertEquals((int)r.getStatusCode(), (int)HttpStatus.OK_200.getStatusCode());
            Assert.assertEquals((String)r.getHeader("Allow"), (String)"GET,HEAD,POST,OPTIONS,TRACE");
        }
    }

    @Test(groups={"online", "default_provider"})
    public void testAwsS3() throws Exception {
        try (AsyncHttpClient client = this.getAsyncHttpClient(new AsyncHttpClientConfig.Builder().build());){
            Response response = (Response)client.prepareGet("http://test.s3.amazonaws.com/").execute().get();
            if (!MiscUtils.isNonEmpty((String)response.getResponseBody())) {
                Assert.fail((String)"No response Body");
            } else {
                Assert.assertEquals((int)response.getStatusCode(), (int)403);
            }
        }
    }

    @Test(groups={"online", "default_provider"})
    public void testAsyncHttpProviderConfig() throws Exception {
        try (AsyncHttpClient client = this.getAsyncHttpClient(new AsyncHttpClientConfig.Builder().setAsyncHttpClientProviderConfig(this.getProviderConfig()).build());){
            Response response = (Response)client.prepareGet("http://test.s3.amazonaws.com/").execute().get();
            if (!MiscUtils.isNonEmpty((String)response.getResponseBody())) {
                Assert.fail((String)"No response Body");
            } else {
                Assert.assertEquals((int)response.getStatusCode(), (int)403);
            }
        }
    }

    @Test(groups={"standalone", "default_provider"})
    public void idleRequestTimeoutTest() throws Exception {
        try (AsyncHttpClient client = this.getAsyncHttpClient(new AsyncHttpClientConfig.Builder().setPooledConnectionIdleTimeout(5000).setRequestTimeout(10000).build());){
            FluentCaseInsensitiveStringsMap h = new FluentCaseInsensitiveStringsMap();
            h.add("Content-Type", "application/x-www-form-urlencoded");
            h.add("LockThread", "true");
            long t1 = DateUtils.millisTime();
            try {
                client.prepareGet(this.getTargetUrl()).setHeaders(h).setUrl(this.getTargetUrl()).execute((AsyncHandler)new AbstractBasicTest.AsyncHandlerAdapter(){

                    @Override
                    public void onThrowable(Throwable t) {
                    }
                }).get();
                Assert.fail();
            }
            catch (Throwable ex) {
                long elapsedTime = DateUtils.millisTime() - t1;
                System.out.println("EXPIRED: " + elapsedTime);
                Assert.assertNotNull((Object)ex.getCause());
                Assert.assertTrue((elapsedTime >= 10000L && elapsedTime <= 25000L ? 1 : 0) != 0);
            }
        }
    }

    @Test(groups={"standalone", "default_provider", "async"})
    public void asyncDoPostCancelTest() throws Throwable {
        try (AsyncHttpClient client = this.getAsyncHttpClient(null);){
            FluentCaseInsensitiveStringsMap h = new FluentCaseInsensitiveStringsMap();
            h.add("Content-Type", "application/x-www-form-urlencoded");
            h.add("LockThread", "true");
            StringBuilder sb = new StringBuilder();
            sb.append("LockThread=true");
            final AtomicReference ex = new AtomicReference();
            ex.set(null);
            try {
                ListenableFuture future = client.preparePost(this.getTargetUrl()).setHeaders(h).setBody(sb.toString()).execute((AsyncHandler)new AbstractBasicTest.AsyncCompletionHandlerAdapter(){

                    @Override
                    public void onThrowable(Throwable t) {
                        if (t instanceof CancellationException) {
                            ex.set((CancellationException)t);
                        }
                        t.printStackTrace();
                    }
                });
                Thread.sleep(1000L);
                future.cancel(true);
            }
            catch (IllegalStateException ise) {
                Assert.fail();
            }
            Assert.assertNotNull(ex.get());
        }
    }

    protected String getBrokenTargetUrl() {
        return String.format("http:127.0.0.1:%d/foo/test", this.port1);
    }

    @Test(groups={"standalone", "default_provider"}, expectedExceptions={NullPointerException.class})
    public void invalidUri() throws Exception {
        try (AsyncHttpClient client = this.getAsyncHttpClient(null);){
            client.prepareGet(this.getBrokenTargetUrl());
        }
    }

    @Test(groups={"standalone", "default_provider"})
    public void asyncHttpClientConfigBeanTest() throws Exception {
        try (AsyncHttpClient client = this.getAsyncHttpClient((AsyncHttpClientConfig)new AsyncHttpClientConfigBean().setUserAgent("test"));){
            AsyncHttpClient.BoundRequestBuilder builder = client.prepareGet(this.getTargetUrl());
            Response r = (Response)client.executeRequest(builder.build()).get();
            Assert.assertEquals((int)HttpStatus.OK_200.getStatusCode(), (int)r.getStatusCode());
        }
    }

    @Test(groups={"default_provider", "async"})
    public void bodyAsByteTest() throws Throwable {
        try (AsyncHttpClient client = this.getAsyncHttpClient(new AsyncHttpClientConfig.Builder().build());){
            Response r = (Response)client.prepareGet(this.getTargetUrl()).execute().get();
            Assert.assertEquals((int)r.getStatusCode(), (int)HttpStatus.OK_200.getStatusCode());
            Assert.assertEquals((byte[])r.getResponseBodyAsBytes(), (byte[])new byte[0]);
        }
    }

    @Test(groups={"default_provider", "async"})
    public void mirrorByteTest() throws Throwable {
        try (AsyncHttpClient client = this.getAsyncHttpClient(null);){
            Response r = (Response)client.preparePost(this.getTargetUrl()).setBody("MIRROR").execute().get();
            Assert.assertEquals((int)r.getStatusCode(), (int)HttpStatus.OK_200.getStatusCode());
            Assert.assertEquals((String)new String(r.getResponseBodyAsBytes(), "UTF-8"), (String)"MIRROR");
        }
    }

    @Test
    public void requestingPlainHttpEndpointOverHttpsThrowsSslException() throws Throwable {
        try (AsyncHttpClient client = this.getAsyncHttpClient(null);){
            client.prepareGet(this.getTargetUrl().replace("http", "https")).execute().get();
            Assert.fail((String)"Request shouldn't succeed");
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            Assert.assertTrue((boolean)(cause instanceof ConnectException), (String)("Cause should be a ConnectException but got a " + cause.getClass().getName()));
            Throwable rootCause = e.getCause().getCause();
            Assert.assertTrue((boolean)(rootCause instanceof SSLException), (String)("Root cause should be a SslException but got a " + rootCause.getClass().getName()));
        }
    }

    @Test(groups={"standalone", "default_provider", "async"})
    public void asyncResponseWithUpgradeAndContentTest() throws Throwable {
        try (AsyncHttpClient client = this.getAsyncHttpClient(null);){
            final CountDownLatch l = new CountDownLatch(1);
            FluentCaseInsensitiveStringsMap h = new FluentCaseInsensitiveStringsMap();
            h.add("Y-Upgrade", "h2,h2c");
            client.prepareGet(this.getTargetUrl()).setHeaders(h).execute((AsyncHandler)new AbstractBasicTest.AsyncCompletionHandlerAdapter(){

                @Override
                public Response onCompleted(Response response) throws Exception {
                    try {
                        Assert.assertEquals((int)response.getStatusCode(), (int)HttpStatus.OK_200.getStatusCode());
                        Assert.assertEquals((String)response.getHeader("Upgrade"), (String)"h2,h2c");
                    }
                    finally {
                        l.countDown();
                    }
                    return response;
                }
            }).get();
            if (!l.await(30L, TimeUnit.SECONDS)) {
                Assert.fail((String)"Timeout out");
            }
        }
    }

    protected abstract AsyncHttpProviderConfig<?, ?> getProviderConfig();
}

