/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.providers.grizzly;

import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.ProxyServer;
import com.ning.http.client.Realm;
import com.ning.http.client.Request;
import com.ning.http.client.providers.grizzly.GrizzlyAsyncHttpProvider;
import com.ning.http.client.providers.grizzly.GrizzlyAsyncHttpProviderConfig;
import com.ning.http.client.providers.grizzly.Utils;
import com.ning.http.client.uri.Uri;
import com.ning.http.util.ProxyUtils;
import com.ning.http.util.StringUtils;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.ConnectorHandler;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.GrizzlyFuture;
import org.glassfish.grizzly.attributes.Attribute;
import org.glassfish.grizzly.attributes.AttributeStorage;
import org.glassfish.grizzly.connectionpool.ConnectionInfo;
import org.glassfish.grizzly.connectionpool.Endpoint;
import org.glassfish.grizzly.connectionpool.MultiEndpointPool;
import org.glassfish.grizzly.connectionpool.SingleEndpointPool;
import org.glassfish.grizzly.nio.transport.TCPNIOConnectorHandler;
import org.glassfish.grizzly.nio.transport.TCPNIOTransport;
import org.glassfish.grizzly.utils.Exceptions;

class ConnectionManager {
    private static final Attribute<Boolean> IS_NOT_KEEP_ALIVE = Grizzly.DEFAULT_ATTRIBUTE_BUILDER.createAttribute(ConnectionManager.class.getName() + ".is-not-keepalive");
    private final boolean poolingEnabled;
    private final MultiEndpointPool<SocketAddress> pool;
    private final TCPNIOTransport transport;
    private final TCPNIOConnectorHandler defaultConnectionHandler;
    private final AsyncHttpClientConfig config;
    private final boolean poolingSSLConnections;
    private final Map<String, Endpoint> endpointMap = new ConcurrentHashMap<String, Endpoint>();

    ConnectionManager(GrizzlyAsyncHttpProvider provider, TCPNIOTransport transport, GrizzlyAsyncHttpProviderConfig providerConfig) {
        this.transport = transport;
        this.config = provider.getClientConfig();
        this.poolingEnabled = this.config.isAllowPoolingConnections();
        this.poolingSSLConnections = this.config.isAllowPoolingSslConnections();
        this.defaultConnectionHandler = TCPNIOConnectorHandler.builder((TCPNIOTransport)transport).build();
        if (providerConfig != null && providerConfig.getConnectionPool() != null) {
            this.pool = providerConfig.getConnectionPool();
        } else if (this.poolingEnabled) {
            MultiEndpointPool.Builder builder = MultiEndpointPool.builder(SocketAddress.class).connectTimeout((long)this.config.getConnectTimeout(), TimeUnit.MILLISECONDS).asyncPollTimeout((long)this.config.getConnectTimeout(), TimeUnit.MILLISECONDS).maxConnectionsTotal(this.config.getMaxConnections()).maxConnectionsPerEndpoint(this.config.getMaxConnectionsPerHost()).keepAliveTimeout((long)this.config.getPooledConnectionIdleTimeout(), TimeUnit.MILLISECONDS).keepAliveCheckInterval(1L, TimeUnit.SECONDS).connectorHandler((ConnectorHandler)this.defaultConnectionHandler).connectionTTL((long)this.config.getConnectionTTL(), TimeUnit.MILLISECONDS).failFastWhenMaxSizeReached(true);
            if (!this.poolingSSLConnections) {
                builder.endpointPoolCustomizer((MultiEndpointPool.EndpointPoolCustomizer)new NoSSLPoolCustomizer());
            }
            this.pool = builder.build();
        } else {
            this.pool = MultiEndpointPool.builder(SocketAddress.class).connectTimeout((long)this.config.getConnectTimeout(), TimeUnit.MILLISECONDS).asyncPollTimeout((long)this.config.getConnectTimeout(), TimeUnit.MILLISECONDS).maxConnectionsTotal(this.config.getMaxConnections()).maxConnectionsPerEndpoint(this.config.getMaxConnectionsPerHost()).keepAliveTimeout(0L, TimeUnit.MILLISECONDS).connectorHandler((ConnectorHandler)this.defaultConnectionHandler).failFastWhenMaxSizeReached(true).build();
        }
    }

    void openAsync(Request request, CompletionHandler<Connection> completionHandler) throws IOException {
        int port;
        String host;
        String scheme;
        ProxyServer proxy = ProxyUtils.getProxyServer(this.config, request);
        if (proxy != null) {
            scheme = proxy.getProtocol().getProtocol();
            host = proxy.getHost();
            port = ConnectionManager.getPort(scheme, proxy.getPort());
        } else {
            Uri uri = request.getUri();
            scheme = uri.getScheme();
            host = uri.getHost();
            port = ConnectionManager.getPort(scheme, uri.getPort());
        }
        String partitionId = ConnectionManager.getPartitionId(request.getInetAddress(), request, proxy);
        Endpoint endpoint = this.endpointMap.get(partitionId);
        if (endpoint == null) {
            boolean isSecure = Utils.isSecure(scheme);
            endpoint = new AhcEndpoint(partitionId, isSecure, request.getInetAddress(), host, port, request.getLocalAddress(), (ConnectorHandler)this.defaultConnectionHandler);
            this.endpointMap.put(partitionId, endpoint);
        }
        this.pool.take(endpoint, completionHandler);
    }

    Connection openSync(Request request) throws IOException {
        Connection c;
        int port;
        String host;
        String scheme;
        ProxyServer proxy = ProxyUtils.getProxyServer(this.config, request);
        if (proxy != null) {
            scheme = proxy.getProtocol().getProtocol();
            host = proxy.getHost();
            port = ConnectionManager.getPort(scheme, proxy.getPort());
        } else {
            Uri uri = request.getUri();
            scheme = uri.getScheme();
            host = uri.getHost();
            port = ConnectionManager.getPort(scheme, uri.getPort());
        }
        boolean isSecure = Utils.isSecure(scheme);
        String partitionId = ConnectionManager.getPartitionId(request.getInetAddress(), request, proxy);
        Endpoint endpoint = this.endpointMap.get(partitionId);
        if (endpoint == null) {
            endpoint = new AhcEndpoint(partitionId, isSecure, request.getInetAddress(), host, port, request.getLocalAddress(), (ConnectorHandler)this.defaultConnectionHandler);
            this.endpointMap.put(partitionId, endpoint);
        }
        if ((c = this.pool.poll(endpoint)) == null) {
            GrizzlyFuture future = this.defaultConnectionHandler.connect((SocketAddress)new InetSocketAddress(host, port), (SocketAddress)(request.getLocalAddress() != null ? new InetSocketAddress(request.getLocalAddress(), 0) : null));
            int cTimeout = this.config.getConnectTimeout();
            try {
                c = cTimeout > 0 ? (Connection)future.get(cTimeout, TimeUnit.MILLISECONDS) : (Connection)future.get();
            }
            catch (ExecutionException ee) {
                throw Exceptions.makeIOException((Throwable)ee.getCause());
            }
            catch (Exception e) {
                throw Exceptions.makeIOException((Throwable)e);
            }
            finally {
                future.cancel(false);
            }
        }
        assert (c != null);
        return c;
    }

    boolean returnConnection(Connection c) {
        return this.pool.release(c);
    }

    void destroy() {
        this.pool.close();
    }

    boolean isReadyInPool(Connection c) {
        ConnectionInfo ci = this.pool.getConnectionInfo(c);
        return ci != null && ci.isReady();
    }

    static boolean isKeepAlive(Connection connection) {
        return !IS_NOT_KEEP_ALIVE.isSet((AttributeStorage)connection);
    }

    private static String getPartitionId(InetAddress overrideAddress, Request request, ProxyServer proxyServer) {
        String partitionId = (overrideAddress != null ? overrideAddress.toString() + "_" : "") + request.getConnectionPoolPartitioning().getPartitionKey(request.getUri(), proxyServer).toString();
        if (request.getRealm() != null && request.getRealm().getScheme().equals((Object)Realm.AuthScheme.NTLM)) {
            Realm requestRealm = request.getRealm();
            String partitionIdCredentialsTail = requestRealm.getPrincipal().concat(requestRealm.getPrincipal()).concat(requestRealm.getPassword()).concat(requestRealm.getNtlmDomain()).concat(requestRealm.getNtlmHost());
            try {
                MessageDigest sha256Digester = MessageDigest.getInstance("SHA-256");
                sha256Digester.update(partitionIdCredentialsTail.getBytes(Charset.forName("UTF-8")));
                partitionIdCredentialsTail = StringUtils.toHexString(sha256Digester.digest());
                partitionId = partitionId.concat(partitionIdCredentialsTail);
            }
            catch (NoSuchAlgorithmException e) {
                e.printStackTrace();
            }
        }
        return partitionId;
    }

    private static int getPort(String scheme, int p) {
        int port = p;
        if (port == -1) {
            String protocol = scheme.toLowerCase(Locale.ENGLISH);
            if ("http".equals(protocol) || "ws".equals(protocol)) {
                port = 80;
            } else if ("https".equals(protocol) || "wss".equals(protocol)) {
                port = 443;
            } else {
                throw new IllegalArgumentException("Unknown protocol: " + protocol);
            }
        }
        return port;
    }

    private class NoSSLPoolCustomizer
    implements MultiEndpointPool.EndpointPoolCustomizer<SocketAddress> {
        private NoSSLPoolCustomizer() {
        }

        public void customize(Endpoint<SocketAddress> endpoint, MultiEndpointPool.EndpointPoolBuilder<SocketAddress> builder) {
            AhcEndpoint ahcEndpoint = (AhcEndpoint)endpoint;
            if (ahcEndpoint.isSecure()) {
                builder.keepAliveTimeout(0L, TimeUnit.SECONDS);
            }
        }
    }

    private class AhcEndpoint
    extends Endpoint<SocketAddress> {
        private final String partitionId;
        private final boolean isSecure;
        private final InetAddress remoteOverrideAddress;
        private final String host;
        private final int port;
        private final InetAddress localAddress;
        private final ConnectorHandler<SocketAddress> connectorHandler;

        private AhcEndpoint(String partitionId, boolean isSecure, InetAddress remoteOverrideAddress, String host, int port, InetAddress localAddress, ConnectorHandler<SocketAddress> connectorHandler) {
            this.partitionId = partitionId;
            this.isSecure = isSecure;
            this.remoteOverrideAddress = remoteOverrideAddress;
            this.host = host;
            this.port = port;
            this.localAddress = localAddress;
            this.connectorHandler = connectorHandler;
        }

        public boolean isSecure() {
            return this.isSecure;
        }

        public Object getId() {
            return this.partitionId;
        }

        public GrizzlyFuture<Connection> connect() {
            return (GrizzlyFuture)this.connectorHandler.connect((Object)this.buildRemoteSocketAddress(), (Object)(this.localAddress != null ? new InetSocketAddress(this.localAddress, 0) : null));
        }

        private InetSocketAddress buildRemoteSocketAddress() {
            return this.remoteOverrideAddress != null ? new InetSocketAddress(this.remoteOverrideAddress, this.port) : new InetSocketAddress(this.host, this.port);
        }

        protected void onConnect(Connection connection, SingleEndpointPool<SocketAddress> pool) {
            if (pool.getKeepAliveTimeout(TimeUnit.MILLISECONDS) == 0L) {
                IS_NOT_KEEP_ALIVE.set((AttributeStorage)connection, (Object)Boolean.TRUE);
            }
        }

        public GrizzlyFuture<Connection> connect(CompletionHandler<Connection> completionHandler) {
            return (GrizzlyFuture)this.connectorHandler.connect((Object)this.buildRemoteSocketAddress(), (Object)(this.localAddress != null ? new InetSocketAddress(this.localAddress, 0) : null), completionHandler, true, true);
        }
    }
}

